/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramDecoratorHandler;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramLinkType;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class DiagramEditorUtil {
    private static final DiagramEditor[] EMPTY_DIAGRAM_EDITOR_ARRAY = new DiagramEditor[0];

    public static DiagramModelNode getCurrentRootModelNode() {
        DiagramEditor de = DiagramEditorUtil.getVisibleDiagramEditor();
        if (de != null) {
            return de.getCurrentModel();
        }
        return null;
    }

    public static Diagram getCurrentVisibleDiagram() {
        DiagramEditor de = DiagramEditorUtil.getVisibleDiagramEditor();
        if (de != null && de.getCurrentModel() != null) {
            return (Diagram)de.getCurrentModel().getModelObject();
        }
        return null;
    }

    public static EObject getCurrentVisibleDiagramTarget() {
        Diagram diagram = DiagramEditorUtil.getCurrentVisibleDiagram();
        if (diagram != null) {
            return diagram.getTarget();
        }
        return null;
    }

    public static void fireDiagramPropertyChange(String propId) {
        DiagramModelNode dmn = DiagramEditorUtil.getCurrentRootModelNode();
        if (dmn != null) {
            dmn.update(propId);
        }
    }

    public static DiagramEditor[] getInitializedDiagramEditors() {
        ArrayList<IEditorPart> rv = new ArrayList<IEditorPart>();
        Collection resources = ModelEditorManager.getOpenResources();
        for (IFile res : resources) {
            ModelEditor me = ModelEditorManager.getModelEditorForFile((IFile)res, (boolean)false);
            if (me == null) continue;
            List editors = me.getAllEditors();
            int i = 0;
            while (i < editors.size()) {
                IEditorPart editor = (IEditorPart)editors.get(i);
                if (editor instanceof DiagramEditor && editor.getEditorSite() != null) {
                    rv.add(editor);
                }
                ++i;
            }
        }
        return rv.toArray(EMPTY_DIAGRAM_EDITOR_ARRAY);
    }

    public static DiagramEditor getVisibleDiagramEditor() {
        IEditorPart editor;
        IEditorPart activeEditor;
        IWorkbenchPage page = DiagramUiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
        if (page != null && (activeEditor = page.getActiveEditor()) instanceof ModelEditor && (editor = ((ModelEditor)activeEditor).getCurrentPage()) != null && editor instanceof DiagramEditor) {
            return (DiagramEditor)editor;
        }
        return null;
    }

    public static DiagramEditor getDiagramEditor(Diagram diagram) {
        IWorkbenchPage page = DiagramUiPlugin.getDefault().getCurrentWorkbenchWindow().getActivePage();
        if (page != null) {
            IEditorReference[] activeEditorReferences = page.getEditorReferences();
            int i = 0;
            while (i < activeEditorReferences.length) {
                Diagram editorDiagram;
                IEditorPart editor;
                IEditorPart theEditor = activeEditorReferences[i].getEditor(false);
                if (theEditor != null && theEditor instanceof ModelEditor && (editor = ((ModelEditor)theEditor).getCurrentPage()) != null && editor instanceof DiagramEditor && (editorDiagram = ((DiagramEditor)editor).getDiagram()) != null && diagram == editorDiagram) {
                    return (DiagramEditor)editor;
                }
                ++i;
            }
        }
        return null;
    }

    public static double getCurrentZoomFactor() {
        DiagramEditor de = DiagramEditorUtil.getVisibleDiagramEditor();
        if (de != null) {
            return de.getCurrentZoomFactor();
        }
        return 1.0;
    }

    public static NodeConnectionEditPart getSelectedLink() {
        Object selectedEP;
        List selectedEPs;
        DiagramEditor de = DiagramEditorUtil.getVisibleDiagramEditor();
        if (de != null && !(selectedEPs = de.getDiagramViewer().getSelectedEditParts()).isEmpty() && selectedEPs.size() == 1 && (selectedEP = selectedEPs.get(0)) instanceof NodeConnectionEditPart) {
            return (NodeConnectionEditPart)selectedEP;
        }
        return null;
    }

    public static int getCurrentDiagramRouterStyle() {
        Diagram diagram;
        int iRouter = DiagramUiUtilities.getCurrentRouterStyle();
        DiagramModelNode dmn = DiagramEditorUtil.getCurrentRootModelNode();
        if (dmn != null && (diagram = (Diagram)dmn.getModelObject()) != null) {
            DiagramLinkType dlt = diagram.getLinkType();
            iRouter = dlt != null ? dlt.getValue() : DiagramUiUtilities.getCurrentRouterStyle();
        }
        return iRouter;
    }

    public static List getCurrentDiagramNodeEObjects() {
        ArrayList<EObject> contents = new ArrayList<EObject>();
        DiagramEditor de = DiagramEditorUtil.getVisibleDiagramEditor();
        if (de != null) {
            List children = de.getCurrentModel().getChildren();
            Iterator iter = children.iterator();
            Object nextObj = null;
            while (iter.hasNext()) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramModelNode) || nextObj instanceof NodeConnectionModel) continue;
                contents.add(((DiagramModelNode)nextObj).getModelObject());
            }
        }
        if (contents.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return contents;
    }

    public static boolean setCurrentDiagramRouterStyle(int iRouter) {
        Diagram diagram;
        DiagramModelNode dmn;
        boolean succeeded = false;
        int currentRouter = DiagramEditorUtil.getCurrentDiagramRouterStyle();
        if (iRouter != currentRouter && (dmn = DiagramEditorUtil.getCurrentRootModelNode()) != null && (diagram = (Diagram)dmn.getModelObject()) != null) {
            boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Set Diagram Link Type", (Object)diagram);
            succeeded = false;
            try {
                DiagramLinkType theType = DiagramLinkType.get((int)iRouter);
                diagram.setLinkType(theType);
                succeeded = true;
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
        }
        return succeeded;
    }

    public static DiagramDecoratorHandler getDecoratorHandler() {
        DiagramEditor de = DiagramEditorUtil.getVisibleDiagramEditor();
        if (de != null) {
            return de.getDecoratorHandler();
        }
        return null;
    }

    public static int getErrorState(EObject eObj) {
        int errorState = 0;
        DiagramDecoratorHandler dh = DiagramEditorUtil.getDecoratorHandler();
        if (dh != null) {
            errorState = dh.getErrorState(eObj);
        }
        return errorState;
    }

    public static boolean isDiagramUnderConstruction(Diagram diagram) {
        DiagramEditPart diagramEP;
        DiagramEditor de = DiagramEditorUtil.getDiagramEditor(diagram);
        if (de != null && (diagramEP = (DiagramEditPart)de.getDiagramViewer().getContents()) != null) {
            return diagramEP.isUnderConstruction();
        }
        return false;
    }

    public static boolean setDiagramUnderConstruction(Diagram diagram) {
        DiagramEditPart diagramEP;
        DiagramEditor de = DiagramEditorUtil.getDiagramEditor(diagram);
        if (de != null && (diagramEP = (DiagramEditPart)de.getDiagramViewer().getContents()) != null) {
            diagramEP.setUnderConstruction(true);
            return true;
        }
        return false;
    }

    public static boolean setDiagramConstructionComplete(Diagram diagram, boolean updateLinkedParts) {
        DiagramEditPart diagramEP;
        DiagramEditor de = DiagramEditorUtil.getDiagramEditor(diagram);
        if (de != null && (diagramEP = (DiagramEditPart)de.getDiagramViewer().getContents()) != null) {
            diagramEP.constructionCompleted(updateLinkedParts);
            return true;
        }
        return false;
    }
}

