/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.editor.IDiagramSelectionHandler;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.EditableEditPart;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPart;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPartManager;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;

public class DiagramSelectionHandler
implements IDiagramSelectionHandler {
    private DiagramViewer viewer;
    private boolean clearHilites = true;

    public DiagramSelectionHandler(DiagramViewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public DiagramViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void deselectAll() {
        if (!this.getViewer().getSelectedEditParts().isEmpty()) {
            this.getViewer().deselectAll();
        }
    }

    @Override
    public void select(EObject selectedObject) {
        EditPart selectedPart = this.findEditPart(selectedObject, false);
        if (selectedPart != null) {
            this.deselectAll();
            this.getViewer().select(selectedPart);
        }
    }

    public void select(List selectedEObjects) {
        ArrayList<EditPart> selectedEPs = new ArrayList<EditPart>(selectedEObjects.size());
        Iterator iter = selectedEObjects.iterator();
        EObject nextEO = null;
        EditPart nextEP = null;
        while (iter.hasNext()) {
            nextEO = (EObject)iter.next();
            if (nextEO == null || (nextEP = this.findEditPart(nextEO, false)) == null) continue;
            selectedEPs.add(nextEP);
        }
        if (!selectedEPs.isEmpty()) {
            this.deselectAll();
            this.getViewer().select(selectedEPs);
        }
    }

    private boolean allSelectedAreEObjects(List objects) {
        Iterator iter = objects.iterator();
        Object obj = null;
        while (iter.hasNext()) {
            obj = iter.next();
            if (obj instanceof EObject) continue;
            return false;
        }
        return true;
    }

    @Override
    public List getSelectedEObjects() {
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        Iterator iter = this.getViewer().getSelectedEditParts().iterator();
        Object obj = null;
        EObject eObj = null;
        while (iter.hasNext()) {
            obj = iter.next();
            if (obj instanceof DiagramEditPart) {
                eObj = ((DiagramEditPart)obj).getModelObject();
                if (eObj == null || selectedEObjects.contains(eObj)) continue;
                selectedEObjects.add(eObj);
                continue;
            }
            if (!(obj instanceof NodeConnectionEditPart) || (eObj = ((NodeConnectionModel)((NodeConnectionEditPart)obj).getModel()).getModelObject()) == null || selectedEObjects.contains(eObj)) continue;
            selectedEObjects.add(eObj);
        }
        return selectedEObjects;
    }

    @Override
    public void select(ISelection selection) {
        if (SelectionUtilities.isEmptySelection((ISelection)selection)) {
            this.deselectAll();
            return;
        }
        List selectedObjects = SelectionUtilities.getSelectedObjects((ISelection)selection);
        if (this.allSelectedAreEObjects(selectedObjects)) {
            if (selectedObjects.size() == 1) {
                this.select((EObject)selectedObjects.iterator().next());
            } else {
                this.select(selectedObjects);
            }
        }
    }

    @Override
    public void clearDependencyHilites() {
        if (this.viewerContainsPart()) {
            List contents = this.getViewer().getRootEditPart().getChildren();
            Iterator iter = contents.iterator();
            Object nextObj = null;
            while (iter.hasNext()) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextObj).clearHiliting();
            }
        }
    }

    @Override
    public void hiliteDependencies(Object selectedObject) {
        this.clearDependencyHilites();
        if (selectedObject == null) {
            this.clearConnectionHilites();
        }
        if (selectedObject != null && selectedObject instanceof EObject) {
            List allDependencies;
            EObject selectedEObject = (EObject)selectedObject;
            EditPart selectedPart = this.findEditPart(selectedEObject, false);
            if (selectedPart != null && selectedPart instanceof DiagramEditPart && (allDependencies = ((DiagramEditPart)selectedPart).getDependencies()) != null) {
                Iterator iter = allDependencies.iterator();
                EditPart nextEP = null;
                EObject nextEObject = null;
                while (iter.hasNext()) {
                    nextEObject = (EObject)iter.next();
                    nextEP = this.findEditPart(nextEObject, false);
                    if (nextEP == null || !(nextEP instanceof DiagramEditPart)) continue;
                    ((DiagramEditPart)nextEP).hiliteBackground(DiagramUiConstants.Colors.DEPENDENCY);
                }
            }
        } else if (selectedObject != null && selectedObject instanceof NodeConnectionEditPart) {
            EditPart sourceEP = DiagramUiUtilities.getSourceEndEditPart((NodeConnectionEditPart)selectedObject);
            EditPart targetEP = DiagramUiUtilities.getTargetEndEditPart((NodeConnectionEditPart)selectedObject);
            if (sourceEP != null && sourceEP instanceof DiagramEditPart) {
                ((DiagramEditPart)sourceEP).hiliteBackground(DiagramUiConstants.Colors.DEPENDENCY);
            }
            if (targetEP != null && sourceEP instanceof DiagramEditPart) {
                ((DiagramEditPart)targetEP).hiliteBackground(DiagramUiConstants.Colors.DEPENDENCY);
            }
        }
    }

    @Override
    public void selectAndReveal(EObject selectedObject) {
    }

    @Override
    public EditPart findEditPart(EObject selectedObject, boolean linksAllowed) {
        Object matchingPart = null;
        if (this.viewerContainsPart()) {
            List contents = this.getViewer().getRootEditPart().getChildren();
            Iterator iter = contents.iterator();
            Object nextObj = null;
            while (iter.hasNext() && matchingPart == null) {
                nextObj = iter.next();
                if (linksAllowed) {
                    matchingPart = ((DiagramEditPart)nextObj).getEditPart(selectedObject, linksAllowed);
                    continue;
                }
                if (!(nextObj instanceof DiagramEditPart)) continue;
                matchingPart = selectedObject instanceof ModelAnnotation ? (DiagramEditPart)nextObj : ((DiagramEditPart)nextObj).getEditPart(selectedObject, linksAllowed);
            }
        }
        return matchingPart;
    }

    @Override
    public EditPart findDiagramChildEditPart(EObject selectedObject, boolean linksAllowed) {
        if (this.viewerContainsPart()) {
            List contents = this.getViewer().getRootEditPart().getChildren();
            Iterator iter = contents.iterator();
            Object diagramEP = null;
            while (iter.hasNext()) {
                diagramEP = iter.next();
                if (!(diagramEP instanceof EditPart)) continue;
                List dContents = ((EditPart)diagramEP).getChildren();
                Iterator innerIter = dContents.iterator();
                EditPart nextEP = null;
                while (innerIter.hasNext()) {
                    nextEP = (EditPart)innerIter.next();
                    if (!(nextEP instanceof DiagramEditPart) || !((DiagramEditPart)nextEP).getModelObject().equals(selectedObject)) continue;
                    return nextEP;
                }
            }
        }
        return null;
    }

    @Override
    public boolean handleDoubleClick(EObject selectedObject) {
        EditPart selectedEP;
        boolean handledHere = false;
        if (this.getViewer() != null && (selectedEP = this.findEditPart(selectedObject, false)) != null && selectedEP instanceof EditableEditPart) {
            UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ((EditableEditPart)selectedEP).edit();
                }
            });
            handledHere = true;
        }
        return handledHere;
    }

    @Override
    public String getDiagramType() {
        if (this.getViewer().getEditor().getDiagram() != null) {
            return this.getViewer().getEditor().getDiagram().getType();
        }
        return "UNKNOWN TYPE";
    }

    @Override
    public boolean shouldReveal(EObject eObject) {
        return true;
    }

    @Override
    public void hiliteConnection(NodeConnectionEditPart connectionEditPart) {
        this.clearConnectionHilites();
        connectionEditPart.hilite(true);
    }

    @Override
    public void clearConnectionHilites() {
        if (!this.clearHilites) {
            return;
        }
        if (this.viewerContainsPart()) {
            EditPart rootPart = this.getViewer().getRootEditPart().getContents();
            List contents = rootPart.getChildren();
            Iterator iter = contents.iterator();
            Object nextObj = null;
            while (iter.hasNext()) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramEditPart)) continue;
                List connections = ((DiagramEditPart)nextObj).getSourceConnections();
                Iterator innerIter = connections.iterator();
                Object nextConn = null;
                while (innerIter.hasNext()) {
                    nextConn = innerIter.next();
                    if (!(nextConn instanceof NodeConnectionEditPart)) continue;
                    ((NodeConnectionEditPart)nextConn).hilite(false);
                }
            }
        }
    }

    private boolean viewerContainsPart() {
        return this.viewer != null && this.viewer.getRootEditPart() != null && this.viewer.getRootEditPart().getContents() != null;
    }

    @Override
    public void setClearHilites(boolean clear) {
        this.clearHilites = clear;
    }

    @Override
    public void fireMouseExit() {
        if (this.viewerContainsPart()) {
            EditPart rootPart = this.getViewer().getRootEditPart().getContents();
            List contents = rootPart.getChildren();
            Iterator iter = contents.iterator();
            Object nextObj = null;
            DirectEditPartManager depm = null;
            while (iter.hasNext()) {
                nextObj = iter.next();
                if (!(nextObj instanceof DirectEditPart) || (depm = ((DirectEditPart)nextObj).getEditManager()) == null) continue;
                depm.commitAndDispose();
            }
        }
    }

    @Override
    public boolean shouldRename(EObject dClickedEObject) {
        return true;
    }

    @Override
    public void renameInline(EObject theSelectedEObject) {
        EditPart selectedEP;
        if (this.getViewer() != null && (selectedEP = this.findEditPart(theSelectedEObject, false)) != null && selectedEP instanceof DirectEditPart) {
            UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    ((DirectEditPart)selectedEP).performDirectEdit();
                }
            });
        }
    }
}

