/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.teiid.designer.ui.common.actions.AbstractAction;

public class DiagramToolBarManager
extends ToolBarManager {
    ActionContributionItem focusedToolItem;

    public DiagramToolBarManager(ToolBar paneToolBar) {
        super(paneToolBar);
        paneToolBar.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                Point thisPoint = new Point(e.x, e.y);
                DiagramToolBarManager.this.setFocusedToolItem(thisPoint);
            }
        });
        paneToolBar.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                DiagramToolBarManager.this.focusedToolItem = null;
            }

            public void mouseExit(MouseEvent e) {
                DiagramToolBarManager.this.focusedToolItem = null;
            }
        });
    }

    void setFocusedToolItem(Point currentPoint) {
        this.focusedToolItem = this.getActionContributionItem(currentPoint);
    }

    public void resetFocusedToolItem() {
        this.focusedToolItem = null;
    }

    public ActionContributionItem getFocusedToolItem() {
        return this.focusedToolItem;
    }

    public ActionContributionItem getActionContributionItem(AbstractAction theAction) {
        if (this.getControl() != null && this.getControl().getItemCount() > 0) {
            IContributionItem[] items = this.getItems();
            IContributionItem toolItem = null;
            ActionContributionItem nextACI = null;
            AbstractAction nextAction = null;
            int i = 0;
            while (i < this.getControl().getItems().length) {
                toolItem = items[i];
                nextACI = (ActionContributionItem)toolItem;
                nextAction = (AbstractAction)nextACI.getAction();
                if (nextAction.equals(theAction)) {
                    return nextACI;
                }
                ++i;
            }
        }
        return null;
    }

    public ActionContributionItem getActionContributionItem(Point somePoint) {
        int itemIndex = this.getToolItemIndex(somePoint);
        if (itemIndex < 0) {
            return null;
        }
        return this.getActionContributionItem(itemIndex);
    }

    public AbstractAction getAction(int toolItemIndex) {
        IContributionItem[] items;
        if (toolItemIndex >= 0 && toolItemIndex < (items = this.getItems()).length) {
            return (AbstractAction)((ActionContributionItem)items[toolItemIndex]).getAction();
        }
        return null;
    }

    public ToolItem getToolItem(Point point) {
        if (this.getControl() != null && this.getControl().getItemCount() > 0) {
            ToolItem toolItem = null;
            int i = 0;
            while (i < this.getControl().getItems().length) {
                toolItem = this.getControl().getItem(i);
                if (toolItem != null && toolItem.getBounds().contains(point)) {
                    return toolItem;
                }
                ++i;
            }
        }
        return null;
    }

    public ActionContributionItem getActionContributionItem(int toolItemIndex) {
        if (this.getControl() != null && this.getControl().getItemCount() > 0 && toolItemIndex >= 0) {
            IContributionItem[] items = this.getItems();
            ActionContributionItem nextACI = null;
            if (items[toolItemIndex] instanceof ActionContributionItem) {
                nextACI = (ActionContributionItem)items[toolItemIndex];
                return nextACI;
            }
        }
        return null;
    }

    public int getToolItemIndex(Point point) {
        if (this.getControl() != null && this.getControl().getItemCount() > 0) {
            ToolItem toolItem = null;
            int i = 0;
            while (i < this.getControl().getItems().length) {
                toolItem = this.getControl().getItem(i);
                if (toolItem != null && toolItem.getBounds().contains(point)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
        toolBar.layout();
        Composite parent = toolBar.getParent();
        parent.layout();
        if (parent.getParent() != null) {
            parent.getParent().layout();
        }
    }
}

