/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.util.WidgetUtil;

public class DiagramViewForm
extends Composite {
    private SashForm sash = new SashForm((Composite)this, 256);
    public int marginWidth = 0;
    public int marginHeight = 0;
    public static final RGB borderInsideRGB = new RGB(132, 130, 132);
    public static final RGB borderMiddleRGB = new RGB(143, 141, 138);
    public static final RGB borderOutsideRGB = new RGB(171, 168, 165);
    private ToolBar toolBar;
    private Control content;
    private Control control;
    private int drawLine2 = -1;
    private boolean showBorder = false;
    private int BORDER_TOP = 0;
    private int BORDER_BOTTOM = 0;
    private int BORDER_LEFT = 0;
    private int BORDER_RIGHT = 0;
    private Color borderColor1;
    private Color borderColor2;
    private Color borderColor3;
    private Rectangle oldArea;
    private static final int OFFSCREEN = -200;

    public DiagramViewForm(Composite parent, int style) {
        super(parent, DiagramViewForm.checkStyle(style));
        RowLayout layout = new RowLayout();
        this.sash.setLayout((Layout)layout);
        this.setContent((Control)this.sash);
        this.borderColor1 = GlobalUiColorManager.getColor((RGB)borderInsideRGB);
        this.borderColor2 = GlobalUiColorManager.getColor((RGB)borderMiddleRGB);
        this.borderColor3 = GlobalUiColorManager.getColor((RGB)borderOutsideRGB);
        this.setBorderVisible((style & 0x800) != 0);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                DiagramViewForm.this.onPaint(event.gc);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                DiagramViewForm.this.onResize();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                DiagramViewForm.this.onDispose();
            }
        });
    }

    private static int checkStyle(int style) {
        int mask = 0x800000;
        return style & mask | 0x100000;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point toolBarSize = new Point(0, 0);
        int wHintToolBar = 25;
        if (this.toolBar != null) {
            ToolItem firstItem = this.toolBar.getItem(0);
            if (firstItem != null) {
                wHintToolBar = firstItem.getWidth() + 4;
            }
            toolBarSize = this.toolBar.computeSize(wHintToolBar, hHint);
            ++toolBarSize.x;
        }
        Point size = new Point(0, 0);
        size.x = toolBarSize.x;
        size.y = toolBarSize.y + 1;
        if (this.content != null) {
            Point contentSize = new Point(0, 0);
            contentSize = this.content.computeSize(-1, -1);
            size.y = Math.max(size.y, contentSize.y);
            size.x += contentSize.x + 1;
        }
        size.x += 2 * this.marginWidth;
        size.y += 2 * this.marginHeight;
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int trimX = x - this.BORDER_LEFT;
        int trimY = y - this.BORDER_TOP;
        int trimWidth = width + this.BORDER_LEFT + this.BORDER_RIGHT;
        int trimHeight = height + this.BORDER_TOP + this.BORDER_BOTTOM;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle clientArea = super.getClientArea();
        clientArea.x += this.BORDER_LEFT;
        clientArea.y += this.BORDER_TOP;
        clientArea.width -= this.BORDER_LEFT + this.BORDER_RIGHT;
        clientArea.height -= this.BORDER_TOP + this.BORDER_BOTTOM;
        return clientArea;
    }

    public Control getContent() {
        return this.content;
    }

    public Control getControllerControl() {
        return this.control;
    }

    public Control getToolBar() {
        return this.toolBar;
    }

    public void layout(boolean changed) {
        this.checkWidget();
        Rectangle rect = this.getClientArea();
        this.drawLine2 = -1;
        int width = rect.x + this.marginWidth;
        Point toolBarSize = new Point(0, 0);
        if (this.toolBar != null && !this.toolBar.isDisposed()) {
            ToolItem firstItem;
            int wHintToolBar = 30;
            int count = this.toolBar.getItemCount();
            if (count > 0 && (firstItem = this.toolBar.getItem(0)) != null) {
                wHintToolBar = 30;
            }
            toolBarSize = this.toolBar.computeSize(wHintToolBar, -1);
            Rectangle rectFinal = new Rectangle(0, 0, 10, 10);
            rectFinal.x = rect.x + this.marginWidth;
            rectFinal.y = rect.y + 1 + this.marginHeight;
            rectFinal.width = toolBarSize.x;
            rectFinal.height = rect.height - 2 * this.marginHeight;
            this.toolBar.setBounds(rectFinal);
            this.drawLine2 = toolBarSize.x + 3;
            width = toolBarSize.x + 4;
        }
        if (this.content != null && !this.content.isDisposed()) {
            Rectangle rectFinal = new Rectangle(0, 0, 10, 10);
            rectFinal.x = width;
            rectFinal.y = rect.y + this.marginHeight;
            rectFinal.width = rect.x + rect.width - width - this.marginWidth;
            rectFinal.height = rect.height - 2 * this.marginHeight;
            this.content.setBounds(rectFinal);
        }
    }

    void onDispose() {
        this.borderColor1 = null;
        this.borderColor2 = null;
        this.borderColor3 = null;
        this.toolBar = null;
        this.content = null;
        this.oldArea = null;
    }

    void onPaint(GC gc) {
        int x;
        Rectangle d = super.getClientArea();
        if (this.showBorder) {
            if ((this.getStyle() & 0x800000) != 0) {
                gc.setForeground(this.borderColor1);
                gc.drawRectangle(d.x, d.y, d.x + d.width - 1, d.y + d.height - 1);
            } else {
                gc.setForeground(this.borderColor1);
                gc.drawRectangle(d.x, d.y, d.x + d.width - 3, d.y + d.height - 3);
                gc.setForeground(this.borderColor2);
                gc.drawLine(d.x + 1, d.y + d.height - 2, d.x + d.width - 1, d.y + d.height - 2);
                gc.drawLine(d.x + d.width - 2, d.y + 1, d.x + d.width - 2, d.y + d.height - 1);
                gc.setForeground(this.borderColor3);
                gc.drawLine(d.x + 2, d.y + d.height - 1, d.x + d.width - 2, d.y + d.height - 1);
                gc.drawLine(d.x + d.width - 1, d.y + 2, d.x + d.width - 1, d.y + d.height - 2);
            }
        }
        if (this.drawLine2 != -1) {
            gc.setForeground(this.borderColor1);
            int y1 = d.y + this.BORDER_TOP;
            int y2 = d.y + d.height - this.BORDER_BOTTOM;
            gc.drawLine(this.drawLine2, y1, this.drawLine2, y2);
        }
        if ((x = this.drawLine2) != -1) {
            gc.setForeground(this.getDisplay().getSystemColor(20));
            gc.drawLine(d.x + this.BORDER_LEFT + this.marginWidth, d.y + this.BORDER_TOP + this.marginHeight, x - 1, d.y + this.BORDER_TOP + this.marginHeight);
            gc.drawLine(d.x + this.BORDER_LEFT + this.marginWidth, d.y + this.BORDER_TOP + this.marginHeight, d.x + this.BORDER_LEFT + this.marginWidth, d.y + d.height - this.BORDER_BOTTOM - this.marginHeight - 1);
        }
        gc.setForeground(this.getForeground());
    }

    void onResize() {
        this.toolBar.pack();
        this.layout();
        Rectangle area = super.getClientArea();
        if (this.oldArea == null || this.oldArea.width == 0 || this.oldArea.height == 0) {
            this.redraw();
        } else {
            int width = 0;
            if (this.oldArea.width < area.width) {
                width = area.width - this.oldArea.width + this.BORDER_RIGHT;
            } else if (this.oldArea.width > area.width) {
                width = this.BORDER_RIGHT;
            }
            this.redraw(area.x + area.width - width, area.y, width, area.height, false);
            int height = 0;
            if (this.oldArea.height < area.height) {
                height = area.height - this.oldArea.height + this.BORDER_BOTTOM;
            }
            if (this.oldArea.height > area.height) {
                height = this.BORDER_BOTTOM;
            }
            this.redraw(area.x, area.y + area.height - height, area.width, height, false);
        }
        this.oldArea = area;
    }

    public void setContent(Control content) {
        this.checkWidget();
        if (this.content != null && !this.content.isDisposed()) {
            this.content.setBounds(-200, -200, 0, 0);
        }
        this.content = content;
        this.layout();
    }

    public void setControllerControl(Control newControl) {
        this.checkWidget();
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setBounds(-200, -200, 0, 0);
        }
        this.control = newControl;
        this.layout();
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (this.toolBar != null && !this.toolBar.isDisposed()) {
            this.toolBar.setFont(f);
        }
        this.layout();
    }

    public void setInitialSashFormWeights() {
        int[] weights = WidgetUtil.getSashFormWeights((SashForm)this.sash);
        if (weights.length == 2) {
            double d = (double)weights[0] / (double)weights[1] * 100.0;
            if (d < 30.0) {
                weights[0] = 30;
                weights[1] = 70;
            } else if (d > 40.0) {
                weights[0] = 40;
                weights[1] = 60;
            }
        }
        this.sash.setWeights(weights);
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setToolBar(Control c) {
        this.checkWidget();
        if (c != null && c.getParent() != this) {
            SWT.error((int)5);
        }
        if (this.toolBar != null && !this.toolBar.isDisposed()) {
            this.toolBar.setBounds(-200, -200, 0, 0);
        }
        this.toolBar = (ToolBar)c;
        this.layout();
    }

    public void setBorderVisible(boolean show) {
        this.checkWidget();
        if (this.showBorder == show) {
            return;
        }
        this.showBorder = show;
        if (this.showBorder) {
            if ((this.getStyle() & 0x800000) != 0) {
                this.BORDER_BOTTOM = 1;
                this.BORDER_RIGHT = 1;
                this.BORDER_TOP = 1;
                this.BORDER_LEFT = 1;
            } else {
                this.BORDER_TOP = 1;
                this.BORDER_LEFT = 1;
                this.BORDER_BOTTOM = 3;
                this.BORDER_RIGHT = 3;
            }
        } else {
            this.BORDER_RIGHT = 0;
            this.BORDER_LEFT = 0;
            this.BORDER_TOP = 0;
            this.BORDER_BOTTOM = 0;
        }
        this.layout();
        this.redraw();
    }

    public Control getSashForm() {
        return this.sash;
    }
}

