/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.editor;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.IDiagramType;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramKeyHandler;
import org.teiid.designer.diagram.ui.editor.IDiagramSelectionHandler;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramContentProvider;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class DiagramViewer
extends ScrollingGraphicalViewer {
    private PackageDiagramContentProvider packageDiagramProvider;
    private DiagramEditor editor;
    private boolean inFocus = false;

    public DiagramViewer(DiagramEditor editor) {
        this.editor = editor;
        this.packageDiagramProvider = new PackageDiagramContentProvider();
        this.setKeyHandler(new DiagramKeyHandler((GraphicalViewer)this));
    }

    protected void handleFocusGained(FocusEvent theFe) {
        super.handleFocusGained(theFe);
        this.inFocus = true;
    }

    protected void handleFocusLost(FocusEvent theFe) {
        super.handleFocusLost(theFe);
        this.inFocus = false;
    }

    public boolean hasFocus() {
        return this.inFocus;
    }

    public ITreeContentProvider getContentProvider() {
        return this.packageDiagramProvider;
    }

    public ISelection getSelection() {
        if (this.getSelectedEditParts().isEmpty() && this.getContents() != null) {
            IDiagramType idt;
            Object standinObject = null;
            Diagram currentDiagram = this.editor.getDiagram();
            if (currentDiagram != null && (idt = DiagramUiPlugin.getDiagramTypeManager().getDiagram(currentDiagram.getType())) != null) {
                standinObject = idt.getDiagramSelectionStandin(currentDiagram);
            }
            if (standinObject != null) {
                return new StructuredSelection(standinObject);
            }
            return super.getSelection();
        }
        return new StructuredSelection(this.getSelectedModelObjects());
    }

    private List getSelectedModelObjects() {
        Diagram oneDiagram;
        Object oneObject;
        ArrayList<Object> modelObjects = new ArrayList<Object>(this.getSelectedEditParts().size());
        List selectedEPs = this.getSelectedEditParts();
        boolean selectedDiagram = false;
        if (selectedEPs.size() == 1 && (oneObject = selectedEPs.get(0)) instanceof DiagramEditPart && ((DiagramEditPart)oneObject).getModelObject() instanceof Diagram && (oneDiagram = (Diagram)((DiagramEditPart)oneObject).getModelObject()).getType() != null && oneDiagram.getType().equals("packageDiagramType")) {
            Object targetObject = this.getRealDiagramTarget(oneDiagram);
            if (targetObject != null) {
                modelObjects.add(targetObject);
            }
            selectedDiagram = true;
        }
        if (!selectedDiagram && this.getSelectionHandler() != null) {
            modelObjects = new ArrayList(this.getSelectionHandler().getSelectedEObjects());
        }
        return modelObjects;
    }

    public void deselectAll(boolean fireSelectionChanged) {
        List list = this.primGetSelectedEditParts();
        this.setFocus(null);
        int i = 0;
        while (i < list.size()) {
            EditPart part = (EditPart)list.get(i);
            part.setSelected(0);
            ++i;
        }
        list.clear();
        if (fireSelectionChanged) {
            this.fireSelectionChanged();
        }
    }

    public IDiagramSelectionHandler getSelectionHandler() {
        return this.editor.getSelectionHandler();
    }

    public DiagramEditor getEditor() {
        return this.editor;
    }

    public void setInput(EObject input) {
        ModelResource modelResource;
        Diagram diagram;
        if (this.getEditor() != null && (diagram = this.packageDiagramProvider.getPackageDiagram(modelResource = ModelUtilities.getModelResourceForModelObject((EObject)input), input)) != null && this.getEditor().canOpenContext(diagram)) {
            this.getEditor().openContext(diagram);
        }
    }

    public void select(EditPart editpart) {
        super.select(editpart);
        this.reveal(editpart);
    }

    public void select(List editparts) {
        Iterator iter = editparts.iterator();
        EditPart nextEP = null;
        int iPart = 0;
        int nParts = editparts.size();
        while (iter.hasNext()) {
            nextEP = (EditPart)iter.next();
            if (iPart == 0) {
                super.select(nextEP);
            } else {
                super.appendSelection(nextEP);
            }
            if (++iPart != nParts) continue;
            this.reveal(nextEP);
        }
    }

    public void clearAllSelections(boolean fireSelection) {
        this.deselectAll(fireSelection);
    }

    private Object getRealDiagramTarget(Diagram diagram) {
        EObject targetObject = diagram.getTarget();
        if (targetObject != null) {
            ModelResource modelResource;
            if (targetObject instanceof ModelAnnotation && (modelResource = ModelUtilities.getModelResourceForModelObject((EObject)diagram)) != null) {
                return modelResource.getResource();
            }
            return targetObject;
        }
        return null;
    }

    public void setVerticalRangeToValue(int someYValue) {
        Viewport viewport = this.getFigureCanvas().getViewport();
        viewport.getVerticalRangeModel().setMinimum(someYValue);
        viewport.validate();
    }

    public int getMinimumYValue() {
        return 0;
    }

    public Rectangle2D getBounds() {
        int w = this.getFigureCanvas().getViewport().getBounds().width;
        int h = this.getFigureCanvas().getViewport().getBounds().height;
        return new java.awt.Rectangle(w, h);
    }

    public void reveal(EditPart editPart) {
        if (this.isValidViewer()) {
            if (editPart instanceof DiagramEditPart) {
                EObject eObject = ((DiagramEditPart)editPart).getModelObject();
                if (this.getSelectionHandler() != null) {
                    if (this.getSelectionHandler().shouldReveal(eObject) && ((DiagramEditPart)editPart).shouldReveal()) {
                        super.reveal(editPart);
                    }
                } else {
                    super.reveal(editPart);
                }
            } else {
                super.reveal(editPart);
            }
        }
    }

    public void reveal(EObject eObject) {
        EditPart editPart;
        if (this.isValidViewer() && eObject != null && (editPart = this.getSelectionHandler().findDiagramChildEditPart(eObject, false)) != null) {
            this.reveal(editPart);
        }
    }

    public int getCurrentVScrollValue() {
        FigureCanvas scrolledCanvas = (FigureCanvas)this.getControl();
        return scrolledCanvas.getViewport().getViewLocation().y;
    }

    public int getCurrentHScrollValue() {
        FigureCanvas scrolledCanvas = (FigureCanvas)this.getControl();
        return scrolledCanvas.getViewport().getViewLocation().x;
    }

    public void exposePart(EditPart ep) {
        double currentZoom = this.getEditor().getCurrentZoomFactor();
        Dimension vpSize = this.getFigureCanvas().getViewport().getSize();
        Point locationEP = new Point(((DiagramModelNode)ep.getModel()).getPosition());
        Dimension epSize = ((DiagramModelNode)ep.getModel()).getSize();
        Point vpLocation = new Point(this.getFigureCanvas().getViewport().getViewLocation());
        Point correctedVPLocation = new Point((int)((double)vpLocation.x / currentZoom), (int)((double)vpLocation.y / currentZoom));
        Dimension correctedVPSize = new Dimension((int)((double)vpSize.width / currentZoom), (int)((double)vpSize.height / currentZoom));
        Rectangle vpRect = new Rectangle(correctedVPLocation, correctedVPSize);
        if (!vpRect.contains(locationEP)) {
            int dxExpose = (int)(50.0 / currentZoom);
            int dyExpose = (int)(50.0 / currentZoom);
            if (epSize.width < dxExpose) {
                dxExpose = epSize.width - 5;
            }
            if (epSize.height < dyExpose) {
                dyExpose = epSize.height - 5;
            }
            int newX = vpLocation.x;
            int newY = vpLocation.y;
            int dxVp = 0;
            int dyVp = 0;
            if (locationEP.x > vpRect.right()) {
                dxVp = locationEP.x - vpRect.right() + dxExpose;
            } else if (locationEP.x < vpRect.x) {
                dxVp = locationEP.x - vpRect.x - dxExpose;
            }
            if (locationEP.y > vpRect.bottom()) {
                dyVp = locationEP.y - vpRect.bottom() + dxExpose;
            } else if (locationEP.y < vpRect.y) {
                dyVp = locationEP.y - vpRect.y - dxExpose;
            }
            dxVp = (int)((double)dxVp * currentZoom);
            dyVp = (int)((double)dyVp * currentZoom);
            this.getFigureCanvas().getViewport().setViewLocation(newX += dxVp, newY += dyVp);
        }
    }

    public Point getViewportLocation() {
        FigureCanvas scrolledCanvas = (FigureCanvas)this.getControl();
        return new Point(scrolledCanvas.getViewport().getViewLocation());
    }

    public void updateForPrintPreferences() {
    }

    public boolean isValidViewer() {
        return this.getFigureCanvas() != null && this.getControl() != null && !this.getControl().isDisposed();
    }
}

