/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.figure;

import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.diagram.ui.figure.DiagramFigure;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.ToolTipUtil;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;

public abstract class AbstractDiagramFigure
extends Figure
implements DiagramFigure {
    private ColorPalette colorPalette;
    private DiagramModelNode diagramModelNode;

    public AbstractDiagramFigure(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public AbstractDiagramFigure(DiagramModelNode diagramNode, ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
        this.diagramModelNode = diagramNode;
    }

    @Override
    public void setDiagramModelNode(DiagramModelNode diagramNode) {
        this.diagramModelNode = diagramNode;
    }

    @Override
    public void layoutFigure() {
        super.layout();
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    @Override
    public void updateForSize(Dimension newSize) {
        this.setSize(newSize);
    }

    @Override
    public void updateForLocation(Point newLocation) {
        this.setLocation(newLocation);
    }

    @Override
    public void updateForName(String newName, Image icon) {
    }

    @Override
    public void updateForName(String newName) {
    }

    @Override
    public void updateForFont(Font font) {
    }

    @Override
    public void updateForError(boolean hasErrors) {
    }

    @Override
    public void updateForWarning(boolean hasWarnings) {
    }

    @Override
    public void hiliteBackground(Color hiliteColor) {
    }

    public void shouldHiliteBackground(Color hiliteColor) {
    }

    @Override
    public void refreshFont() {
    }

    public Color getColor(int colorId) {
        if (this.colorPalette != null) {
            return this.colorPalette.getColor(colorId);
        }
        return ColorConstants.white;
    }

    @Override
    public void showSelected(boolean selected) {
    }

    @Override
    public void addEditButton(Image image) {
    }

    @Override
    public void addUpperLeftButton(Image image) {
    }

    @Override
    public DiagramModelNode getDiagramModelNode() {
        return this.diagramModelNode;
    }

    @Override
    public void addImage(Image image, int positionIndex) {
    }

    public void setToolTip(String toolTipString) {
        super.setToolTip(this.createToolTip(toolTipString));
    }

    protected IFigure createToolTip(String toolTipString) {
        return ToolTipUtil.createToolTip(toolTipString);
    }

    public IFigure createToolTip(List toolTipStrings) {
        return ToolTipUtil.createToolTip(toolTipStrings);
    }

    public IFigure createButtonToolTip() {
        Button editButton = new Button("R");
        editButton.setSize(new Dimension(10, 10));
        editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println(" Tooltip Button Pressed!!!");
                    }
                });
            }
        });
        return editButton;
    }

    @Override
    public ColorPalette getColorPalette() {
        return this.colorPalette;
    }
}

