/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.figure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.teiid.designer.diagram.ui.util.ToolTipUtil;

public class DiagramPolylineConnection
extends Polyline
implements Connection,
AnchorListener {
    private Color defaultLineColor = ColorConstants.black;
    private ConnectionAnchor startAnchor;
    private ConnectionAnchor endAnchor;
    private ConnectionRouter connectionRouter = ConnectionRouter.NULL;
    private RotatableDecoration startArrow;
    private RotatableDecoration endArrow;

    public DiagramPolylineConnection() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        this.addPoint(new Point(0, 0));
        this.addPoint(new Point(100, 100));
    }

    public void addNotify() {
        super.addNotify();
        this.hookSourceAnchor();
        this.hookTargetAnchor();
    }

    public void anchorMoved(ConnectionAnchor anchor) {
        this.revalidate();
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            super.getBounds();
            int i = 0;
            while (i < this.getChildren().size()) {
                IFigure child = (IFigure)this.getChildren().get(i);
                this.bounds.union(child.getBounds());
                ++i;
            }
        }
        return this.bounds;
    }

    public ConnectionRouter getConnectionRouter() {
        return this.connectionRouter;
    }

    public Object getRoutingConstraint() {
        if (this.getConnectionRouter() != null) {
            return this.getConnectionRouter().getConstraint((Connection)this);
        }
        return null;
    }

    public ConnectionAnchor getSourceAnchor() {
        return this.startAnchor;
    }

    protected RotatableDecoration getSourceDecoration() {
        return this.startArrow;
    }

    public ConnectionAnchor getTargetAnchor() {
        return this.endAnchor;
    }

    protected RotatableDecoration getTargetDecoration() {
        return this.endArrow;
    }

    private void hookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().addAnchorListener((AnchorListener)this);
        }
    }

    private void hookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().addAnchorListener((AnchorListener)this);
        }
    }

    public void layout() {
        if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            this.getConnectionRouter().route((Connection)this);
        }
        super.layout();
        this.bounds = null;
        this.repaint();
        this.fireFigureMoved();
    }

    public void removeNotify() {
        this.unhookSourceAnchor();
        this.unhookTargetAnchor();
        this.getConnectionRouter().remove((Connection)this);
        super.removeNotify();
    }

    public void setConnectionRouter(ConnectionRouter cr) {
        if (cr == null) {
            cr = ConnectionRouter.NULL;
        }
        if (this.connectionRouter != cr) {
            this.connectionRouter.remove((Connection)this);
            ConnectionRouter old = this.connectionRouter;
            this.connectionRouter = cr;
            this.firePropertyChange("connectionRouter", old, cr);
            this.revalidate();
        }
    }

    public void setRoutingConstraint(Object cons) {
        if (this.getConnectionRouter() != null) {
            this.getConnectionRouter().setConstraint((Connection)this, cons);
        }
        this.revalidate();
    }

    public void setSourceAnchor(ConnectionAnchor anchor) {
        this.unhookSourceAnchor();
        this.getConnectionRouter().invalidate((Connection)this);
        this.startAnchor = anchor;
        if (this.getParent() != null) {
            this.hookSourceAnchor();
        }
        this.revalidate();
    }

    public void setSourceDecoration(RotatableDecoration dec) {
        if (this.getSourceDecoration() != null) {
            this.remove((IFigure)this.getSourceDecoration());
        }
        this.startArrow = dec;
        if (dec != null) {
            this.add((IFigure)dec, new ArrowLocator((Connection)this, 2));
        }
    }

    public void setTargetAnchor(ConnectionAnchor anchor) {
        this.unhookTargetAnchor();
        this.getConnectionRouter().invalidate((Connection)this);
        this.endAnchor = anchor;
        if (this.getParent() != null) {
            this.hookTargetAnchor();
        }
        this.revalidate();
    }

    public void setTargetDecoration(RotatableDecoration dec) {
        if (this.getTargetDecoration() != null) {
            this.remove((IFigure)this.getTargetDecoration());
        }
        this.endArrow = dec;
        if (dec != null) {
            this.add((IFigure)dec, new ArrowLocator((Connection)this, 3));
        }
    }

    private void unhookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().removeAnchorListener((AnchorListener)this);
        }
    }

    private void unhookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().removeAnchorListener((AnchorListener)this);
        }
    }

    protected boolean useLocalCoordinates() {
        return false;
    }

    public void setToolTip(String toolTipString) {
        super.setToolTip(this.createToolTip(toolTipString));
    }

    public IFigure createToolTip(List toolTipStrings) {
        return ToolTipUtil.createToolTip(toolTipStrings);
    }

    public IFigure createToolTip(String toolTipString) {
        return ToolTipUtil.createToolTip(toolTipString);
    }

    public void hilite(boolean value) {
        if (value) {
            super.setForegroundColor(ColorConstants.darkBlue);
            this.setLineWidth(3);
        } else {
            super.setForegroundColor(this.defaultLineColor);
            this.setLineWidth(1);
        }
    }

    public void setForegroundColor(Color bg) {
        this.defaultLineColor = bg;
        super.setForegroundColor(bg);
    }

    public List getInternalPoints() {
        if (this.getPoints().size() > 0) {
            ArrayList<Point> ptList = new ArrayList<Point>(this.getPoints().size() / 2);
            int[] points = this.getPoints().toIntArray();
            int i = 2;
            while (i < points.length - 2) {
                ptList.add(new Point(points[i], points[i + 1]));
                ++i;
                ++i;
            }
            return ptList;
        }
        return Collections.EMPTY_LIST;
    }
}

