/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigure;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;

public class LabeledRectangleFigure
extends AbstractDiagramFigure {
    private Label label = null;
    private RectangleFigure rectangle = null;
    private boolean hilite = false;
    private Color defaultBkgdColor;

    public LabeledRectangleFigure(String labelString, Font newFont, boolean hiliteSelection, ColorPalette colorPalette) {
        super(colorPalette);
        this.hilite = hiliteSelection;
        this.init(newFont);
        this.createComponent(labelString, null);
    }

    public LabeledRectangleFigure(String labelString, boolean hiliteSelection, ColorPalette colorPalette) {
        super(colorPalette);
        this.hilite = hiliteSelection;
        this.init(null);
        this.createComponent(labelString, null);
    }

    public LabeledRectangleFigure(String labelString, Image icon, boolean hiliteSelection, ColorPalette colorPalette) {
        super(colorPalette);
        this.hilite = hiliteSelection;
        this.init(null);
        this.createComponent(labelString, icon);
    }

    private void init(Font newFont) {
        if (newFont != null) {
            this.setFont(newFont);
        } else {
            this.setFont(ScaledFontManager.getFont());
        }
    }

    private void createComponent(String labelString, Image icon) {
        int hanging = 0;
        this.label = new Label(labelString);
        if (this.hilite) {
            this.rectangle = new RectangleFigure();
        }
        if (icon != null) {
            this.label.setIcon(icon);
            this.label.setTextPlacement(16);
        }
        this.label.setFont(this.getFont());
        if (this.rectangle != null) {
            this.add((IFigure)this.rectangle);
        }
        this.add((IFigure)this.label);
        hanging = FigureUtilities.getFontMetrics((Font)this.getFont()).getDescent();
        this.label.setForegroundColor(ColorConstants.black);
        this.label.setTextAlignment(16);
        this.label.setRequestFocusEnabled(true);
        int labelWidth = FigureUtilities.getStringExtents((String)this.label.getText(), (Font)this.getFont()).width + 4;
        if (this.label.getIcon() != null) {
            labelWidth += this.label.getIcon().getBounds().width + 6;
        }
        int labelHeight = FigureUtilities.getStringExtents((String)this.label.getText(), (Font)this.getFont()).height + hanging;
        this.label.setSize(labelWidth, labelHeight);
        this.label.setPreferredSize(labelWidth, labelHeight);
        if (this.rectangle != null) {
            this.rectangle.setSize(this.label.getSize());
        }
        this.setSize(labelWidth, labelHeight);
        this.setPreferredSize(labelWidth, labelHeight);
        this.label.setLocation(new Point(1, 1));
        if (this.rectangle != null) {
            this.rectangle.setLocation(new Point(0, 0));
        }
    }

    public void setIcon(Image icon) {
        if (this.label != null) {
            this.label.setIcon(icon);
        }
    }

    public void resize() {
        Font theFont = this.label.getFont();
        int hanging = FigureUtilities.getFontMetrics((Font)theFont).getDescent();
        int labelWidth = FigureUtilities.getStringExtents((String)this.label.getText(), (Font)theFont).width;
        if (this.label.getIcon() != null) {
            labelWidth += this.label.getIcon().getBounds().width + 6;
        }
        int labelHeight = FigureUtilities.getStringExtents((String)this.label.getText(), (Font)theFont).height + hanging;
        this.label.setSize(labelWidth, labelHeight);
        this.label.setPreferredSize(labelWidth, labelHeight);
        if (this.rectangle != null) {
            this.rectangle.setSize(this.label.getSize());
        }
        this.setSize(labelWidth, labelHeight);
        this.setPreferredSize(labelWidth, labelHeight);
    }

    public void setTextColor(Color newColor) {
        this.label.setForegroundColor(newColor);
    }

    public Label getLabel() {
        return this.label;
    }

    @Override
    public void updateForName(String newName) {
        this.label.setText(newName);
        this.resize();
    }

    @Override
    public void updateForFont(Font newFont) {
        if (newFont != null) {
            this.setFont(newFont);
        } else {
            this.setFont(ScaledFontManager.getFont());
        }
        this.label.setFont(this.getFont());
        this.resize();
    }

    public void setBackgroundColor(Color newColor) {
        if (this.hilite && this.rectangle != null) {
            this.defaultBkgdColor = newColor;
            this.rectangle.setBackgroundColor(this.defaultBkgdColor);
            this.rectangle.setForegroundColor(this.defaultBkgdColor);
        }
    }

    @Override
    public void hiliteBackground(Color hiliteColor) {
        if (hiliteColor == null) {
            this.rectangle.setBackgroundColor(this.defaultBkgdColor);
            this.rectangle.setForegroundColor(this.defaultBkgdColor);
        } else {
            this.rectangle.setBackgroundColor(hiliteColor);
            this.rectangle.setForegroundColor(hiliteColor);
        }
    }

    @Override
    public void refreshFont() {
        this.updateForFont(null);
    }
}

