/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.layout;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.teiid.designer.diagram.ui.layout.LayoutNode;
import org.teiid.designer.diagram.ui.layout.LayoutUtilities;

public class ColumnLayout {
    public static final int ERROR_1 = -1;
    public static final int ERROR_2 = -2;
    public static final int ERROR_3 = -3;
    private LayoutNode[] nodeArray;
    private int startX = 10;
    private int startY = 10;
    private int padding = 20;

    public ColumnLayout() {
    }

    public ColumnLayout(List newNodes, int startX, int startY) {
        this.startX = startX;
        this.startY = startY;
        this.nodeArray = LayoutUtilities.getLayoutNodeArray(newNodes);
    }

    public int run() {
        this.layoutInColumns();
        return 0;
    }

    public void layoutInColumns() {
        block18: {
            int currentNodeID;
            int cid;
            int[] ypt;
            int[] xpt;
            int nColumns;
            int nNodes;
            LayoutNode nextNode;
            block19: {
                double totalArea = 0.0;
                double deltaArea = 0.0;
                int minNodeWidth = 9999;
                int minNodeHeight = 9999;
                int maxNodeWidth = 0;
                int maxNodeHeight = 0;
                int layoutWidth = 0;
                int layoutHeight = 0;
                int viewPortWidth = 0;
                int viewPortHeight = 0;
                nextNode = null;
                nNodes = this.nodeArray.length;
                nColumns = 0;
                int i = 0;
                while (i < this.nodeArray.length) {
                    LayoutNode next = this.nodeArray[i];
                    maxNodeWidth = Math.max((int)next.getWidth(), maxNodeWidth);
                    maxNodeHeight = Math.max((int)next.getHeight(), maxNodeHeight);
                    minNodeWidth = Math.min((int)next.getWidth(), minNodeWidth);
                    minNodeHeight = Math.min((int)next.getHeight(), minNodeHeight);
                    deltaArea = next.getHeight() * next.getWidth();
                    totalArea += deltaArea;
                    ++i;
                }
                layoutWidth = (int)Math.sqrt(totalArea * 2.5);
                layoutWidth = layoutHeight = (int)((double)layoutWidth / 1.0);
                viewPortWidth = 800;
                viewPortHeight = 800;
                layoutWidth = Math.max(layoutWidth, viewPortWidth);
                layoutHeight = Math.max(layoutHeight, viewPortHeight);
                nColumns = (int)((double)layoutWidth / ((double)maxNodeWidth + (double)this.getPadding()));
                if (nColumns < 1) {
                    if (nNodes < 2) {
                        return;
                    }
                    nColumns = 1;
                }
                xpt = new int[nColumns];
                ypt = new int[nColumns];
                cid = 0;
                xpt[0] = this.startX;
                ypt[0] = this.startY;
                int j = 1;
                while (j < nColumns) {
                    xpt[j] = xpt[j - 1] + maxNodeWidth + this.getPadding();
                    ypt[j] = this.startY;
                    ++j;
                }
                currentNodeID = 0;
                if (nColumns < 1) break block18;
                if (nColumns != 1) break block19;
                int i2 = 0;
                while (i2 < nNodes) {
                    nextNode = this.nodeArray[i2];
                    nextNode.setPosition(new Point(xpt[cid], ypt[cid]));
                    ypt[cid] = ypt[cid] + (int)nextNode.getHeight() + this.getPadding();
                    ++i2;
                }
                break block18;
            }
            currentNodeID = 0;
            int i = 0;
            while (i < nNodes) {
                nextNode = this.nodeArray[i];
                nextNode.setPosition(new Point(xpt[cid], ypt[cid]));
                ypt[cid] = ypt[cid] + (int)nextNode.getHeight() + this.getPadding();
                currentNodeID = i++;
                if (cid == nColumns - 1) break;
                ++cid;
            }
            cid = 0;
            if (++currentNodeID >= nNodes) break block18;
            i = currentNodeID;
            while (i < nNodes) {
                nextNode = this.nodeArray[i];
                if (cid == 0) {
                    if (ypt[cid] <= ypt[cid + 1] + 1) {
                        nextNode.setPosition(new Point((double)xpt[cid], (double)ypt[cid]));
                        ypt[cid] = ypt[cid] + (int)nextNode.getHeight() + this.getPadding();
                    } else {
                        nextNode.setPosition(new Point((double)xpt[++cid], (double)ypt[cid]));
                        ypt[cid] = ypt[cid] + (int)nextNode.getHeight() + this.getPadding();
                    }
                } else if (cid == nColumns - 1) {
                    if (ypt[cid] < ypt[cid - 1] - 1) {
                        nextNode.setPosition(new Point((double)xpt[cid], (double)ypt[cid]));
                        ypt[cid] = ypt[cid] + (int)nextNode.getHeight() + this.getPadding();
                    } else {
                        cid = 0;
                        nextNode.setPosition(new Point((double)xpt[cid], (double)ypt[cid]));
                        ypt[cid] = ypt[cid] + (int)nextNode.getHeight() + this.getPadding();
                    }
                } else if (ypt[cid] <= ypt[cid + 1] + 1) {
                    nextNode.setPosition(new Point((double)xpt[cid], (double)ypt[cid]));
                    ypt[cid] = ypt[cid] + (int)nextNode.getHeight() + this.getPadding();
                } else {
                    nextNode.setPosition(new Point((double)xpt[++cid], (double)ypt[cid]));
                    ypt[cid] = ypt[cid] + (int)nextNode.getHeight() + this.getPadding();
                }
                if (cid == nColumns) {
                    cid = 0;
                }
                ++i;
            }
        }
    }

    private int getPadding() {
        return this.padding;
    }

    public void setPadding(int newPadding) {
        this.padding = newPadding;
    }

    public void setFinalNodePositions() {
        int i = 0;
        while (i < this.nodeArray.length) {
            this.nodeArray[i].setFinalPosition();
            ++i;
        }
    }

    public double getSizeEstimate() {
        double totalArea = 0.0;
        int i = 0;
        while (i < this.nodeArray.length) {
            totalArea += this.nodeArray[i].getWidth() * this.nodeArray[i].getHeight();
            ++i;
        }
        double length = Math.sqrt(totalArea *= 5.0);
        return length;
    }

    public int getCurrentWidth() {
        double currentWidth = 0.0;
        double nextXPlusW = 0.0;
        int i = 0;
        while (i < this.nodeArray.length) {
            nextXPlusW = this.nodeArray[i].getCenterX() + this.nodeArray[i].getWidth() / 2.0;
            currentWidth = Math.max(currentWidth, nextXPlusW);
            ++i;
        }
        return (int)currentWidth;
    }

    public int getCurrentHeight() {
        double currentHeight = 0.0;
        double nextYPlusH = 0.0;
        int i = 0;
        while (i < this.nodeArray.length) {
            nextYPlusH = this.nodeArray[i].getCenterY() + this.nodeArray[i].getHeight() / 2.0;
            currentHeight = Math.max(currentHeight, nextYPlusH);
            ++i;
        }
        return (int)currentHeight;
    }
}

