/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.teiid.designer.diagram.ui.layout.DefaultLayoutNode;
import org.teiid.designer.diagram.ui.layout.LayoutNode;
import org.teiid.designer.diagram.ui.layout.LayoutUtilities;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;

public class LayoutGroup
implements LayoutNode {
    private double thisX;
    private double thisY;
    private List layoutNodes;
    private int type = 0;
    private DiagramModelNode startingNode;
    private int nConnections = 0;

    public LayoutGroup(List diagramNodes) {
        this.convertNodes(diagramNodes);
        this.calculateType(diagramNodes);
    }

    public LayoutGroup(List diagramNodes, int layoutType) {
        this.convertNodes(diagramNodes);
    }

    public LayoutGroup(List diagramNodes, DiagramModelNode startingNode) {
        this.convertNodes(diagramNodes);
        this.calculateType(diagramNodes);
        this.startingNode = startingNode;
    }

    private void convertNodes(List diagramNodes) {
        this.layoutNodes = new ArrayList(diagramNodes.size());
        DefaultLayoutNode newLayoutNode = null;
        Object nextNode2 = null;
        for (Object nextNode2 : diagramNodes) {
            if (nextNode2 instanceof DiagramModelNode) {
                newLayoutNode = new DefaultLayoutNode((DiagramModelNode)nextNode2);
                this.layoutNodes.add(newLayoutNode);
                continue;
            }
            if (!(nextNode2 instanceof LayoutNode)) continue;
            this.layoutNodes.add(nextNode2);
        }
    }

    public List getLayoutNodes() {
        return this.layoutNodes;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int i) {
        this.type = i;
    }

    private void calculateType(List diagramNodes) {
        this.nConnections = LayoutUtilities.getConnectionCount(diagramNodes);
        int nNodes = diagramNodes.size();
        this.type = this.nConnections == nNodes - 1 ? 1 : 2;
    }

    public void setFinalPositions() {
        Iterator iter = this.layoutNodes.iterator();
        LayoutNode nextLayoutNode = null;
        while (iter.hasNext()) {
            nextLayoutNode = (LayoutNode)iter.next();
            nextLayoutNode.setFinalPosition();
        }
    }

    @Override
    public void setPosition(Point point) {
        this.setX(point.x);
        this.setY(point.y);
        this.move(point.x, point.y);
    }

    @Override
    public double getWidth() {
        return this.getCurrentWidth();
    }

    @Override
    public double getHeight() {
        return this.getCurrentHeight();
    }

    public void move(double x, double y) {
        Iterator iter = this.layoutNodes.iterator();
        LayoutNode nextLayoutNode = null;
        while (iter.hasNext()) {
            nextLayoutNode = (LayoutNode)iter.next();
            double newX = nextLayoutNode.getX() + x;
            double newY = nextLayoutNode.getY() + y;
            nextLayoutNode.setPosition(newX, newY);
        }
    }

    public void layout() {
        switch (this.type) {
            case 2: {
                int numNodes = this.getLayoutNodes().size();
                int nConn = this.nConnections;
                double connRatio = (double)nConn / (double)numNodes;
                if (numNodes > 400 && connRatio > 1.2) {
                    LayoutUtilities.runColumnLayout(this);
                } else {
                    LayoutUtilities.runSpringLayout(this);
                }
                this.setBounds(new Rectangle(0, 0, this.getCurrentWidth(), this.getCurrentHeight()));
                break;
            }
            case 1: {
                if (this.startingNode == null) {
                    LayoutUtilities.runTreeLayout(this);
                } else {
                    LayoutNode startNode = this.getLayoutNode(this.startingNode);
                    LayoutUtilities.runTreeLayout(this, startNode);
                }
                this.setBounds(new Rectangle(0, 0, this.getCurrentWidth(), this.getCurrentHeight()));
                break;
            }
            case 0: {
                LayoutUtilities.runColumnLayout(this);
                this.setBounds(new Rectangle(0, 0, this.getCurrentWidth(), this.getCurrentHeight()));
            }
        }
    }

    public int getCurrentWidth() {
        if (this.layoutNodes == null || this.layoutNodes.isEmpty()) {
            return 1;
        }
        double currentWidth = 0.0;
        double minW = 999999.0;
        double maxW = -999999.0;
        double nextXPlusW = 0.0;
        for (LayoutNode nextNode : this.layoutNodes) {
            minW = Math.min(minW, nextNode.getX());
            nextXPlusW = nextNode.getX() + nextNode.getWidth();
            maxW = Math.max(maxW, nextXPlusW);
        }
        currentWidth = maxW - minW;
        return (int)currentWidth;
    }

    public int getCurrentHeight() {
        if (this.layoutNodes == null || this.layoutNodes.isEmpty()) {
            return 1;
        }
        double currentHeight = 0.0;
        double minH = 999999.0;
        double maxH = -999999.0;
        double nextYPlusH = 0.0;
        for (LayoutNode nextNode : this.layoutNodes) {
            minH = Math.min(minH, nextNode.getY());
            nextYPlusH = nextNode.getY() + nextNode.getHeight();
            maxH = Math.max(maxH, nextYPlusH);
        }
        currentHeight = maxH - minH;
        return (int)currentHeight;
    }

    @Override
    public Rectangle getBounds() {
        return null;
    }

    @Override
    public double getCenterX() {
        return 0.0;
    }

    @Override
    public double getCenterY() {
        return 0.0;
    }

    @Override
    public DiagramModelNode getModelNode() {
        return null;
    }

    @Override
    public Point getPosition() {
        return null;
    }

    @Override
    public double getX() {
        return this.thisX;
    }

    @Override
    public double getY() {
        return this.thisY;
    }

    @Override
    public void setBounds(Rectangle rectangle) {
    }

    @Override
    public void setCenterX(double x) {
    }

    @Override
    public void setCenterXY(double x, double y) {
    }

    @Override
    public void setCenterY(double y) {
    }

    @Override
    public void setFinalPosition() {
    }

    @Override
    public void setPosition(double x, double y) {
        this.setX(x);
        this.setY(y);
        this.move(x, y);
    }

    @Override
    public void setX(double x) {
        this.thisX = x;
    }

    @Override
    public void setY(double y) {
        this.thisY = y;
    }

    public LayoutNode getLayoutNode(Object someObject) {
        if (someObject != null && someObject instanceof DiagramModelNode) {
            Iterator iter = this.getLayoutNodes().iterator();
            LayoutNode nextLN = null;
            while (iter.hasNext()) {
                nextLN = (LayoutNode)iter.next();
                if (nextLN.getModelNode() == null || !nextLN.getModelNode().equals(someObject)) continue;
                return nextLN;
            }
        }
        return null;
    }
}

