/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.designer.diagram.ui.layout.LayoutGroup;
import org.teiid.designer.diagram.ui.layout.LayoutUtilities;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;

public class LayoutHelper {
    public static final int NO_LINKS_LAYOUT = 0;
    public static final int SIMPLE_LAYOUT = 1;
    public static final int COMPLEX_LAYOUT = 2;
    protected DiagramModelNode diagramNode;
    protected List layoutGroups;
    protected LayoutGroup unConnectedGroup = null;

    public LayoutHelper() {
    }

    public LayoutHelper(DiagramModelNode diagramNode) {
        this.diagramNode = diagramNode;
        this.processNodes(diagramNode.getChildren());
    }

    public LayoutHelper(DiagramModelNode diagramNode, DiagramModelNode startingNode) {
        this.diagramNode = diagramNode;
        this.processNodes(diagramNode.getChildren(), startingNode);
    }

    public List getLayoutGroups() {
        return this.layoutGroups;
    }

    public void layoutAll() {
        Iterator iter = this.layoutGroups.iterator();
        LayoutGroup nextGroup = null;
        while (iter.hasNext()) {
            nextGroup = (LayoutGroup)iter.next();
            nextGroup.layout();
        }
        if (this.unConnectedGroup != null) {
            this.unConnectedGroup.layout();
        }
        this.layoutLayouts();
        this.setFinalPositions();
    }

    public void setFinalPositions() {
        Iterator iter = this.layoutGroups.iterator();
        LayoutGroup nextGroup = null;
        while (iter.hasNext()) {
            nextGroup = (LayoutGroup)iter.next();
            nextGroup.setFinalPositions();
        }
        if (this.unConnectedGroup != null) {
            this.unConnectedGroup.setFinalPositions();
        }
    }

    protected void processNodes(List childNodes) {
        this.layoutGroups = new ArrayList();
        List nonConnectedModelNodes = DiagramUiUtilities.getNonConnectedModelNodes(this.getDiagramNode());
        if (!nonConnectedModelNodes.isEmpty()) {
            this.unConnectedGroup = new LayoutGroup(nonConnectedModelNodes, 0);
        }
        List connectedModelNodes = DiagramUiUtilities.getConnectedModelNodes(this.getDiagramNode());
        while (!connectedModelNodes.isEmpty()) {
            List connectedNodeList = LayoutUtilities.getSingleNetwork(connectedModelNodes);
            if (connectedNodeList.isEmpty()) continue;
            this.layoutGroups.add(new LayoutGroup(connectedNodeList));
        }
    }

    protected void processNodes(List childNodes, DiagramModelNode startingNode) {
        DiagramModelNode tempStartingNode = startingNode;
        this.layoutGroups = new ArrayList();
        List nonConnectedModelNodes = DiagramUiUtilities.getNonConnectedModelNodes(this.getDiagramNode());
        if (!nonConnectedModelNodes.isEmpty()) {
            this.unConnectedGroup = new LayoutGroup(nonConnectedModelNodes, 0);
        }
        List connectedModelNodes = DiagramUiUtilities.getConnectedModelNodes(this.getDiagramNode());
        while (!connectedModelNodes.isEmpty()) {
            List connectedNodeList = null;
            if (tempStartingNode != null) {
                connectedNodeList = LayoutUtilities.getSingleNetwork(connectedModelNodes, tempStartingNode);
                if (connectedNodeList.isEmpty()) {
                    tempStartingNode = null;
                    connectedNodeList = LayoutUtilities.getSingleNetwork(connectedModelNodes);
                }
            } else {
                connectedNodeList = LayoutUtilities.getSingleNetwork(connectedModelNodes);
            }
            if (connectedNodeList.isEmpty()) continue;
            if (tempStartingNode != null) {
                this.layoutGroups.add(new LayoutGroup(connectedNodeList, tempStartingNode));
                tempStartingNode = null;
                continue;
            }
            this.layoutGroups.add(new LayoutGroup(connectedNodeList));
        }
    }

    public DiagramModelNode getDiagramNode() {
        return this.diagramNode;
    }

    private void layoutLayouts() {
        LayoutGroup finalLayoutGroup = null;
        if (this.layoutGroups != null && !this.layoutGroups.isEmpty()) {
            finalLayoutGroup = new LayoutGroup(this.layoutGroups);
            LayoutUtilities.runColumnLayout(finalLayoutGroup, 100);
        }
        if (this.unConnectedGroup != null && finalLayoutGroup != null) {
            double currentHeight = finalLayoutGroup.getCurrentHeight();
            this.unConnectedGroup.move(20.0, currentHeight + 150.0);
        }
    }
}

