/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.layout.ColumnLayout;
import org.teiid.designer.diagram.ui.layout.LayoutGroup;
import org.teiid.designer.diagram.ui.layout.LayoutNode;
import org.teiid.designer.diagram.ui.layout.TreeLayout;
import org.teiid.designer.diagram.ui.layout.spring.SpringLayout;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;

public class LayoutUtilities {
    public static List getSingleNetwork(List connectedNodes) {
        DiagramModelNode firstDiagramNode = (DiagramModelNode)connectedNodes.get(0);
        List singleNodeNetwork = LayoutUtilities.getLinkedNodesForNode(firstDiagramNode);
        if (singleNodeNetwork.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        connectedNodes.removeAll(singleNodeNetwork);
        return singleNodeNetwork;
    }

    public static List getSingleNetwork(List connectedNodes, DiagramModelNode startingNode) {
        DiagramModelNode firstDiagramNode = startingNode;
        List singleNodeNetwork = LayoutUtilities.getLinkedNodesForNode(firstDiagramNode);
        if (singleNodeNetwork.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        connectedNodes.removeAll(singleNodeNetwork);
        return singleNodeNetwork;
    }

    public static List getLinkedNodesForNode(DiagramModelNode theNode) {
        ArrayList linkedNodes = new ArrayList();
        LayoutUtilities.addLinkedNodesForNode(linkedNodes, theNode);
        return linkedNodes;
    }

    private static void addLinkedNodesForNode(List linkedNodes, DiagramModelNode theNode) {
        ArrayList connectionList = new ArrayList();
        connectionList.addAll(theNode.getSourceConnections());
        connectionList.addAll(theNode.getTargetConnections());
        Iterator iter = connectionList.iterator();
        NodeConnectionModel nextConnection = null;
        DiagramModelNode sourceNode = null;
        DiagramModelNode targetNode = null;
        while (iter.hasNext()) {
            nextConnection = (NodeConnectionModel)iter.next();
            sourceNode = (DiagramModelNode)nextConnection.getSourceNode();
            targetNode = (DiagramModelNode)nextConnection.getTargetNode();
            if (sourceNode != null && !sourceNode.equals(theNode) && !linkedNodes.contains(sourceNode)) {
                linkedNodes.add(sourceNode);
                LayoutUtilities.addLinkedNodesForNode(linkedNodes, sourceNode);
            }
            if (targetNode == null || targetNode.equals(theNode) || linkedNodes.contains(targetNode)) continue;
            linkedNodes.add(targetNode);
            LayoutUtilities.addLinkedNodesForNode(linkedNodes, targetNode);
        }
    }

    public static int getConnectionCount(List diagramNodes) {
        ArrayList allConnectionList = new ArrayList();
        Iterator iter = diagramNodes.iterator();
        DiagramModelNode nextDiagramNode = null;
        Object nextNode = null;
        while (iter.hasNext()) {
            nextNode = iter.next();
            if (!(nextNode instanceof DiagramModelNode)) continue;
            nextDiagramNode = nextNode;
            allConnectionList.addAll(nextDiagramNode.getSourceConnections());
        }
        if (allConnectionList.isEmpty()) {
            return 0;
        }
        return allConnectionList.size();
    }

    public static int runSpringLayout(LayoutGroup layoutGroup) {
        int result = 0;
        SpringLayout layout = new SpringLayout(layoutGroup.getLayoutNodes());
        layout.setAutoEdgeLength(true);
        layout.setEpsilon(5.0);
        layout.setStartLocation(20, 20);
        int size = (int)layout.getSizeEstimate();
        layout.setSpecifyLayoutSize(true);
        layout.setLayoutSize(size);
        result = layout.run();
        return result;
    }

    public static int runSpringLayout(LayoutGroup layoutGroup, int sizeFactor) {
        int result = 0;
        SpringLayout layout = new SpringLayout(layoutGroup.getLayoutNodes());
        layout.setAutoEdgeLength(true);
        layout.setEpsilon(5.0);
        layout.setStartLocation(20, 20);
        int size = (int)layout.getSizeEstimate() * sizeFactor;
        layout.setSpecifyLayoutSize(true);
        layout.setLayoutSize(size);
        result = layout.run();
        return result;
    }

    public static int runTreeLayout(LayoutGroup layoutGroup) {
        int result = 0;
        TreeLayout layout = new TreeLayout(layoutGroup.getLayoutNodes(), 10, 10, 1000, 1000);
        layout.setRoot((LayoutNode)layoutGroup.getLayoutNodes().get(0));
        layout.setFixedSpacing(true);
        layout.setFixedXSpacing(100.0);
        layout.setFixedYSpacing(100.0);
        layout.setUseObjectsSizes(true);
        result = layout.run();
        return result;
    }

    public static int runTreeLayout(LayoutGroup layoutGroup, LayoutNode rootNode) {
        int result = 0;
        TreeLayout layout = new TreeLayout(layoutGroup.getLayoutNodes(), 10, 10, 1000, 1000);
        layout.setRoot(rootNode);
        layout.setFixedSpacing(true);
        layout.setFixedXSpacing(100.0);
        layout.setFixedYSpacing(100.0);
        layout.setUseObjectsSizes(true);
        result = layout.run();
        return result;
    }

    public static int runColumnLayout(LayoutGroup layoutGroup) {
        int startX = 10;
        int startY = 10;
        ColumnLayout columnLayout = new ColumnLayout(layoutGroup.getLayoutNodes(), startX, startY);
        columnLayout.run();
        return 0;
    }

    public static int runColumnLayout(LayoutGroup layoutGroup, int padding) {
        int startX = 10;
        int startY = 10;
        ColumnLayout columnLayout = new ColumnLayout(layoutGroup.getLayoutNodes(), startX, startY);
        columnLayout.setPadding(padding);
        columnLayout.run();
        return 0;
    }

    public static LayoutNode[] getLayoutNodeArray(List nodes) {
        LayoutNode[] nodeArray = new LayoutNode[nodes.size()];
        Object nextNode = null;
        Iterator iter = nodes.iterator();
        int count = 0;
        while (iter.hasNext()) {
            nextNode = iter.next();
            if (!(nextNode instanceof LayoutNode)) continue;
            nodeArray[count] = nextNode;
            ++count;
        }
        return nodeArray;
    }

    public static void justifyAllToCorner(List nodes) {
        Iterator iter = nodes.iterator();
        double minX = 9999.0;
        double minY = 9999.0;
        LayoutNode nextComp2 = null;
        double deltaX = 0.0;
        double deltaY = 0.0;
        while (iter.hasNext()) {
            nextComp2 = (LayoutNode)iter.next();
            minX = Math.min(nextComp2.getX(), minX);
            minY = Math.min(nextComp2.getY(), minY);
        }
        deltaX = minX - 20.0;
        deltaY = minY - 20.0;
        for (LayoutNode nextComp2 : nodes) {
            nextComp2.setPosition(new Point(nextComp2.getX() - deltaX, nextComp2.getY() - deltaY));
        }
    }

    public static void justifyAllToCorner(Object[] nodes) {
        int nNodes = nodes.length;
        double minX = 9999.0;
        double minY = 9999.0;
        LayoutNode nextComp = null;
        double deltaX = 0.0;
        double deltaY = 0.0;
        int i = 0;
        while (i < nNodes) {
            nextComp = (LayoutNode)nodes[i];
            minX = Math.min(nextComp.getX(), minX);
            minY = Math.min(nextComp.getY(), minY);
            ++i;
        }
        deltaX = minX - 20.0;
        deltaY = minY - 20.0;
        i = 0;
        while (i < nNodes) {
            nextComp = (LayoutNode)nodes[i];
            nextComp.setPosition(new Point(nextComp.getX() - deltaX, nextComp.getY() - deltaY));
            ++i;
        }
    }

    public static int getCurrentHeight(List layoutNodes) {
        double currentHeight = 0.0;
        double minH = 9999.0;
        double maxH = -9999.0;
        double nextYPlusH = 0.0;
        for (LayoutNode nextNode : layoutNodes) {
            minH = Math.min(minH, nextNode.getY());
            nextYPlusH = nextNode.getY() + nextNode.getHeight();
            maxH = Math.max(maxH, nextYPlusH);
        }
        currentHeight = maxH - minH;
        return (int)currentHeight;
    }

    public static int getCurrentHeight(LayoutNode[] layoutNodes) {
        double currentHeight = 0.0;
        double minH = 9999.0;
        double maxH = -9999.0;
        double nextYPlusH = 0.0;
        int nNodes = layoutNodes.length;
        int i = 0;
        while (i < nNodes) {
            LayoutNode nextNode = layoutNodes[i];
            minH = Math.min(minH, nextNode.getY());
            nextYPlusH = nextNode.getY() + nextNode.getHeight();
            maxH = Math.max(maxH, nextYPlusH);
            ++i;
        }
        currentHeight = maxH - minH;
        return (int)currentHeight;
    }
}

