/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.layout.spring;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.WeakHashMap;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.layout.LayoutNode;
import org.teiid.designer.diagram.ui.layout.spring.SpringLayout;
import org.teiid.designer.diagram.ui.layout.spring.SpringLinkConstraints;
import org.teiid.designer.diagram.ui.layout.spring.SpringNodeConstraints;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;

public class Spring {
    private double[] delta;
    private double[] deltaX;
    private double[] deltaY;
    private double[] deltaXX;
    private double[] deltaYY;
    private double[] deltaXY;
    private double[][] partialDeltaX = null;
    private double[][] partialDeltaY = null;
    private double[][] partialDeltaZ = null;
    private double[][] KL = null;
    private int linkCount;
    private boolean[] fixed = null;
    private NodeConnectionModel[][] Connections = null;
    public double[] centerX = null;
    public double[] centerY = null;
    private LayoutNode[] springNodes;
    private int nbnodes_;
    private double _epsilonFactor = 1.5;
    private double _edgeLength = 1000.0;
    private int _repaintPeriod = 1;
    private boolean _autoEdgeLength = true;
    private boolean _widthIgnored = false;
    private boolean _heightIgnored = false;
    private Rectangle _bounds = null;
    private HashMap _nodeConstraints = null;
    private WeakHashMap _linkConstraints = null;
    private SpringLayout layoutManager = null;

    public Spring(SpringLayout newLayoutManager) {
        this.layoutManager = newLayoutManager;
    }

    public void setRectangle(Rectangle rectangle2d) {
        this._bounds = rectangle2d;
    }

    public Rectangle setRectangle() {
        return this._bounds;
    }

    public void setEdgeLength(double d) {
        this._edgeLength = d;
    }

    public double getEdgeLength() {
        return this._edgeLength;
    }

    public void setAutoEdgeLength(boolean bool) {
        this._autoEdgeLength = bool;
    }

    public boolean getAutoEdgeLength() {
        return this._autoEdgeLength;
    }

    public void setWidthIgnored(boolean bool) {
        this._widthIgnored = bool;
    }

    public boolean isWidthIgnored() {
        return this._widthIgnored;
    }

    public void setHeightIgnored(boolean bool) {
        this._heightIgnored = bool;
    }

    public boolean isHeightIgnored() {
        return this._heightIgnored;
    }

    public void setRepaintPeriod(int i) {
        this._repaintPeriod = i;
    }

    public int getRepaintPeriod() {
        return this._repaintPeriod;
    }

    public void setEpsilon(double d) {
        this._epsilonFactor = d;
    }

    public double getEpsilon() {
        return this._epsilonFactor;
    }

    public void setNodeConstraints(HashMap hashmap) {
        this._nodeConstraints = hashmap;
    }

    public HashMap getNodeConstraints() {
        return this._nodeConstraints;
    }

    public void setLinkConstraints(WeakHashMap weakhashmap) {
        this._linkConstraints = weakhashmap;
    }

    public WeakHashMap getLinkConstraints() {
        return this._linkConstraints;
    }

    public String compute(LayoutNode[] theSpringNodes, int i) {
        this.springNodes = theSpringNodes;
        this.nbnodes_ = i;
        if (i == 0) {
            return "There's no component to layout";
        }
        double[] ds = new double[i];
        double[] ds_0_ = new double[i];
        boolean[] bools = new boolean[i];
        this.centerX = ds;
        this.centerY = ds_0_;
        this.fixed = bools;
        int i_2_ = 0;
        while (i_2_ < i) {
            LayoutNode nextNode = this.springNodes[i_2_];
            ds[i_2_] = nextNode.getCenterX();
            ds_0_[i_2_] = nextNode.getCenterY();
            ++i_2_;
        }
        this.makeConnections();
        if (!this.findDistances()) {
            return "Error:  This algorithm should not be run on a non-connected graph!";
        }
        boolean bool = true;
        int i_3_ = 0;
        while (bool && i_3_ < i) {
            bool &= bools[i_3_];
            ++i_3_;
        }
        if (bool) {
            return "All the components are fixed";
        }
        this.find_l_and_k();
        this.calculateDelta();
        double[] ds_4_ = this.delta;
        int[] is = new int[i];
        double d_Epsilon = this._epsilonFactor * (double)(i + this.linkCount);
        int i_5_ = 0;
        int i_6_ = 0;
        int i_7_ = 0;
        while (true) {
            double d_8_ = 0.0;
            int i_9_ = 0;
            while (i_9_ < i) {
                double d_10_ = ds_4_[i_9_];
                int i_11_ = is[i_9_];
                if (d_10_ > d_8_) {
                    d_8_ = d_10_;
                }
                if (i_11_ > i_5_) {
                    i_5_ = i_11_;
                }
                ++i_9_;
            }
            d_8_ = 1.0 / d_8_;
            int i_12_ = 0;
            double d_13_ = 0.0;
            double d_14_ = 1.0 / (double)i_5_;
            int i_15_ = i_12_;
            while (i_15_ < i) {
                double d_16_;
                double d = d_16_ = i_5_ != 0 ? 0.5 * (ds_4_[i_15_] * d_8_ + 1.0 - (double)is[i_15_] * d_14_) : ds_4_[i_15_] * d_8_;
                if (d_16_ > d_13_) {
                    i_12_ = i_15_;
                    d_13_ = d_16_;
                }
                ++i_15_;
            }
            if (ds_4_[i_12_] <= d_Epsilon || i_6_ > 100) break;
            if (!bools[i_12_]) {
                int i_17_ = 0;
                while (ds_4_[i_12_] > d_Epsilon && i_17_ < 10) {
                    this.MoveToNewPosition(i_12_);
                    ++i_17_;
                }
            }
            if (++i_7_ == this.springNodes.length) {
                i_7_ = 0;
                if (this._repaintPeriod > 0 && i_6_ % this._repaintPeriod == this._repaintPeriod - 1) {
                    this.setPositions();
                }
                ++i_6_;
            }
            int n = i_12_;
            is[n] = is[n] + 1;
        }
        this.partialDeltaX = null;
        this.partialDeltaY = null;
        this.partialDeltaZ = null;
        this.KL = null;
        this.delta = null;
        this.deltaX = null;
        this.deltaY = null;
        this.deltaXX = null;
        this.deltaYY = null;
        this.deltaXY = null;
        return null;
    }

    private void makeConnections() {
        Hashtable<EObject, Integer> hashtable = new Hashtable<EObject, Integer>();
        DiagramModelNode[] allDiagramNodes = DiagramUiUtilities.getNodeArray(this.layoutManager.getDiagramNode().getChildren());
        ArrayList allConnections = new ArrayList();
        int iNode = 0;
        while (iNode < allDiagramNodes.length) {
            allConnections.addAll(allDiagramNodes[iNode].getSourceConnections());
            ++iNode;
        }
        int nSpringNodes = this.springNodes.length;
        int iNode2 = 0;
        while (iNode2 < nSpringNodes) {
            hashtable.put(this.springNodes[iNode2].getModelNode().getModelObject(), new Integer(iNode2));
            ++iNode2;
        }
        NodeConnectionModel[][] connectionArray = new NodeConnectionModel[nSpringNodes][nSpringNodes];
        this.linkCount = 0;
        NodeConnectionModel nextConnection2 = null;
        for (NodeConnectionModel nextConnection2 : allConnections) {
            Object targetNode;
            Object sourceNode = hashtable.get(((DiagramModelNode)nextConnection2.getSourceNode()).getModelObject());
            if (sourceNode == null || (targetNode = hashtable.get(((DiagramModelNode)nextConnection2.getTargetNode()).getModelObject())) == null) continue;
            int sourceId = (Integer)sourceNode;
            int targetId = (Integer)targetNode;
            connectionArray[sourceId][targetId] = nextConnection2;
            connectionArray[targetId][sourceId] = nextConnection2;
            ++this.linkCount;
        }
        this.Connections = connectionArray;
    }

    private void setPositions() {
        int i = 0;
        while (i < this.nbnodes_) {
            this.springNodes[i].setCenterXY((int)this.centerX[i], (int)this.centerY[i]);
            ++i;
        }
    }

    private boolean findDistances() {
        LayoutNode[] theNodes = this.springNodes;
        int i = this.nbnodes_;
        boolean[] bools = this.fixed;
        double[] ds = new double[i];
        double[][] ds_24_ = new double[i][i];
        if (this._widthIgnored) {
            if (this._heightIgnored) {
                int i_25_ = 0;
                while (i_25_ < i) {
                    ds[i_25_] = 0.5;
                    ++i_25_;
                }
            } else {
                int i_26_ = 0;
                while (i_26_ < i) {
                    ds[i_26_] = theNodes[i_26_].getHeight() * 0.7;
                    ++i_26_;
                }
            }
        } else if (this._heightIgnored) {
            int i_27_ = 0;
            while (i_27_ < i) {
                ds[i_27_] = theNodes[i_27_].getWidth() * 0.7;
                ++i_27_;
            }
        } else {
            int i_28_ = 0;
            while (i_28_ < i) {
                LayoutNode nextNode = theNodes[i_28_];
                ds[i_28_] = (nextNode.getWidth() + nextNode.getHeight()) * 0.25;
                ++i_28_;
            }
        }
        int i_29_ = 0;
        while (i_29_ < i) {
            EObject modelObject = theNodes[i_29_].getModelNode().getModelObject();
            SpringNodeConstraints springnodeconstraints = (SpringNodeConstraints)this._nodeConstraints.get(modelObject);
            if (springnodeconstraints != null) {
                int n = i_29_;
                ds[n] = ds[n] + springnodeconstraints.getWeight();
                int n2 = i_29_;
                bools[n2] = bools[n2] | springnodeconstraints.isFixed();
            }
            ++i_29_;
        }
        int i_30_ = 0;
        while (i_30_ < i) {
            int i_31_ = i_30_ + 1;
            while (i_31_ < i) {
                NodeConnectionModel connectionModel = this.Connections[i_30_][i_31_];
                if (connectionModel != null) {
                    SpringLinkConstraints springlinkconstraints = (SpringLinkConstraints)this._linkConstraints.get(connectionModel);
                    if (springlinkconstraints != null) {
                        double[] dArray = ds_24_[i_30_];
                        int n = i_31_;
                        dArray[n] = dArray[n] + springlinkconstraints.getWeight();
                    }
                    ds_24_[i_31_][i_30_] = ds_24_[i_30_][i_31_];
                }
                ++i_31_;
            }
            ++i_30_;
        }
        boolean[] bools_32_ = new boolean[i];
        boolean[] bools_33_ = new boolean[i];
        int[] is = new int[this.linkCount << 1];
        double[][] ds_34_ = new double[i][i];
        int i_36_ = 0;
        while (i_36_ < i) {
            System.arraycopy(bools_33_, 0, bools_32_, 0, i);
            int i_37_ = 0;
            int i_38_ = 0;
            bools_32_[i_36_] = true;
            double[] ds_39_ = ds_34_[i_36_];
            int i_40_ = 0;
            while (i_40_ < i) {
                if (this.Connections[i_36_][i_40_] != null) {
                    is[i_37_++] = i_40_;
                    is[i_37_++] = i_36_;
                    bools_32_[i_40_] = true;
                }
                ++i_40_;
            }
            while (i_37_ > i_38_) {
                int i_41_ = is[i_38_++];
                int i_42_ = is[i_38_++];
                ds_39_[i_41_] = ds_34_[i_42_][i_36_] + ds_24_[i_41_][i_42_] + ds[i_41_] + ds[i_42_];
                ds_34_[i_41_][i_36_] = ds_39_[i_41_];
                int i_43_ = 0;
                while (i_43_ < this.nbnodes_) {
                    if (this.Connections[i_41_][i_43_] != null && !bools_32_[i_43_]) {
                        is[i_37_++] = i_43_;
                        is[i_37_++] = i_41_;
                        bools_32_[i_43_] = true;
                    }
                    ++i_43_;
                }
            }
            ++i_36_;
        }
        boolean bool = true;
        int i_44_ = 0;
        while (i_44_ < i) {
            double[] ds_45_ = ds_34_[i_44_];
            int i_46_ = i_44_ + 1;
            while (i_46_ < i) {
                if (ds_45_[i_46_] == 0.0) {
                    bool = false;
                    ds_45_[i_46_] = Double.MAX_VALUE;
                    ds_45_[i_44_] = Double.MAX_VALUE;
                }
                ++i_46_;
            }
            ++i_44_;
        }
        this.KL = ds_34_;
        this.partialDeltaZ = ds_24_;
        this.Connections = null;
        return bool;
    }

    private void find_l_and_k() {
        int i = this.nbnodes_;
        double[][] ds = this.KL;
        double d = 0.0;
        double d_47_ = ds[0][0];
        int i_48_ = 0;
        while (i_48_ < i) {
            double[] ds_49_ = ds[i_48_];
            int i_50_ = i_48_ + 1;
            while (i_50_ < i) {
                double d_51_ = ds_49_[i_50_];
                if (d_47_ < d_51_ && d_51_ < Double.MAX_VALUE) {
                    d_47_ = d_51_;
                }
                d += d_51_;
                ++i_50_;
            }
            ++i_48_;
        }
        d /= (double)i;
        double d_52_ = this._autoEdgeLength && this._bounds != null ? Math.sqrt((double)(this._bounds.width * this._bounds.height) / 2.2) / d_47_ : this._edgeLength / d_47_;
        int i_53_ = 0;
        while (i_53_ < i) {
            double[] ds_54_ = ds[i_53_];
            int i_55_ = i_53_ + 1;
            while (i_55_ < i) {
                double d_56_ = ds_54_[i_55_];
                ds[i_55_][i_53_] = d_56_ < Double.MAX_VALUE ? d * d / (d_56_ * d_56_) : 0.0;
                int n = i_55_++;
                ds_54_[n] = ds_54_[n] * d_52_;
            }
            ++i_53_;
        }
    }

    private void calculateDelta() {
        int i = this.nbnodes_;
        double[] ds = this.centerX;
        double[] ds_57_ = this.centerY;
        double[] ds_58_ = new double[i];
        double[] ds_59_ = new double[i];
        double[] ds_60_ = new double[i];
        double[] ds_61_ = new double[i];
        double[] ds_62_ = new double[i];
        double[] ds_63_ = new double[i];
        double[][] ds_64_ = new double[i][i];
        double[][] ds_65_ = new double[i][i];
        double[][] ds_66_ = this.partialDeltaZ;
        double[][] ds_67_ = this.KL;
        int i_68_ = 0;
        while (i_68_ < i) {
            double d = 0.0;
            double d_69_ = 0.0;
            double d_70_ = 0.0;
            double d_71_ = 0.0;
            double d_72_ = 0.0;
            double d_73_ = ds[i_68_];
            double d_74_ = ds_57_[i_68_];
            double[] ds_75_ = ds_67_[i_68_];
            double[] ds_76_ = ds_64_[i_68_];
            double[] ds_77_ = ds_65_[i_68_];
            double[] ds_78_ = ds_66_[i_68_];
            int i_79_ = 0;
            while (i_79_ < i_68_) {
                d += ds_76_[i_79_];
                d_69_ += ds_77_[i_79_];
                d_70_ += ds_64_[i_79_][i_68_];
                d_71_ += ds_65_[i_79_][i_68_];
                d_72_ += ds_66_[i_79_][i_68_];
                ++i_79_;
            }
            int i_80_ = i_68_ + 1;
            while (i_80_ < i) {
                double d_81_ = d_73_ - ds[i_80_];
                double d_82_ = d_74_ - ds_57_[i_80_];
                double d_83_ = d_81_ * d_81_;
                double d_84_ = d_82_ * d_82_;
                double d_85_ = d_83_ + d_84_;
                double d_86_ = Math.sqrt(d_85_);
                double d_87_ = ds_67_[i_80_][i_68_];
                double d_88_ = d_87_ * ds_75_[i_80_] / d_86_;
                double d_89_ = d_88_ / d_85_;
                double d_90_ = d_87_ - d_88_;
                double d_91_ = d_81_ * d_90_;
                double d_92_ = d_82_ * d_90_;
                double d_93_ = d_87_ - d_89_ * d_84_;
                double d_94_ = d_87_ - d_89_ * d_83_;
                double d_95_ = d_89_ * d_81_ * d_82_;
                d += d_91_;
                d_69_ += d_92_;
                d_70_ += d_93_;
                d_71_ += d_94_;
                d_72_ += d_95_;
                ds_64_[i_80_][i_68_] = -d_91_;
                ds_65_[i_80_][i_68_] = -d_92_;
                ds_76_[i_80_] = d_93_;
                ds_77_[i_80_] = d_94_;
                ds_78_[i_80_] = d_95_;
                ++i_80_;
            }
            ds_58_[i_68_] = Math.sqrt(d * d + d_69_ * d_69_);
            ds_59_[i_68_] = d;
            ds_60_[i_68_] = d_69_;
            ds_61_[i_68_] = d_70_;
            ds_62_[i_68_] = d_71_;
            ds_63_[i_68_] = d_72_;
            ++i_68_;
        }
        this.delta = ds_58_;
        this.deltaX = ds_59_;
        this.deltaY = ds_60_;
        this.deltaXX = ds_61_;
        this.deltaYY = ds_62_;
        this.deltaXY = ds_63_;
        this.partialDeltaX = ds_64_;
        this.partialDeltaY = ds_65_;
    }

    private void MoveToNewPosition(int i) {
        int i_96_ = this.nbnodes_;
        double[][] ds = this.partialDeltaX;
        double[][] ds_97_ = this.partialDeltaY;
        double[][] ds_98_ = this.partialDeltaZ;
        double[][] ds_99_ = this.KL;
        double[] ds_100_ = this.centerX;
        double[] ds_101_ = this.centerY;
        double[] ds_102_ = ds_99_[i];
        double[] ds_103_ = this.delta;
        double[] ds_104_ = this.deltaX;
        double[] ds_105_ = this.deltaY;
        double[] ds_106_ = this.deltaXX;
        double[] ds_107_ = this.deltaYY;
        double[] ds_108_ = this.deltaXY;
        double[] ds_109_ = this.partialDeltaX[i];
        double[] ds_110_ = this.partialDeltaY[i];
        double[] ds_111_ = this.partialDeltaZ[i];
        double d = ds_104_[i];
        double d_112_ = ds_105_[i];
        double d_113_ = ds_106_[i];
        double d_114_ = ds_107_[i];
        double d_115_ = ds_108_[i];
        double d_116_ = 1.0 / (d_113_ * d_114_ - d_115_ * d_115_);
        double d_117_ = ds_100_[i] + (d_112_ * d_115_ - d * d_114_) * d_116_;
        double d_118_ = ds_101_[i] + (d * d_115_ - d_112_ * d_113_) * d_116_;
        ds_100_[i] = d_117_;
        ds_101_[i] = d_118_;
        d = 0.0;
        d_112_ = 0.0;
        d_113_ = 0.0;
        d_114_ = 0.0;
        d_115_ = 0.0;
        int i_119_ = 0;
        while (i_119_ < i) {
            double d_120_ = d_117_ - ds_100_[i_119_];
            double d_121_ = d_118_ - ds_101_[i_119_];
            double d_122_ = d_120_ * d_120_;
            double d_123_ = d_121_ * d_121_;
            double d_124_ = d_122_ + d_123_;
            double d_125_ = Math.sqrt(d_124_);
            double d_126_ = ds_102_[i_119_];
            double d_127_ = d_126_ * ds_99_[i_119_][i] / d_125_;
            double d_128_ = d_127_ / d_124_;
            double d_129_ = d_126_ - d_127_;
            double d_130_ = d_120_ * d_129_;
            double d_131_ = d_121_ * d_129_;
            double d_132_ = d_126_ - d_128_ * d_123_;
            double d_133_ = d_126_ - d_128_ * d_122_;
            double d_134_ = d_128_ * d_120_ * d_121_;
            double d_135_ = ds_104_[i_119_] + ds_109_[i_119_] - d_130_;
            double d_136_ = ds_105_[i_119_] + ds_110_[i_119_] - d_131_;
            d += d_130_;
            d_112_ += d_131_;
            d_113_ += d_132_;
            d_114_ += d_133_;
            d_115_ += d_134_;
            ds_109_[i_119_] = d_130_;
            ds_110_[i_119_] = d_131_;
            ds[i_119_][i] = d_132_;
            ds_97_[i_119_][i] = d_133_;
            ds_98_[i_119_][i] = d_134_;
            ds_103_[i_119_] = Math.sqrt(d_135_ * d_135_ + d_136_ * d_136_);
            ds_104_[i_119_] = d_135_;
            ds_105_[i_119_] = d_136_;
            ds_106_[i_119_] = ds_106_[i_119_] - this.partialDeltaX[i_119_][i] + d_132_;
            ds_107_[i_119_] = ds_107_[i_119_] - this.partialDeltaY[i_119_][i] + d_133_;
            ds_108_[i_119_] = ds_108_[i_119_] - this.partialDeltaZ[i_119_][i] + d_134_;
            ++i_119_;
        }
        int i_137_ = i + 1;
        while (i_137_ < i_96_) {
            double d_138_ = d_117_ - ds_100_[i_137_];
            double d_139_ = d_118_ - ds_101_[i_137_];
            double d_140_ = d_138_ * d_138_;
            double d_141_ = d_139_ * d_139_;
            double d_142_ = d_140_ + d_141_;
            double d_143_ = Math.sqrt(d_142_);
            double d_144_ = ds_99_[i_137_][i];
            double d_145_ = d_144_ * ds_102_[i_137_] / d_143_;
            double d_146_ = d_145_ / d_142_;
            double d_147_ = d_144_ - d_145_;
            double d_148_ = d_138_ * d_147_;
            double d_149_ = d_139_ * d_147_;
            double d_150_ = d_144_ - d_146_ * d_141_;
            double d_151_ = d_144_ - d_146_ * d_140_;
            double d_152_ = d_146_ * d_138_ * d_139_;
            double d_153_ = ds_104_[i_137_] - this.partialDeltaX[i_137_][i] - d_148_;
            double d_154_ = ds_105_[i_137_] - this.partialDeltaY[i_137_][i] - d_149_;
            d += d_148_;
            d_112_ += d_149_;
            d_113_ += d_150_;
            d_114_ += d_151_;
            d_115_ += d_152_;
            ds[i_137_][i] = -d_148_;
            ds_97_[i_137_][i] = -d_149_;
            ds_109_[i_137_] = d_150_;
            ds_110_[i_137_] = d_151_;
            ds_111_[i_137_] = d_152_;
            ds_103_[i_137_] = Math.sqrt(d_153_ * d_153_ + d_154_ * d_154_);
            ds_104_[i_137_] = d_153_;
            ds_105_[i_137_] = d_154_;
            int n = i_137_;
            ds_106_[n] = ds_106_[n] + (d_150_ - ds_109_[i_137_]);
            int n2 = i_137_;
            ds_107_[n2] = ds_107_[n2] + (d_151_ - ds_110_[i_137_]);
            int n3 = i_137_;
            ds_108_[n3] = ds_108_[n3] + (d_152_ - ds_111_[i_137_]);
            ++i_137_;
        }
        ds_103_[i] = Math.sqrt(d * d + d_112_ * d_112_);
        ds_104_[i] = d;
        ds_105_[i] = d_112_;
        ds_106_[i] = d_113_;
        ds_107_[i] = d_114_;
        ds_108_[i] = d_115_;
    }
}

