/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramEntity;

public abstract class AbstractFreeDiagramModelNode
implements DiagramModelNode,
DiagramUiConstants {
    private int x;
    private int y;
    private int width;
    private int height;
    private String name;
    private DiagramModelNode parent;
    private Image firstOverlayImage;
    private Image secondOverlayImage;
    private boolean heightFixed = false;
    private int fixedHeight = 200;
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public AbstractFreeDiagramModelNode(String name) {
        this.setName(name);
    }

    @Override
    public void setModelObject(EObject object) {
    }

    @Override
    public void setDiagramModelObject(DiagramEntity object) {
    }

    @Override
    public EObject getModelObject() {
        return null;
    }

    @Override
    public DiagramEntity getDiagramModelObject() {
        return null;
    }

    @Override
    public void addChild(DiagramModelNode child) {
    }

    @Override
    public void removeChild(DiagramModelNode child, boolean deleteDiagramEntity) {
    }

    @Override
    public void addChildren(List children) {
    }

    @Override
    public void removeChildren(List children, boolean deleteDiagramEntities) {
    }

    @Override
    public void setChildren(List childList) {
    }

    @Override
    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void updateForChild(boolean isMove) {
        this.fireStructureChange("children", "EMPTY");
    }

    public int getNumberOfChildren() {
        return 0;
    }

    @Override
    public void setParent(DiagramModelNode parent) {
        this.parent = parent;
    }

    @Override
    public DiagramModelNode getParent() {
        return this.parent;
    }

    @Override
    public void setPosition(Point position) {
        this.x = position.x;
        this.y = position.y;
        this.firePropertyChange("location", null, position);
    }

    @Override
    public void setCenterXY(int newCenterX, int newCenterY) {
        int newX = newCenterX - this.getWidth() / 2;
        int newY = newCenterY - this.getHeight() / 2;
        this.x = newX;
        this.y = newY;
        this.firePropertyChange("location", null, new Point(newX, newY));
    }

    @Override
    public void setCenterX(int newCenterX) {
        int newX;
        this.x = newX = newCenterX - this.getWidth() / 2;
        this.firePropertyChange("location", null, new Point(newX, this.y));
    }

    @Override
    public void setCenterY(int newCenterY) {
        int newY;
        this.y = newY = newCenterY - this.getHeight() / 2;
        this.firePropertyChange("location", null, new Point(this.x, newY));
    }

    @Override
    public Point getPosition() {
        Point posn = new Point(this.x, this.y);
        return posn;
    }

    @Override
    public void setSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
        this.firePropertyChange("size", null, dimension);
    }

    @Override
    public Dimension getSize() {
        Dimension size = new Dimension(this.width, this.height);
        return size;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    @Override
    public void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    protected void fireStructureChange(String prop, Object child) {
        this.listeners.firePropertyChange(prop, null, child);
    }

    public Object getEditableValue() {
        return this;
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    @Override
    public void update() {
        this.firePropertyChange("prop", null, null);
    }

    @Override
    public void update(String property) {
        this.firePropertyChange(property, null, null);
    }

    @Override
    public void update(String prop, String oldValue, String newValue) {
        this.firePropertyChange(prop, oldValue, newValue);
    }

    @Override
    public void setName(String name) {
        if (this.name == null || !this.name.equals(name)) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChange("name", oldName, name);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayString() {
        return this.getName();
    }

    public String getPath() {
        return "Path";
    }

    public int getXPosition() {
        return this.x;
    }

    public int getYPosition() {
        return this.y;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getCenterX() {
        return this.x + this.width / 2;
    }

    @Override
    public int getCenterY() {
        return this.y + this.height / 2;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.getName());
        result.append(", path: ");
        result.append(this.getPath());
        result.append(", xPosition: ");
        result.append(this.getXPosition());
        result.append(", yPosition: ");
        result.append(this.getYPosition());
        result.append(", height: ");
        result.append(this.getHeight());
        result.append(", width: ");
        result.append(this.getWidth());
        result.append(')');
        return result.toString();
    }

    @Override
    public Vector getSourceConnections() {
        return new Vector();
    }

    @Override
    public Vector getTargetConnections() {
        return new Vector();
    }

    @Override
    public void addSourceConnection(NodeConnectionModel iConnection) {
    }

    @Override
    public void addTargetConnection(NodeConnectionModel iConnection) {
    }

    @Override
    public void removeSourceConnection(NodeConnectionModel iConnection) {
    }

    @Override
    public void removeTargetConnection(NodeConnectionModel iConnection) {
    }

    @Override
    public List getAssociations(HashMap nodeMap) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void updateAssociations() {
    }

    @Override
    public boolean hasErrors() {
        return false;
    }

    @Override
    public boolean hasWarnings() {
        return false;
    }

    @Override
    public void recoverObjectProperties() {
    }

    @Override
    public boolean wasLayedOut() {
        return false;
    }

    @Override
    public List getDependencies() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Image getFirstOverlayImage() {
        return this.firstOverlayImage;
    }

    @Override
    public void setFirstOverlayImage(Image image, String editorID) {
        this.firstOverlayImage = image;
    }

    @Override
    public Image getSecondOverlayImage() {
        return this.secondOverlayImage;
    }

    @Override
    public void setSecondOverlayImage(Image image, int positionIndex) {
        this.secondOverlayImage = image;
    }

    @Override
    public void updateForErrorsAndWarnings() {
    }

    @Override
    public Diagram getDiagram() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
    }

    @Override
    public boolean hideLocation() {
        return false;
    }

    @Override
    public void setHideLocation(boolean hideLocation) {
    }

    @Override
    public String getEditorID() {
        return null;
    }

    @Override
    public int getFixedHeight() {
        return this.fixedHeight;
    }

    @Override
    public void setFixedHeight(int theFixedHeight) {
        this.fixedHeight = theFixedHeight;
    }

    @Override
    public boolean isHeightFixed() {
        return this.heightFixed;
    }

    @Override
    public void setHeightFixed(boolean theHeightFixed) {
        this.heightFixed = theHeightFixed;
    }
}

