/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.model;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.model.DiagramModelFactory;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.AbstractDiagramEntity;
import org.teiid.designer.metamodels.diagram.Diagram;

public abstract class DiagramModelFactoryImpl
implements DiagramModelFactory {
    @Override
    public DiagramModelNode createModel(Object oBaseObject, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public boolean notifyModel(Notification notification, DiagramModelNode diagramModelNode, String sDiagramTypeId) {
        return true;
    }

    protected boolean currentDiagramRemoved(Diagram diagram) {
        boolean isRemoved = false;
        if (diagram == null) {
            isRemoved = true;
        } else if (diagram.eResource() == null) {
            isRemoved = true;
            if (diagram.getTarget() != null && diagram.getTarget().eResource() != null) {
                isRemoved = false;
            }
            if (diagram.eContainer() == null && this.diagramIsTransient(diagram)) {
                isRemoved = false;
            }
        }
        return isRemoved;
    }

    protected boolean diagramIsTransient(Diagram diagram) {
        return DiagramUiPlugin.getDiagramTypeManager().isTransientDiagram(diagram);
    }

    public DiagramModelNode getParentInDiagram(DiagramModelNode diagramModelNode, EObject parentEObject) {
        DiagramModelNode parentModelNode = null;
        parentModelNode = diagramModelNode.getModelObject() != null && diagramModelNode.getModelObject() == parentEObject ? diagramModelNode : this.findParent(diagramModelNode, parentEObject);
        return parentModelNode;
    }

    private DiagramModelNode findParent(DiagramModelNode someModelNode, EObject parentEObject) {
        List modelChildren = someModelNode.getChildren();
        Iterator iter = modelChildren.iterator();
        DiagramModelNode nextChildNode = null;
        while (iter.hasNext()) {
            nextChildNode = (DiagramModelNode)iter.next();
            if (nextChildNode.getModelObject() == null || nextChildNode.getModelObject() != parentEObject) continue;
            return nextChildNode;
        }
        return null;
    }

    public DiagramModelNode getNodeInDiagram(DiagramModelNode diagramModelNode, EObject someEObject) {
        if (diagramModelNode.getModelObject() != null && diagramModelNode.getModelObject() == someEObject) {
            return diagramModelNode;
        }
        List modelChildren = diagramModelNode.getChildren();
        Iterator iter = modelChildren.iterator();
        DiagramModelNode nextChildNode = null;
        while (iter.hasNext()) {
            nextChildNode = (DiagramModelNode)iter.next();
            if (nextChildNode.getModelObject() == null || nextChildNode.getModelObject() != someEObject) continue;
            return nextChildNode;
        }
        return null;
    }

    public DiagramModelNode getModelNode(DiagramModelNode diagramModelNode, EObject someModelObject) {
        if (diagramModelNode.getModelObject() != null && diagramModelNode.getModelObject() == someModelObject) {
            return diagramModelNode;
        }
        DiagramModelNode matchedNode = null;
        List contents = diagramModelNode.getChildren();
        if (contents != null && !contents.isEmpty()) {
            Iterator iter = contents.iterator();
            Object nextObj = null;
            DiagramModelNode nextNode = null;
            while (iter.hasNext() && matchedNode == null) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramModelNode)) continue;
                nextNode = nextObj;
                matchedNode = this.getModelNode(nextNode, someModelObject);
            }
        }
        return matchedNode;
    }

    protected boolean notifierIsDiagramEntity(Notification notification) {
        Object notifier = ModelerCore.getModelEditor().getChangedObject(notification);
        return notifier instanceof AbstractDiagramEntity;
    }

    protected boolean notifierIsDiagram(Notification notification) {
        Object notifier = ModelerCore.getModelEditor().getChangedObject(notification);
        return notifier instanceof Diagram;
    }

    protected boolean isDiagramNotifier(Notification notification) {
        Object notifier = ModelerCore.getModelEditor().getChangedObject(notification);
        return notifier instanceof Diagram || notifier instanceof AbstractDiagramEntity;
    }

    protected EObject getEObjectTarget(Notification notification) {
        Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
        if (targetObject instanceof EObject) {
            return (EObject)targetObject;
        }
        return null;
    }

    protected boolean isValidTarget(EObject targetEObject) {
        return targetEObject != null && !(targetEObject instanceof Diagram) && !(targetEObject instanceof AbstractDiagramEntity);
    }

    @Override
    public void handleLabelProviderChanged(DiagramModelNode diagramModelNode, List eObjects) {
        HashMap<DiagramModelNode, String> updateNodes = new HashMap<DiagramModelNode, String>(eObjects.size());
        for (EObject nextEObject : eObjects) {
            DiagramModelNode nextNode = this.getModelNode(diagramModelNode, nextEObject);
            if (nextNode == null) continue;
            updateNodes.put(nextNode, "x");
            DiagramModelNode parentClassNode = DiagramUiUtilities.getClassifierParentNode(nextNode);
            if (parentClassNode == null) continue;
            updateNodes.put(parentClassNode, "x");
        }
        for (DiagramModelNode nextNode : updateNodes.keySet()) {
            if (nextNode == null) continue;
            nextNode.updateForErrorsAndWarnings();
        }
    }

    @Override
    public boolean isDrawable(EObject object) {
        return true;
    }

    @Override
    public boolean shouldRefreshDiagram(Notification notification, DiagramModelNode diagramModelNode, String sDiagramTypeId) {
        return false;
    }
}

