/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.figure;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigure;
import org.teiid.designer.diagram.ui.figure.ContainerFigure;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;

public class UmlClassifierContainerFigure
extends AbstractDiagramFigure
implements ContainerFigure {
    private int numContainedItems = 0;
    private static int ySpacing = 2;
    private static int leftMargin = 5;
    private Vector containedItems;
    private int initialY = 0;
    private ScrollPane scrollpane;
    private IFigure pane;
    private int stackOrderValue = 0;

    public UmlClassifierContainerFigure(DiagramModelNode diagramNode, ColorPalette colorPalette) {
        super(colorPalette);
        this.setDiagramModelNode(diagramNode);
        this.init();
        this.createComponent();
    }

    private void init() {
        this.setBackgroundColor(this.getColor(1));
        this.initialY = ySpacing * 2;
        this.containedItems = new Vector();
        this.scrollpane = new ScrollPane();
        this.pane = new FreeformLayer();
        this.pane.setLayoutManager((LayoutManager)new FreeformLayout());
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)this.scrollpane);
        this.scrollpane.setViewport((Viewport)new FreeformViewport());
        this.scrollpane.setContents(this.pane);
        this.setOpaque(true);
    }

    private void createComponent() {
        int maxWidth = 10;
        int rectHeight = 10;
        maxWidth = this.getMinimumWidth() + 20;
        rectHeight = this.getMinimumHeight() + 20;
        this.setSize(maxWidth, rectHeight);
        this.layoutFigure();
    }

    @Override
    public IFigure getContentsPane() {
        return this.pane;
    }

    @Override
    public void layoutFigure() {
        this.numContainedItems = 0;
        HashSet<Object> items = new HashSet<Object>();
        int currentY = this.initialY;
        Figure nextLabel = null;
        List childFigures = this.getContentsPane().getChildren();
        Iterator iter = childFigures.iterator();
        Object nextObject = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (items.contains(nextObject)) continue;
            nextLabel = (Figure)nextObject;
            nextLabel.setLocation(new Point(leftMargin, currentY));
            currentY += nextLabel.getBounds().height;
            items.add(nextObject);
            ++this.numContainedItems;
        }
        this.containedItems = new Vector(items);
        int minHeight = this.getMinimumHeight();
        Dimension dim = new Dimension(this.getMinimumWidth(), minHeight);
        if (this.getDiagramModelNode().isHeightFixed()) {
            dim.height = this.getDiagramModelNode().getFixedHeight();
        }
        this.setSize(dim.width, dim.height);
    }

    public int getMinimumWidth() {
        int minimumWidth = 20;
        Figure nextLabel = null;
        int i = 0;
        while (i < this.numContainedItems) {
            nextLabel = (Figure)this.containedItems.get(i);
            minimumWidth = Math.max(minimumWidth, nextLabel.getSize().width);
            ++i;
        }
        return minimumWidth += leftMargin * 3;
    }

    public int getMinimumHeight() {
        int minimumHeight = 10;
        Figure nextLabel = null;
        if (this.numContainedItems > 0) {
            minimumHeight = this.initialY;
        }
        int i = 0;
        while (i < this.numContainedItems) {
            nextLabel = (Figure)this.containedItems.get(i);
            minimumHeight += nextLabel.getBounds().height;
            ++i;
        }
        return minimumHeight += ySpacing * 4;
    }

    @Override
    public void refreshFont() {
        this.layoutFigure();
    }

    public int getStackOrderValue() {
        return this.stackOrderValue;
    }

    public void setStackOrderValue(int i) {
        this.stackOrderValue = i;
    }
}

