/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.figure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SimpleRaisedBorder;
import org.eclipse.draw2d.Triangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigure;
import org.teiid.designer.diagram.ui.figure.ExpandableFigure;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlClassifierContainerFigure;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlClassifierFooter;
import org.teiid.designer.diagram.ui.notation.uml.figure.UmlClassifierHeader;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditFigure;
import org.teiid.designer.ui.editors.ModelEditorManager;

public class UmlClassifierFigure
extends AbstractDiagramFigure
implements DirectEditFigure,
ExpandableFigure {
    private static final String COLLAPSE_TOOLTIP = DiagramUiConstants.Util.getString("UmlClassifierFigure.collapseTooltip.text", new Object[0]);
    private static final String EXPAND_TOOLTIP = DiagramUiConstants.Util.getString("UmlClassifierFigure.expandTooltip.text", new Object[0]);
    private static int ySpacing = 2;
    private Triangle topLeftArrow;
    private boolean expandable = false;
    private UmlClassifierHeader header;
    private UmlClassifierFooter footer;
    private ImageFigure errorIcon;
    private ImageFigure warningIcon;
    private ImageFigure extraImage;
    private int extraImagePosition = 2;
    private Button editButton;

    public UmlClassifierFigure(String stereotype, String name, String location, Image icon, ColorPalette colorPalette) {
        super(colorPalette);
        this.init(stereotype, name, location, icon);
        this.createComponent();
    }

    public UmlClassifierFigure(DiagramModelNode diagramNode, String stereotype, String name, String location, Image icon, ColorPalette colorPalette) {
        super(diagramNode, colorPalette);
        this.init(stereotype, name, location, icon);
        this.createComponent();
    }

    @Override
    public void addEditButton(Image image) {
        if (image != null) {
            if (this.editButton != null) {
                this.remove((IFigure)this.editButton);
            }
            this.editButton = new Button(image);
            this.editButton.setSize(new Dimension(image.getImageData().width + 6, image.getImageData().height + 4));
            this.editButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    if (UmlClassifierFigure.this.getDiagramModelNode() != null) {
                        final EObject modelObject = UmlClassifierFigure.this.getDiagramModelNode().getModelObject();
                        final String editorID = UmlClassifierFigure.this.getDiagramModelNode().getEditorID();
                        if (modelObject != null && modelObject instanceof EObject && ModelEditorManager.canEdit((EObject)modelObject)) {
                            Display.getCurrent().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (editorID != null) {
                                        ModelEditorManager.edit((EObject)((EObject)modelObject), (String)editorID);
                                    } else {
                                        ModelEditorManager.edit((EObject)((EObject)modelObject));
                                    }
                                }
                            });
                        }
                    }
                }
            });
            this.add((IFigure)this.editButton);
            this.header.setLeftButton(true);
            this.layoutFigure();
            int iX = 3 + this.getExpansionFigure().getSize().width;
            this.editButton.setLocation(new Point(iX, 4));
        } else {
            if (this.editButton != null) {
                this.remove((IFigure)this.editButton);
                this.header.setLeftButton(false);
                this.layoutFigure();
            }
            this.editButton = null;
        }
    }

    private void addExpandControl() {
        this.topLeftArrow = new Triangle();
        UmlClassifierNode ucNode = (UmlClassifierNode)this.getDiagramModelNode();
        if (ucNode != null && ucNode.isExpanded()) {
            this.topLeftArrow.setDirection(4);
        } else {
            this.topLeftArrow.setDirection(16);
        }
        this.add((IFigure)this.topLeftArrow);
        this.topLeftArrow.setBackgroundColor(ColorConstants.black);
        this.topLeftArrow.setForegroundColor(ColorConstants.black);
        this.topLeftArrow.setLineWidth(1);
        this.topLeftArrow.setSize(11, 9);
        this.topLeftArrow.setLocation(new Point(1, 2));
        this.topLeftArrow.setToolTip(this.createToolTip(EXPAND_TOOLTIP));
        this.topLeftArrow.setVisible(this.expandable);
    }

    @Override
    public void addImage(Image image, int position) {
        if (image != null) {
            if (this.extraImage != null) {
                this.remove((IFigure)this.extraImage);
            }
            this.extraImage = new ImageFigure(image);
            this.add((IFigure)this.extraImage);
            this.extraImage.setSize(this.extraImage.getPreferredSize());
            this.extraImagePosition = position;
            this.setExtraImageLocation();
        } else {
            if (this.extraImage != null) {
                this.remove((IFigure)this.extraImage);
            }
            this.extraImage = null;
        }
    }

    @Override
    public void collapse() {
        this.topLeftArrow.setDirection(16);
        this.topLeftArrow.setBackgroundColor(ColorConstants.black);
        this.topLeftArrow.setToolTip(this.createToolTip(EXPAND_TOOLTIP));
        this.topLeftArrow.setSize(11, 9);
        this.topLeftArrow.setLocation(new Point(0, 2));
        this.repaint();
    }

    private double containerHeightRatio(UmlClassifierContainerFigure someContainer) {
        int nObjects = someContainer.getContentsPane().getChildren().size();
        if (nObjects == 0) {
            nObjects = 1;
        }
        int totalObjects = 0;
        List childFigures = this.getChildren();
        Iterator iter = childFigures.iterator();
        Object nextObject = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (!(nextObject instanceof UmlClassifierContainerFigure)) continue;
            totalObjects += ((UmlClassifierContainerFigure)nextObject).getContentsPane().getChildren().size();
        }
        if (totalObjects == 0) {
            totalObjects = 1;
        }
        double returnRatio = (double)nObjects / (double)totalObjects;
        return returnRatio;
    }

    private void createComponent() {
        int finalWidth = this.header.getSize().width;
        int finalHeight = this.header.getSize().height + 20;
        this.setSize(finalWidth, finalHeight);
        this.header.setSize(finalWidth, this.header.getSize().height);
        this.header.setLocation(new Point(0, 0));
        this.footer.setSize(finalWidth, this.footer.getSize().height);
        this.footer.setLocation(new Point(0, this.header.getSize().height));
    }

    @Override
    public void expand() {
        this.topLeftArrow.setDirection(4);
        this.topLeftArrow.setBackgroundColor(ColorConstants.blue);
        this.topLeftArrow.setToolTip(this.createToolTip(COLLAPSE_TOOLTIP));
        this.topLeftArrow.setSize(10, 12);
        this.topLeftArrow.setLocation(new Point(3, 0));
        this.repaint();
    }

    private IFigure getContainerFigure(int type) {
        Iterator iter = this.getChildren().iterator();
        Object nextObject = null;
        while (iter.hasNext()) {
            int contType;
            nextObject = iter.next();
            if (!(nextObject instanceof UmlClassifierContainerFigure) || (contType = ((UmlClassifierContainerFigure)nextObject).getStackOrderValue()) != type) continue;
            return nextObject;
        }
        return null;
    }

    public Button getEditButton() {
        return this.editButton;
    }

    @Override
    public IFigure getExpansionFigure() {
        return this.topLeftArrow;
    }

    @Override
    public Label getLabelFigure() {
        return this.header.getNameLabel();
    }

    private int getMinimumContainersHeight() {
        int totalHeight = 0;
        List childFigures = this.getChildren();
        Iterator iter = childFigures.iterator();
        Object nextObject = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (!(nextObject instanceof UmlClassifierContainerFigure)) continue;
            UmlClassifierContainerFigure fig = nextObject;
            if (fig.getDiagramModelNode().isHeightFixed()) {
                totalHeight += fig.getDiagramModelNode().getFixedHeight();
                continue;
            }
            totalHeight += ((UmlClassifierContainerFigure)nextObject).getMinimumHeight();
        }
        return totalHeight;
    }

    public IFigure getNameFigure() {
        if (this.header != null) {
            return this.header.getNameFigure();
        }
        return null;
    }

    private List getOrderedContainerFigures() {
        ArrayList<IFigure> returnList = new ArrayList<IFigure>();
        int i = 0;
        while (i < 4) {
            IFigure containerFigure = this.getContainerFigure(i);
            if (containerFigure != null) {
                returnList.add(containerFigure);
            }
            ++i;
        }
        return returnList;
    }

    @Override
    public void hiliteBackground(Color hiliteColor) {
        this.header.hiliteBackground(hiliteColor);
    }

    private void init(String stereotype, String name, String location, Image icon) {
        this.header = new UmlClassifierHeader(stereotype, name, location, icon, this.getColor(1));
        this.add((IFigure)this.header);
        this.footer = new UmlClassifierFooter();
        this.add((IFigure)this.footer);
        this.setBorder((Border)new SimpleRaisedBorder(2));
        this.setForegroundColor(ColorConstants.darkBlue);
        this.setBackgroundColor(this.getColor(1));
        this.header.setDefaultBkgdColor(this.getColor(0));
        this.footer.setDefaultBkgdColor(this.getColor(1));
        this.addExpandControl();
        this.header.setExpandControl(this.getExpansionFigure());
    }

    @Override
    public boolean isExpandable() {
        return this.expandable;
    }

    @Override
    public void layoutFigure() {
        int minWidth = 10;
        Dimension minHeaderSize = this.header.getInitialMinimumSize();
        int currentY = this.header.getSize().height + this.header.getLocation().y;
        minWidth = Math.max(minWidth, minHeaderSize.width);
        int leftX = 0;
        List containerFigures = this.getOrderedContainerFigures();
        Iterator iter = containerFigures.iterator();
        Object nextObject = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (!(nextObject instanceof UmlClassifierContainerFigure)) continue;
            ((UmlClassifierContainerFigure)nextObject).setLocation(new Point(leftX, currentY));
            currentY += ((UmlClassifierContainerFigure)nextObject).getSize().height;
            minWidth = Math.max(minWidth, ((UmlClassifierContainerFigure)nextObject).getSize().width + ySpacing * 2);
        }
        this.footer.setLocation(new Point(0, currentY));
        currentY += this.footer.getSize().height;
        this.header.setSize(minWidth, this.header.getSize().height);
        this.header.layoutThisFigure();
        currentY = this.header.getSize().height + this.header.getLocation().y;
        iter = containerFigures.iterator();
        nextObject = null;
        UmlClassifierContainerFigure nextFigure = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (!(nextObject instanceof UmlClassifierContainerFigure)) continue;
            nextFigure = nextObject;
            nextFigure.setLocation(new Point(leftX, currentY));
            currentY += nextFigure.getSize().height;
            int currentH = nextFigure.getSize().height;
            nextFigure.setSize(minWidth, currentH);
        }
        this.footer.setSize(minWidth, this.footer.getSize().height);
        this.footer.setLocation(new Point(0, currentY));
        this.resetIconLocations();
        this.setSize(minWidth, currentY += this.footer.getSize().height);
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        graphics.setForegroundColor(this.getLocalBackgroundColor());
        graphics.setBackgroundColor(this.getLocalForegroundColor());
        graphics.fillGradient(this.getBounds(), true);
        super.paint(graphics);
        this.paintSeparators(graphics);
        graphics.popState();
        graphics.restoreState();
    }

    private void paintSeparators(Graphics graphics) {
        int orgX = this.getBounds().x;
        int orgY = this.getBounds().y;
        int width = this.getBounds().width;
        int currentY = orgY;
        graphics.setLineWidth(1);
        graphics.setForegroundColor(ColorConstants.darkGray);
        List containerFigures = this.getOrderedContainerFigures();
        for (Figure nextFigure : containerFigures) {
            currentY = orgY + nextFigure.getBounds().y + 1;
            graphics.drawLine(orgX + 1, currentY, orgX + width - 2, currentY);
        }
        currentY = orgY + this.footer.getBounds().y + 2;
        graphics.drawLine(orgX + 1, currentY, orgX + width - 2, currentY);
    }

    @Override
    public void refreshFont() {
        super.refreshFont();
        this.header.refreshFont();
        this.layoutFigure();
        this.updateForSize(this.getSize());
    }

    private void resetIconLocations() {
        if (((Label)this.header.getNameFigure()).getIcon() != null) {
            int newY;
            int newX;
            Rectangle iconBounds = ((Label)this.header.getNameFigure()).getIconBounds();
            if (this.warningIcon != null) {
                newX = iconBounds.x;
                newY = iconBounds.y + iconBounds.height - this.warningIcon.getBounds().height;
                this.warningIcon.setLocation(new Point(newX, newY));
            }
            if (this.errorIcon != null) {
                newX = iconBounds.x;
                newY = iconBounds.y + iconBounds.height - this.errorIcon.getBounds().height;
                this.errorIcon.setLocation(new Point(newX, newY));
            }
        }
        this.setExtraImageLocation();
    }

    @Override
    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
        this.topLeftArrow.setVisible(expandable);
        this.repaint();
    }

    private void setExtraImageLocation() {
        if (this.extraImage != null) {
            int newX = 0;
            int newY = 0;
            int iWidth = this.extraImage.getSize().width;
            int iHeight = this.extraImage.getSize().height;
            int thisWidth = this.getSize().width;
            int thisHeight = this.getSize().height;
            switch (this.extraImagePosition) {
                case 0: {
                    newX = 4;
                    newY = 2;
                    break;
                }
                case 1: {
                    newX = thisWidth / 2 - iWidth / 2;
                    newY = 2;
                    break;
                }
                case 2: {
                    newX = thisWidth - 4 - iWidth;
                    newY = 2;
                    break;
                }
                case 3: {
                    newX = 4;
                    newY = thisHeight / 2 - iHeight / 2;
                    break;
                }
                case 4: {
                    newX = thisWidth / 2 - iWidth / 2;
                    newY = thisHeight / 2 - iHeight / 2;
                    break;
                }
                case 5: {
                    newX = thisWidth - 2 - iWidth;
                    newY = thisHeight / 2 - iHeight / 2;
                    break;
                }
                case 6: {
                    newX = 4;
                    newY = thisHeight - 2 - iHeight;
                    break;
                }
                case 7: {
                    newX = thisWidth / 2 - iWidth / 2;
                    newY = thisHeight - 2 - iHeight;
                    break;
                }
                case 8: {
                    newX = thisWidth - 4 - iWidth;
                    newY = thisHeight - 2 - iHeight;
                    break;
                }
                default: {
                    newX = 2;
                    newY = 2;
                }
            }
            this.extraImage.setLocation(new Point(newX, newY));
        }
    }

    public void setNameFontStyle(int style) {
        this.header.setNameFontStyle(style);
        this.header.refreshFont();
    }

    @Override
    public void showSelected(boolean selected) {
        if (selected) {
            this.setForegroundColor(this.getColor(3));
        } else {
            this.setForegroundColor(this.getColor(1));
        }
    }

    private void stackFigure() {
        int currentY = this.header.getSize().height + this.header.getLocation().y;
        int leftX = 0;
        List containerFigures = this.getOrderedContainerFigures();
        Iterator iter = containerFigures.iterator();
        Object nextObject = null;
        while (iter.hasNext()) {
            nextObject = iter.next();
            if (!(nextObject instanceof UmlClassifierContainerFigure)) continue;
            ((UmlClassifierContainerFigure)nextObject).setLocation(new Point(leftX, currentY));
            currentY += ((UmlClassifierContainerFigure)nextObject).getSize().height;
        }
        this.footer.setLocation(new Point(0, currentY));
    }

    @Override
    public void updateForError(boolean hasErrors) {
        if (hasErrors) {
            if (this.errorIcon == null) {
                this.errorIcon = new ImageFigure(DiagramUiPlugin.getDefault().getImage("icons/full/ovr16/error_co.gif"));
                if (this.errorIcon != null) {
                    this.add((IFigure)this.errorIcon);
                    this.errorIcon.setSize(this.errorIcon.getPreferredSize());
                }
            }
        } else if (this.errorIcon != null) {
            this.remove((IFigure)this.errorIcon);
            this.errorIcon = null;
        }
        this.resetIconLocations();
    }

    @Override
    public void updateForName(String newName) {
        this.header.refreshName(newName);
    }

    public void updateForPath(String newPath) {
        this.header.refreshPath(newPath);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void updateForSize(Dimension newSize) {
        block5: {
            leftoverHeight = newSize.height;
            this.header.setSize(newSize.width, this.header.getSize().height);
            this.header.layoutThisFigure();
            scrollingNeeded = true;
            minimumContainerHeight = this.getMinimumContainersHeight();
            if (minimumContainerHeight < (leftoverHeight -= this.header.getSize().height)) {
                scrollingNeeded = false;
            }
            newWidth = newSize.width;
            childFigures = this.getChildren();
            iter = childFigures.iterator();
            nextObject = null;
            nextFigure = null;
            if (!scrollingNeeded) ** GOTO lbl32
            availableHeight = leftoverHeight - 5;
            while (iter.hasNext()) {
                nextObject = iter.next();
                if (!(nextObject instanceof UmlClassifierContainerFigure)) continue;
                nextFigure = nextObject;
                newH = (int)((double)availableHeight * this.containerHeightRatio(nextFigure));
                nextFigure.setSize(newWidth, newH);
                leftoverHeight -= newH;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                nextObject = iter.next();
                if (!(nextObject instanceof UmlClassifierContainerFigure)) continue;
                nextFigure = nextObject;
                newH = nextFigure.getMinimumHeight();
                if (nextFigure.getDiagramModelNode().isHeightFixed()) {
                    newH = nextFigure.getDiagramModelNode().getFixedHeight();
                }
                nextFigure.setSize(newWidth, newH);
                leftoverHeight -= newH;
lbl32:
                // 3 sources

                ** while (iter.hasNext())
            }
        }
        if (leftoverHeight < 10) {
            leftoverHeight = 10;
        }
        this.footer.setSize(newWidth, leftoverHeight);
        this.stackFigure();
        this.resetIconLocations();
    }

    @Override
    public void updateForWarning(boolean hasWarnings) {
        if (hasWarnings) {
            if (this.warningIcon == null) {
                this.warningIcon = new ImageFigure(DiagramUiPlugin.getDefault().getImage("icons/full/ovr16/warning_co.gif"));
                if (this.warningIcon != null) {
                    this.add((IFigure)this.warningIcon);
                    this.warningIcon.setSize(this.warningIcon.getPreferredSize());
                }
            }
        } else if (this.warningIcon != null) {
            this.remove((IFigure)this.warningIcon);
            this.warningIcon = null;
        }
        this.resetIconLocations();
    }
}

