/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;
import org.teiid.designer.diagram.ui.figure.AbstractDiagramFigure;
import org.teiid.designer.diagram.ui.figure.LabeledRectangleFigure;
import org.teiid.designer.diagram.ui.util.colors.ColorPalette;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditFigure;

public class UmlPackageFigure
extends AbstractDiagramFigure
implements DirectEditFigure {
    private ImageFigure errorIcon;
    private ImageFigure warningIcon;
    private Polygon packageOutline;
    private LabeledRectangleFigure stereotypeLabel;
    private LabeledRectangleFigure nameLabel;
    private LabeledRectangleFigure locationLabel;
    private int tabHeight = 15;
    private int tabWidth = 40;
    private static final int MIN_TAB_WIDTH = 40;
    private static final int ySpacing = 2;
    private static final int xInset = 6;
    private PointList packagePoints = new PointList();

    public UmlPackageFigure(ColorPalette colorPalette) {
        super(colorPalette);
        this.init("<<stereotype>>", "package", "location", null, null);
        this.createComponent();
    }

    public UmlPackageFigure(String stereotype, String name, String location, Image icon, ColorPalette colorPalette) {
        super(colorPalette);
        this.init(stereotype, name, location, icon, colorPalette);
        this.createComponent();
    }

    private void init(String stereotype, String name, String location, Image icon, ColorPalette colorPalette) {
        this.packageOutline = new Polygon();
        this.packagePoints.addPoint(0, 0);
        this.packagePoints.addPoint(40, 0);
        this.packagePoints.addPoint(40, 15);
        this.packagePoints.addPoint(120, 15);
        this.packagePoints.addPoint(120, 80);
        this.packagePoints.addPoint(0, 80);
        this.packagePoints.addPoint(0, 0);
        this.packageOutline.setPoints(this.packagePoints);
        this.add((IFigure)this.packageOutline);
        this.packageOutline.setForegroundColor(ColorConstants.darkBlue);
        this.packageOutline.setBackgroundColor(this.getColor(1));
        this.packageOutline.setFill(true);
        this.packageOutline.setLineWidth(0);
        if (stereotype != null) {
            if (this.stereotypeLabel == null) {
                this.stereotypeLabel = new LabeledRectangleFigure(stereotype, true, colorPalette);
                this.add((IFigure)this.stereotypeLabel);
            } else {
                this.stereotypeLabel.getLabel().setText(stereotype);
            }
            this.stereotypeLabel.setTextColor(ColorConstants.darkGray);
        }
        if (name != null) {
            if (this.nameLabel == null) {
                this.nameLabel = icon != null ? new LabeledRectangleFigure(name, icon, true, colorPalette) : new LabeledRectangleFigure(name, true, null);
                this.add((IFigure)this.nameLabel);
            } else {
                this.nameLabel.getLabel().setText(name);
            }
            this.nameLabel.layoutFigure();
        }
        if (location != null) {
            if (this.locationLabel == null) {
                this.locationLabel = new LabeledRectangleFigure(location, true, colorPalette);
                this.add((IFigure)this.locationLabel);
            } else {
                this.locationLabel.getLabel().setText(name);
            }
            this.locationLabel.setTextColor(ColorConstants.darkGray);
        }
        this.refreshFont();
    }

    private void createComponent() {
        this.setInitialSize();
        if (this.stereotypeLabel != null) {
            this.stereotypeLabel.setBackgroundColor(this.packageOutline.getLocalBackgroundColor());
        }
        if (this.nameLabel != null) {
            this.nameLabel.setBackgroundColor(this.packageOutline.getLocalBackgroundColor());
        }
        if (this.locationLabel != null) {
            this.locationLabel.setBackgroundColor(this.packageOutline.getLocalBackgroundColor());
        }
    }

    private void setInitialSize() {
        this.setTab();
        int maxWidth = this.tabWidth;
        int maxHeight = this.tabHeight + 4;
        if (this.nameLabel != null) {
            maxHeight += this.nameLabel.getBounds().height + 2;
            maxWidth = Math.max(maxWidth, this.nameLabel.getSize().width);
        }
        if (this.locationLabel != null) {
            maxHeight += this.locationLabel.getBounds().height + 2;
            maxWidth = Math.max(maxWidth, this.locationLabel.getSize().width);
        }
        this.replacePoint(1, this.tabWidth, 0);
        this.replacePoint(2, this.tabWidth, this.tabHeight);
        this.replacePoint(3, maxWidth += 24, this.tabHeight);
        this.replacePoint(4, maxWidth, maxHeight += 4);
        this.replacePoint(5, 0, maxHeight);
        this.packageOutline.setPoints(this.packagePoints);
        this.setSize(new Dimension(maxWidth, maxHeight));
    }

    public void setTab() {
        if (this.stereotypeLabel != null && this.stereotypeLabel.getSize().width > 40) {
            this.tabHeight = this.stereotypeLabel.getSize().height + 4;
            this.tabWidth = this.stereotypeLabel.getSize().width + 24;
        }
    }

    @Override
    protected boolean useLocalCoordinates() {
        return true;
    }

    private void replacePoint(int index, int newX, int newY) {
        this.packagePoints.setPoint(new Point(newX, newY), index);
    }

    @Override
    public void layoutFigure() {
        this.setTab();
        if (this.stereotypeLabel != null) {
            this.stereotypeLabel.setLocation(new Point(6, 2));
        }
        int centerX = this.getSize().width / 2;
        int currentY = this.tabHeight + 4;
        if (this.nameLabel != null) {
            this.nameLabel.setLocation(new Point(centerX - this.nameLabel.getBounds().width / 2, currentY));
            currentY += this.nameLabel.getBounds().height + 2;
        }
        if (this.locationLabel != null) {
            this.locationLabel.setLocation(new Point(centerX - this.locationLabel.getBounds().width / 2, currentY));
        }
        this.resetIconLocations();
    }

    private void resetIconLocations() {
        if (this.errorIcon != null) {
            this.errorIcon.setLocation(new Point(this.nameLabel.getLocation().x, this.nameLabel.getLocation().y + this.errorIcon.getBounds().height));
        }
        if (this.warningIcon != null) {
            this.warningIcon.setLocation(new Point(this.nameLabel.getLocation().x, this.nameLabel.getLocation().y + this.warningIcon.getBounds().height));
        }
    }

    @Override
    public void updateForSize(Dimension newSize) {
        this.replacePoint(3, newSize.width, this.tabHeight);
        this.replacePoint(4, newSize.width, newSize.height);
        this.replacePoint(5, 0, newSize.height);
        this.packageOutline.setPoints(this.packagePoints);
        this.resetIconLocations();
    }

    @Override
    public void updateForName(String newName) {
        this.nameLabel.updateForName(newName);
        this.setInitialSize();
    }

    public void updateForPath(String newPath) {
        if (this.locationLabel != null) {
            this.locationLabel.updateForName(newPath);
        }
    }

    @Override
    public void refreshFont() {
        Font baseFont = ScaledFontManager.getFont();
        Font smallerFont = this.getSmallerFont();
        if (this.stereotypeLabel != null) {
            this.stereotypeLabel.updateForFont(smallerFont);
        }
        if (this.nameLabel != null) {
            this.nameLabel.updateForFont(baseFont);
        }
        if (this.locationLabel != null) {
            this.locationLabel.updateForFont(smallerFont);
        }
        this.layoutFigure();
        this.setInitialSize();
        this.updateForSize(this.getSize());
    }

    private Font getSmallerFont() {
        return ScaledFontManager.getFont(-1);
    }

    @Override
    public void updateForError(boolean hasErrors) {
        if (hasErrors) {
            if (this.errorIcon == null) {
                this.errorIcon = new ImageFigure(DiagramUiPlugin.getDefault().getImage("icons/full/ovr16/error_co.gif"));
                if (this.errorIcon != null) {
                    this.add((IFigure)this.errorIcon);
                    this.errorIcon.setLocation(new Point(this.nameLabel.getLocation().x, this.nameLabel.getLocation().y));
                    this.errorIcon.setSize(this.errorIcon.getPreferredSize());
                }
            }
        } else if (this.errorIcon != null) {
            this.remove((IFigure)this.errorIcon);
            this.errorIcon = null;
        }
    }

    @Override
    public void updateForWarning(boolean hasWarnings) {
        if (hasWarnings) {
            if (this.warningIcon == null) {
                this.warningIcon = new ImageFigure(DiagramUiPlugin.getDefault().getImage("icons/full/ovr16/warning_co.gif"));
                if (this.warningIcon != null) {
                    this.add((IFigure)this.warningIcon);
                    this.warningIcon.setLocation(new Point(this.nameLabel.getLocation().x, this.nameLabel.getLocation().y));
                    this.warningIcon.setSize(this.warningIcon.getPreferredSize());
                }
            }
        } else if (this.warningIcon != null) {
            this.remove((IFigure)this.warningIcon);
            this.warningIcon = null;
        }
    }

    @Override
    public Label getLabelFigure() {
        return this.nameLabel.getLabel();
    }

    public IFigure getNameFigure() {
        return this.nameLabel;
    }

    private void paintOutlineRaisedBorder(Graphics g) {
        int orgX = this.getBounds().x;
        int orgY = this.getBounds().y;
        PointList pts = this.packageOutline.getPoints();
        g.setLineStyle(1);
        g.setLineWidth(2);
        g.setXORMode(false);
        g.setForegroundColor(ColorConstants.buttonDarkest);
        g.drawLine(orgX + pts.getPoint((int)1).x, orgY + pts.getPoint((int)1).y, orgX + pts.getPoint((int)2).x, orgY + pts.getPoint((int)2).y);
        g.drawLine(orgX + pts.getPoint((int)3).x - 1, orgY + pts.getPoint((int)3).y, orgX + pts.getPoint((int)4).x - 1, orgY + pts.getPoint((int)4).y);
        g.drawLine(orgX + pts.getPoint((int)4).x, orgY + pts.getPoint((int)4).y - 1, orgX + pts.getPoint((int)5).x - 1, orgY + pts.getPoint((int)5).y - 1);
        g.setForegroundColor(ColorConstants.buttonLightest);
        g.drawLine(orgX + pts.getPoint((int)0).x, orgY + pts.getPoint((int)0).y + 1, orgX + pts.getPoint((int)1).x, orgY + pts.getPoint((int)1).y + 1);
        g.drawLine(orgX + pts.getPoint((int)2).x, orgY + pts.getPoint((int)2).y, orgX + pts.getPoint((int)3).x - 1, orgY + pts.getPoint((int)3).y);
        g.drawLine(orgX + pts.getPoint((int)5).x + 1, orgY + pts.getPoint((int)5).y - 1, orgX + pts.getPoint((int)6).x + 1, orgY + pts.getPoint((int)6).y);
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.paintOutlineRaisedBorder(g);
    }
}

