/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlAssociation;
import org.teiid.designer.core.metamodel.aspect.uml.UmlClassifier;
import org.teiid.designer.core.metamodel.aspect.uml.UmlDiagramAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlOperation;
import org.teiid.designer.core.metamodel.aspect.uml.UmlProperty;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.connection.BinaryAssociation;
import org.teiid.designer.diagram.ui.connection.DiagramUmlAssociation;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.connection.UmlRelationshipFactory;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.model.ExpandableNode;
import org.teiid.designer.diagram.ui.notation.uml.model.IClassifierContentAdapter;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierContainerNode;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlModelNode;
import org.teiid.designer.diagram.ui.part.ExpandableDiagram;
import org.teiid.designer.diagram.ui.util.DiagramEntityAdapter;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class UmlClassifierNode
extends UmlModelNode
implements ExpandableNode {
    boolean expandedState = false;
    private UmlClassifierContainerNode attributesContainer;
    private UmlClassifierContainerNode associationsContainer;
    private UmlClassifierContainerNode operationsContainer;
    private UmlClassifierContainerNode classifiersContainer;

    public UmlClassifierNode(Diagram diagram, EObject modelObject, UmlClassifier aspect) {
        super(diagram, modelObject, (UmlDiagramAspect)aspect);
        this.reconcile();
    }

    public UmlClassifierNode(Diagram diagram, EObject modelObject, UmlClassifier aspect, boolean isNested) {
        super(diagram, modelObject, (UmlDiagramAspect)aspect, isNested);
        this.reconcile();
    }

    public boolean showInnerClasses(EObject eObj, Diagram diagram) {
        boolean show = false;
        IClassifierContentAdapter classAdapter = DiagramUiPlugin.getDiagramTypeManager().getDiagram(diagram.getType()).getClassifierContentAdapter();
        if (classAdapter != null) {
            show = classAdapter.showInnerClasses(eObj, diagram);
        }
        return show;
    }

    public MetamodelAspect getUmlAspect(EObject eObject) {
        return DiagramUiPlugin.getDiagramAspectManager().getUmlAspect(eObject);
    }

    @Override
    public String getName() {
        return this.aspect.getSignature((Object)this.getRealModelObject(), 1);
    }

    @Override
    public String getPath() {
        String somePath = null;
        if (this.getDiagramModelObject() != null) {
            Diagram theDiagram = this.getDiagramModelObject().getDiagram();
            somePath = DiagramUiPlugin.getDiagramTypeManager().getDisplayedPath(theDiagram, this.getRealModelObject());
        }
        return somePath;
    }

    public void refreshForNameChange() {
        String oldName = "xxxXxxx";
        if (this.getDiagramModelObject() != null && !this.isReadOnly()) {
            DiagramEntityAdapter.setName(this.getDiagramModelObject(), this.getName());
        }
        this.firePropertyChange("name", oldName, this.getName());
    }

    public void refreshForPathChange() {
        this.update("path");
    }

    @Override
    public void setName(String name) {
        ModelObjectUtilities.rename((EObject)this.getRealModelObject(), (String)name, (Object)this);
    }

    public void setSignature(String signature) {
        this.aspect.setSignature((Object)this.getRealModelObject(), signature);
    }

    @Override
    public String toString() {
        return "UmlClassifierNode(" + this.getName() + ")";
    }

    public List getAttributes() {
        if (this.attributesContainer != null) {
            return this.attributesContainer.getChildren();
        }
        return Collections.EMPTY_LIST;
    }

    public DiagramModelNode getAttributesContainer() {
        return this.attributesContainer;
    }

    @Override
    public List getAssociations(HashMap nodeMap) {
        IPreferenceStore store = DiagramUiPlugin.getDefault().getPreferenceStore();
        boolean showRoles = store.getBoolean("showFkName");
        boolean showMulti = store.getBoolean("showFkMultiplicity");
        MetamodelAspect classifierAspect = this.getUmlAspect(this.getRealModelObject());
        if (classifierAspect instanceof UmlClassifier) {
            Object nextObject;
            Iterator iter;
            ArrayList<NodeConnectionModel> returnAssociations = new ArrayList<NodeConnectionModel>();
            DiagramModelNode diagramRootModelObject = this.getParent();
            Collection relationships = ((UmlClassifier)classifierAspect).getRelationships((Object)this.getRealModelObject());
            Collection superTypes = ((UmlClassifier)classifierAspect).getSupertypes((Object)this.getRealModelObject());
            ArrayList<Object> allAssociations = new ArrayList<Object>();
            if (relationships != null && !relationships.isEmpty()) {
                iter = relationships.iterator();
                nextObject = null;
                while (iter.hasNext()) {
                    nextObject = iter.next();
                    if (allAssociations.contains(nextObject)) continue;
                    allAssociations.add(nextObject);
                }
            }
            if (superTypes != null && !superTypes.isEmpty()) {
                iter = superTypes.iterator();
                nextObject = null;
                while (iter.hasNext()) {
                    nextObject = iter.next();
                    if (allAssociations.contains(nextObject)) continue;
                    allAssociations.add(nextObject);
                }
            }
            List allBasses = UmlRelationshipFactory.getBinaryAssociations(allAssociations, this.getRealModelObject());
            Iterator iter2 = allBasses.iterator();
            BinaryAssociation nextBass = null;
            NodeConnectionModel newConnectionModel = null;
            while (iter2.hasNext()) {
                nextBass = (BinaryAssociation)iter2.next();
                newConnectionModel = UmlRelationshipFactory.getConnectionModel(nextBass, diagramRootModelObject, nodeMap);
                if (newConnectionModel instanceof DiagramUmlAssociation) {
                    ((DiagramUmlAssociation)newConnectionModel).setShowRoles(showRoles);
                    ((DiagramUmlAssociation)newConnectionModel).setShowMultiplicity(showMulti);
                }
                if (newConnectionModel == null) continue;
                returnAssociations.add(newConnectionModel);
            }
            if (returnAssociations.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            return returnAssociations;
        }
        return Collections.EMPTY_LIST;
    }

    public DiagramModelNode addChild(EObject eObj) {
        this.reconcile();
        DiagramModelNode newNode = this.getChild(eObj);
        if (newNode != null) {
            this.updateForChild(true);
        }
        return newNode;
    }

    public void removeChild(DiagramModelNode childNode) {
        if (this.attributesContainer != null && this.attributesContainer.getChildren().contains(childNode)) {
            this.attributesContainer.removeChild(childNode, false);
            if (this.attributesContainer.getChildren() == null || this.attributesContainer.getChildren().isEmpty()) {
                super.removeChild(this.attributesContainer, false);
                this.attributesContainer = null;
            }
        } else if (this.associationsContainer != null && this.associationsContainer.getChildren().contains(childNode)) {
            this.associationsContainer.removeChild(childNode, false);
            if (this.associationsContainer.getChildren() == null || this.associationsContainer.getChildren().isEmpty()) {
                super.removeChild(this.associationsContainer, false);
                this.associationsContainer = null;
            }
        } else if (this.operationsContainer != null && this.operationsContainer.getChildren().contains(childNode)) {
            this.operationsContainer.removeChild(childNode, false);
            if (this.operationsContainer.getChildren() == null || this.operationsContainer.getChildren().isEmpty()) {
                super.removeChild(this.operationsContainer, false);
                this.operationsContainer = null;
            }
        } else if (this.classifiersContainer != null && this.classifiersContainer.getChildren().contains(childNode)) {
            this.classifiersContainer.removeChild(childNode, false);
            if (this.classifiersContainer.getChildren() == null || this.classifiersContainer.getChildren().isEmpty()) {
                super.removeChild(this.classifiersContainer, false);
                this.classifiersContainer = null;
            }
        }
        this.updateForChild(false);
    }

    @Override
    public void updateForChild(boolean isMove) {
        if (isMove) {
            this.reorderChildren();
            if (this.attributesContainer != null) {
                this.attributesContainer.updateForChild(false);
            }
            if (this.associationsContainer != null) {
                this.associationsContainer.updateForChild(false);
            }
            if (this.operationsContainer != null) {
                this.operationsContainer.updateForChild(false);
            }
            if (this.classifiersContainer != null) {
                this.classifiersContainer.updateForChild(false);
            }
            super.updateForChild(false);
        } else {
            super.updateForChild(isMove);
        }
    }

    public void reorderChildren() {
        Diagram diagram = null;
        if (this.getDiagramModelObject() == null) {
            DiagramModelNode diagramNode = DiagramUiUtilities.getTopClassifierParentNode(this);
            Diagram mo = diagramNode.getDiagram();
            if (mo instanceof Diagram) {
                diagram = mo;
            } else {
                String message = " UmlClassifierNode.reorderChildren():  modelObject NOT Diagram. Object = " + mo + " for DiagramModelNode = " + diagramNode;
                DiagramUiConstants.Util.log(4, message);
            }
        } else {
            diagram = (Diagram)this.getDiagramModelObject().eContainer();
        }
        if (diagram != null) {
            EObject modelObject = this.getRealModelObject();
            boolean showInnerClasses = this.showInnerClasses(modelObject, diagram);
            List list = this.getChildren(this.getRealModelObject());
            Iterator iter = list.iterator();
            ArrayList<EObject> newAttributeList = new ArrayList<EObject>();
            ArrayList<EObject> newAssociationList = new ArrayList<EObject>();
            ArrayList<EObject> newOperationList = new ArrayList<EObject>();
            ArrayList<EObject> newClassifiersList = new ArrayList<EObject>();
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                MetamodelAspect mmAspect = this.getUmlAspect(eObj);
                if (mmAspect instanceof UmlProperty) {
                    newAttributeList.add(eObj);
                    continue;
                }
                if (mmAspect instanceof UmlAssociation) {
                    newAssociationList.add(eObj);
                    continue;
                }
                if (mmAspect instanceof UmlOperation) {
                    newOperationList.add(eObj);
                    continue;
                }
                if (!(mmAspect instanceof UmlClassifier) || !showInnerClasses) continue;
                newClassifiersList.add(eObj);
            }
            if (!newAttributeList.isEmpty() && this.attributesContainer != null) {
                this.attributesContainer.reorderChildren(newAttributeList);
            }
            if (!newAssociationList.isEmpty() && this.associationsContainer != null) {
                this.associationsContainer.reorderChildren(newAssociationList);
            }
            if (!newOperationList.isEmpty() && this.operationsContainer != null) {
                this.operationsContainer.reorderChildren(newOperationList);
            }
            if (!newClassifiersList.isEmpty() && this.classifiersContainer != null) {
                this.classifiersContainer.reorderChildren(newClassifiersList);
            }
        }
    }

    protected List getChildren(EObject parent) {
        return DiagramUiPlugin.getDiagramAspectManager().getChildren(parent);
    }

    private DiagramModelNode getChild(EObject eObj) {
        DiagramModelNode childNode = null;
        if (this.attributesContainer != null) {
            childNode = this.attributesContainer.getChild(eObj);
        }
        if (childNode == null && this.associationsContainer != null) {
            childNode = this.associationsContainer.getChild(eObj);
        }
        if (childNode == null && this.operationsContainer != null) {
            childNode = this.operationsContainer.getChild(eObj);
        }
        if (childNode == null && this.classifiersContainer != null) {
            childNode = this.classifiersContainer.getChild(eObj);
        }
        return childNode;
    }

    public void reconcile() {
        if (this.getRealModelObject() != null) {
            boolean showInnerClasses = this.showInnerClasses(this.getRealModelObject(), this.getDiagram());
            List list = this.getChildren(this.getRealModelObject());
            Iterator iter = list.iterator();
            ArrayList<EObject> attributeList = new ArrayList<EObject>();
            ArrayList<EObject> associationList = new ArrayList<EObject>();
            ArrayList<EObject> operationList = new ArrayList<EObject>();
            ArrayList<EObject> classifiersList = new ArrayList<EObject>();
            while (iter.hasNext()) {
                EObject eObj = (EObject)iter.next();
                MetamodelAspect mmAspect = this.getUmlAspect(eObj);
                if (mmAspect instanceof UmlProperty) {
                    attributeList.add(eObj);
                    continue;
                }
                if (mmAspect instanceof UmlAssociation) {
                    associationList.add(eObj);
                    continue;
                }
                if (mmAspect instanceof UmlOperation) {
                    operationList.add(eObj);
                    continue;
                }
                if (!(mmAspect instanceof UmlClassifier) || !showInnerClasses) continue;
                classifiersList.add(eObj);
            }
            if (!attributeList.isEmpty()) {
                if (this.attributesContainer == null) {
                    this.attributesContainer = new UmlClassifierContainerNode(0, attributeList, this.getDiagram());
                    this.attributesContainer.setParent(this);
                    super.addChild(this.attributesContainer);
                } else {
                    this.attributesContainer.reconcile(attributeList, this.getDiagram());
                }
            } else if (this.attributesContainer != null) {
                super.removeChild(this.attributesContainer, false);
                this.attributesContainer = null;
            }
            if (!associationList.isEmpty()) {
                if (this.associationsContainer == null) {
                    this.associationsContainer = new UmlClassifierContainerNode(1, associationList, this.getDiagram());
                    this.associationsContainer.setParent(this);
                    super.addChild(this.associationsContainer);
                } else {
                    this.associationsContainer.reconcile(associationList, this.getDiagram());
                }
            } else if (this.associationsContainer != null) {
                super.removeChild(this.associationsContainer, false);
                this.associationsContainer = null;
            }
            if (!operationList.isEmpty()) {
                if (this.operationsContainer == null) {
                    this.operationsContainer = new UmlClassifierContainerNode(1, operationList, this.getDiagram());
                    this.operationsContainer.setParent(this);
                    super.addChild(this.operationsContainer);
                } else {
                    this.operationsContainer.reconcile(operationList, this.getDiagram());
                }
            } else if (this.operationsContainer != null) {
                super.removeChild(this.operationsContainer, false);
                this.operationsContainer = null;
            }
            if (!classifiersList.isEmpty()) {
                if (this.classifiersContainer == null) {
                    this.classifiersContainer = new UmlClassifierContainerNode(3, classifiersList, this.getDiagram());
                    this.classifiersContainer.setParent(this);
                    super.addChild(this.classifiersContainer);
                } else {
                    this.classifiersContainer.reconcile(classifiersList, this.getDiagram());
                }
            } else if (this.classifiersContainer != null) {
                super.removeChild(this.classifiersContainer, false);
                this.classifiersContainer = null;
            }
            this.setErrorState();
            this.reorderChildren();
        }
    }

    public boolean isAbstract() {
        return ((UmlClassifier)this.getUmlAspect()).isAbstract((Object)this.getRealModelObject());
    }

    @Override
    public void setErrorState() {
        int errorValue;
        super.setErrorState();
        if (!this.hasWarnings() && !this.hasErrors()) {
            int errorValue2 = this.childErrorState();
            if (errorValue2 == 2) {
                this.errorState = true;
            } else if (errorValue2 == 1) {
                this.warningState = true;
            }
        } else if (this.hasWarnings() && (errorValue = this.childErrorState()) == 2) {
            this.errorState = true;
            this.warningState = false;
        }
    }

    private int childErrorState() {
        int state = 0;
        Iterator iter = null;
        DiagramModelNode nextNode = null;
        if (this.attributesContainer != null && this.attributesContainer.getChildren() != null && !this.attributesContainer.getChildren().isEmpty()) {
            iter = this.attributesContainer.getChildren().iterator();
            while (iter.hasNext() && state < 2) {
                nextNode = (DiagramModelNode)iter.next();
                if (nextNode.hasWarnings()) {
                    state = 1;
                }
                if (!nextNode.hasErrors()) continue;
                state = 2;
            }
        }
        if (state < 2 && this.associationsContainer != null && this.associationsContainer.getChildren() != null && !this.associationsContainer.getChildren().isEmpty()) {
            iter = this.associationsContainer.getChildren().iterator();
            while (iter.hasNext() && state < 2) {
                nextNode = (DiagramModelNode)iter.next();
                if (nextNode.hasWarnings()) {
                    state = 1;
                }
                if (!nextNode.hasErrors()) continue;
                state = 2;
            }
        }
        if (state < 2 && this.operationsContainer != null && this.operationsContainer.getChildren() != null && !this.operationsContainer.getChildren().isEmpty()) {
            iter = this.operationsContainer.getChildren().iterator();
            while (iter.hasNext() && state < 2) {
                nextNode = (DiagramModelNode)iter.next();
                if (nextNode.hasWarnings()) {
                    state = 1;
                }
                if (!nextNode.hasErrors()) continue;
                state = 2;
            }
        }
        if (state < 2 && this.classifiersContainer != null && this.classifiersContainer.getChildren() != null && !this.classifiersContainer.getChildren().isEmpty()) {
            iter = this.classifiersContainer.getChildren().iterator();
            while (iter.hasNext() && state < 2) {
                nextNode = (DiagramModelNode)iter.next();
                if (nextNode.hasWarnings()) {
                    state = 1;
                }
                if (!nextNode.hasErrors()) continue;
                state = 2;
            }
        }
        return state;
    }

    protected EObject getRealModelObject() {
        return this.getModelObject();
    }

    private boolean canExpand() {
        return this.getParent() instanceof ExpandableDiagram && ((ExpandableDiagram)((Object)this.getParent())).canExpand();
    }

    public void setExpandedState(boolean b) {
        this.expandedState = b;
    }

    @Override
    public boolean isExpanded() {
        if (this.canExpand()) {
            return this.expandedState;
        }
        return true;
    }

    @Override
    public void expand() {
        if (this.canExpand()) {
            this.expandedState = true;
            this.firePropertyChange("expand", null, null);
            this.getParent().firePropertyChange("expand", null, null);
        }
    }

    @Override
    public void collapse() {
        if (this.canExpand()) {
            this.expandedState = false;
            this.firePropertyChange("collapse", null, null);
            this.getParent().firePropertyChange("expand", null, null);
        }
    }

    @Override
    public List getChildren() {
        if (this.isExpanded()) {
            return super.getChildren();
        }
        return Collections.EMPTY_LIST;
    }
}

