/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.notation.uml.part;

import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.teiid.designer.diagram.ui.figure.ContainerFigure;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.AbstractNotationEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.util.DiagramNodeSelectionEditPolicy;
import org.teiid.designer.diagram.ui.util.SelectionTracker;

public class UmlClassifierContainerEditPart
extends AbstractNotationEditPart {
    private DragTracker myDragTracker = null;

    @Override
    protected IFigure createFigure() {
        Point posn = new Point(100, 100);
        Figure newFigure = this.getFigureGenerator().createFigure(this.getModel());
        newFigure.setLocation(posn);
        ((DiagramModelNode)this.getModel()).setPosition(posn);
        ((DiagramModelNode)this.getModel()).setSize(newFigure.getSize());
        return newFigure;
    }

    protected void createEditPolicies() {
        this.setSelectablePart(false);
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new NonResizableEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new DiagramNodeSelectionEditPolicy());
    }

    protected void refreshVisuals() {
        Point posn = ((DiagramModelNode)this.getModel()).getPosition();
        Dimension size = ((DiagramModelNode)this.getModel()).getSize();
        Rectangle r = new Rectangle(posn, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)r);
        this.getFigure().repaint();
    }

    public IFigure getContentPane() {
        if (this.getFigure() instanceof ContainerFigure) {
            return ((ContainerFigure)this.getFigure()).getContentsPane();
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("children")) {
            this.getChangeManager().refresh(8, true);
            this.layout(true);
            this.getChangeManager().refresh(1, false);
            this.getChangeManager().refresh(4, false);
        } else if (prop.equals("size")) {
            this.getChangeManager().refresh(4, false);
            this.getChangeManager().refresh(1, false);
        } else if (prop.equals("location")) {
            this.getChangeManager().refresh(4, false);
            this.getChangeManager().refresh(1, false);
        } else if (prop.equals("prop")) {
            this.refreshVisuals();
            this.getChangeManager().refresh(1, false);
        }
    }

    @Override
    public void refreshFont(boolean refreshChildren) {
        if (refreshChildren) {
            List editPartChildren = this.getChildren();
            Iterator iter = editPartChildren.iterator();
            EditPart nextEP = null;
            while (iter.hasNext()) {
                nextEP = (EditPart)iter.next();
                if (!(nextEP instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEP).refreshFont(refreshChildren);
            }
        }
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().refreshFont();
            this.getDiagramFigure().layoutFigure();
            ((DiagramModelNode)this.getModel()).setSize(this.getFigure().getSize());
            ((DiagramModelNode)this.getModel()).setPosition(new Point(this.getFigure().getBounds().x, this.getFigure().getBounds().y));
        }
        this.refreshAllLabels();
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.getSelectionHandler().handleDoubleClick(((DiagramEditPart)this.getParent()).getModelObject());
        }
    }

    public DragTracker getDragTracker(Request req) {
        if (this.myDragTracker == null) {
            this.myDragTracker = new SelectionTracker((EditPart)this);
        }
        return this.myDragTracker;
    }
}

