/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.outline;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.draw2d.parts.Thumbnail;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.FreeformGraphicalRootEditPart;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.ui.editors.ModelEditorPageOutline;

public class DiagramOverview
implements IAdaptable,
ModelEditorPageOutline {
    private Canvas overview;
    private boolean overviewInitialized;
    private Thumbnail thumbnail;
    private GraphicalViewer graphicalViewer;
    private ImageDescriptor icon;
    private LightweightSystem lws;

    public DiagramOverview(GraphicalViewer graphicalViewer, SelectionSynchronizer synchronizer, Object model) {
        this.graphicalViewer = graphicalViewer;
        this.icon = DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/Overview.gif");
    }

    public void createControl(Composite parent) {
        this.overview = new Canvas(parent, 0);
        this.initializeOverview();
    }

    public void dispose() {
        if (this.overview != null && !this.overview.isDisposed()) {
            this.overview.dispose();
        }
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.graphicalViewer.getRootEditPart()).getZoomManager();
        }
        return null;
    }

    public Control getControl() {
        return this.overview;
    }

    protected void initializeOverview() {
        this.lws = new LightweightSystem(this.overview);
        RootEditPart rep = this.graphicalViewer.getRootEditPart();
        if (rep instanceof FreeformGraphicalRootEditPart) {
            ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
            this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
            this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
            this.lws.setContents((IFigure)this.thumbnail);
            this.overviewInitialized = true;
        }
    }

    protected void showOverview() {
        if (!this.overviewInitialized) {
            this.initializeOverview();
        }
        this.thumbnail.setVisible(true);
    }

    public void resetContents() {
        if (this.thumbnail != null) {
            this.thumbnail.setVisible(false);
            RootEditPart rep = this.graphicalViewer.getRootEditPart();
            if (rep instanceof FreeformGraphicalRootEditPart) {
                ScalableFreeformRootEditPart root = (ScalableFreeformRootEditPart)rep;
                this.thumbnail = new ScrollableThumbnail((Viewport)root.getFigure());
                this.thumbnail.setSource(root.getLayer((Object)"Printable Layers"));
                this.lws.setContents((IFigure)this.thumbnail);
            }
            this.thumbnail.setVisible(true);
        }
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public String getToolTipText() {
        return DiagramUiConstants.Util.getString("DiagramOverview.toolTipText", new Object[0]);
    }

    public boolean isEnabled() {
        return true;
    }

    public void setVisible(boolean visible) {
        if (this.thumbnail != null) {
            this.thumbnail.setVisible(visible);
        }
    }
}

