/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.pakkage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.notification.util.DefaultIgnorableNotificationSource;
import org.teiid.designer.core.notification.util.NotificationUtilities;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.transaction.SourcedNotification;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.model.DiagramModelFactoryImpl;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.model.LabelModelNode;
import org.teiid.designer.diagram.ui.notation.NotationModelGenerator;
import org.teiid.designer.diagram.ui.notation.uml.model.UmlClassifierNode;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramNode;
import org.teiid.designer.diagram.ui.util.DiagramEntityManager;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.jdbc.JdbcSource;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramLinkType;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PackageDiagramModelFactory
extends DiagramModelFactoryImpl
implements DiagramUiConstants {
    private String sNotationId;
    private static final int I_BORDER = 20;
    private static final int X_INC = 20;
    private static final int Y_INC = 10;
    private static final int X_MAX = 600;
    private static Point startingPoint = new Point(20, 20);
    private static int yInc = 20;
    private static final String KEY_PACKAGE_DIAGRAM_NAME = "DiagramNames.packageDiagram";
    private static final String THIS_CLASS = "PackageDiagramModelFactory";
    private NotationModelGenerator generator;
    private HashMap reconcileClassifierNodes;

    public DiagramModelNode createModel(Object baseObject) {
        return null;
    }

    @Override
    public DiagramModelNode createModel(Object baseObject, String sNotationId, IProgressMonitor monitor) {
        if (!(baseObject instanceof Diagram)) {
            return null;
        }
        HashMap<EObject, DiagramModelNode> nodeMap = new HashMap<EObject, DiagramModelNode>();
        this.setSNotationId(sNotationId);
        Diagram diagram = (Diagram)baseObject;
        PackageDiagramNode diagramModelNode = null;
        List contents = null;
        EObject packageObject = null;
        EObject targetObject = diagram.getTarget();
        if (targetObject != null && targetObject instanceof EObject && !(targetObject instanceof ModelAnnotation)) {
            packageObject = diagram.getTarget();
            diagramModelNode = new PackageDiagramNode((EObject)diagram, Util.getString(KEY_PACKAGE_DIAGRAM_NAME, new Object[0]));
            contents = packageObject.eContents();
        } else if (targetObject != null && targetObject instanceof EObject && targetObject instanceof ModelAnnotation) {
            diagramModelNode = new PackageDiagramNode((EObject)diagram, Util.getString(KEY_PACKAGE_DIAGRAM_NAME, new Object[0]));
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)diagram);
            if (modelResource != null) {
                try {
                    contents = modelResource.getEObjects();
                }
                catch (ModelWorkspaceException e) {
                    contents = Collections.EMPTY_LIST;
                    String message = Util.getString("ModelErrors.getContentError", (Object)modelResource.getItemName());
                    DiagramUiConstants.Util.log(4, (Throwable)e, message);
                }
            } else {
                contents = Collections.EMPTY_LIST;
            }
        } else {
            contents = Collections.EMPTY_LIST;
        }
        int nComponents = contents.size();
        int nStages = 1;
        int interval = nComponents < 10 ? 1 : (nComponents < 50 ? 2 : (nComponents < 200 ? 5 : (nComponents < 400 ? 10 : (nComponents < 800 ? 20 : (int)((double)nComponents / 50.0)))));
        nStages = (int)((double)nComponents / (double)interval);
        int progressInc = (int)(50.0 / (double)nStages);
        if (progressInc == 0) {
            progressInc = 1;
        }
        boolean showProgress = false;
        if (monitor != null) {
            monitor.subTask("Creating Model Components");
            showProgress = true;
        }
        if (!contents.isEmpty()) {
            String progressMessage;
            int iStage = 1;
            int iCount = 0;
            int nComps = 0;
            Iterator iter = contents.iterator();
            if (this.getGenerator() != null) {
                while (iter.hasNext()) {
                    DiagramModelNode childModelNode;
                    EObject eObj = (EObject)iter.next();
                    if (!this.isDrawable(eObj) || (childModelNode = this.getGenerator().createModel(eObj, diagram)) == null) continue;
                    nodeMap.put(eObj, childModelNode);
                    childModelNode.setParent(diagramModelNode);
                    diagramModelNode.addChild(childModelNode);
                    if (!showProgress) continue;
                    ++nComps;
                    if (++iCount != interval || iStage >= nStages) continue;
                    progressMessage = "Created " + nComps + " of " + nComponents + " Diagram Components";
                    monitor.subTask(progressMessage);
                    monitor.worked(progressInc);
                    ++iStage;
                    iCount = 0;
                }
            } else {
                Util.log(2, Util.getString("DiagramErrors.modelGeneratorFailure", new Object[0]));
            }
            if (showProgress) {
                monitor.subTask("Adding Association Links");
            }
            if (!diagramModelNode.getChildren().isEmpty()) {
                HashMap<EObject, NodeConnectionModel> connMap = new HashMap<EObject, NodeConnectionModel>();
                nComps = 0;
                ArrayList<NodeConnectionModel> realAssociations = new ArrayList<NodeConnectionModel>();
                List currentChildren = diagramModelNode.getChildren();
                for (DiagramModelNode childModelNode : currentChildren) {
                    List childAssList = childModelNode.getAssociations(nodeMap);
                    if (showProgress && ++nComps % 20 == 0) {
                        progressMessage = "Constructed Associations for " + nComps + " of " + nComponents + " Diagram Components";
                        monitor.subTask(progressMessage);
                    }
                    NodeConnectionModel nextConnection = null;
                    NodeConnectionModel nextRealConnection = null;
                    Iterator innerIter = null;
                    Iterator subIter = childAssList.iterator();
                    while (subIter.hasNext()) {
                        boolean connExists = false;
                        nextConnection = (NodeConnectionModel)subIter.next();
                        if (nextConnection.getModelObject() != null) {
                            Object existingConn = connMap.get(nextConnection.getModelObject());
                            if (existingConn != null) {
                                connExists = true;
                            }
                        } else {
                            innerIter = realAssociations.iterator();
                            while (innerIter.hasNext() && !connExists) {
                                nextRealConnection = (NodeConnectionModel)innerIter.next();
                                if (nextRealConnection == null || !nextRealConnection.equals(nextConnection)) continue;
                                connExists = true;
                            }
                        }
                        if (connExists) continue;
                        if (nextConnection.getModelObject() != null) {
                            connMap.put(nextConnection.getModelObject(), nextConnection);
                        }
                        realAssociations.add(nextConnection);
                    }
                }
                if (showProgress) {
                    monitor.subTask("Adding Association Labels");
                }
                iter = realAssociations.iterator();
                String currentRouterStyle = DiagramLinkType.get((int)DiagramEditorUtil.getCurrentDiagramRouterStyle()).getName();
                while (iter.hasNext()) {
                    NodeConnectionModel nextAssociation = (NodeConnectionModel)iter.next();
                    if (nextAssociation.getDiagramLink() == null) {
                        nextAssociation.setRouterStyle(currentRouterStyle);
                    }
                    ((DiagramModelNode)nextAssociation.getSourceNode()).addSourceConnection(nextAssociation);
                    ((DiagramModelNode)nextAssociation.getTargetNode()).addTargetConnection(nextAssociation);
                    List labelNodes = nextAssociation.getLabelNodes();
                    if (labelNodes == null || labelNodes.isEmpty()) continue;
                    Iterator labelIter = labelNodes.iterator();
                    LabelModelNode nextNode = null;
                    while (labelIter.hasNext()) {
                        nextNode = (LabelModelNode)labelIter.next();
                        diagramModelNode.addChild(nextNode);
                    }
                }
            }
        }
        return diagramModelNode;
    }

    protected NotationModelGenerator getGenerator() {
        if (this.generator == null) {
            this.generator = DiagramUiPlugin.getDiagramNotationManager().getDiagramModelGenerator(this.getSNotationId());
        }
        return this.generator;
    }

    private boolean isValidDiagram(DiagramModelNode diagramModelNode) {
        String type;
        ModelResource mr;
        boolean result = false;
        Diagram diagram = (Diagram)diagramModelNode.getModelObject();
        if (diagram != null && diagram.getTarget() != null && (mr = ModelUtilities.getModelResourceForModelObject((EObject)diagram)) != null && (type = diagram.getType()) != null && type.equals("packageDiagramType")) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean notifyModel(Notification notification, DiagramModelNode diagramModelNode, String sDiagramTypeId) {
        boolean currentDiagramOK = true;
        Diagram diagram = (Diagram)diagramModelNode.getModelObject();
        if (this.currentDiagramRemoved(diagram)) {
            currentDiagramOK = false;
        }
        if (currentDiagramOK && this.isValidDiagram(diagramModelNode) && this.sourceIsNotThis(notification) && this.shouldHandleNotification(notification, diagramModelNode)) {
            boolean requiredStart = false;
            boolean succeeded = false;
            boolean handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction(diagram);
            try {
                try {
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramUnderConstruction(diagram);
                    }
                    requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Update Package Diagram", (Object)this);
                    this.handleNotification(notification, diagramModelNode);
                    this.reconcileClassifiers(diagramModelNode);
                    DiagramEntityManager.cleanDiagramEntities(diagram);
                    succeeded = true;
                }
                catch (Exception ex) {
                    DiagramUiConstants.Util.log(4, (Throwable)ex, String.valueOf(ex.getClass().getName()) + ":" + THIS_CLASS + ".notifyModel()");
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                    if (handleConstruction) {
                        DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                    }
                }
            }
            finally {
                if (requiredStart) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
                if (handleConstruction) {
                    DiagramEditorUtil.setDiagramConstructionComplete(diagram, true);
                }
            }
        }
        return currentDiagramOK;
    }

    private boolean shouldHandleNotification(Notification notification, DiagramModelNode diagramModelNode) {
        ModelResource diagramMR;
        boolean shouldHandle = false;
        Diagram currentDiagram = (Diagram)diagramModelNode.getModelObject();
        Resource diagramModelResource = null;
        if (currentDiagram.getTarget() instanceof ModelAnnotation) {
            diagramModelResource = currentDiagram.getTarget().eResource();
        }
        if ((diagramMR = ModelUtilities.getModelResourceForModelObject((EObject)currentDiagram)) != null) {
            if (notification instanceof SourcedNotification) {
                Object source = ((SourcedNotification)notification).getSource();
                if (source == null || !source.equals(this)) {
                    Collection notifications = ((SourcedNotification)notification).getNotifications();
                    if (!notifications.isEmpty()) {
                        Iterator iter = notifications.iterator();
                        Notification nextNotification = null;
                        while (iter.hasNext() && !shouldHandle) {
                            ModelResource mr;
                            nextNotification = (Notification)iter.next();
                            Object targetObject = ModelerCore.getModelEditor().getChangedObject(nextNotification);
                            if (targetObject == null) continue;
                            if (targetObject instanceof EObject && !DiagramUiUtilities.isNonDrawingDiagramObject((EObject)targetObject)) {
                                mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject));
                                if (mr == null || !mr.equals(diagramMR)) continue;
                                shouldHandle = true;
                                continue;
                            }
                            if (targetObject instanceof Resource && diagramModelResource != null) {
                                Resource targetResource = (Resource)targetObject;
                                if (!targetResource.equals(diagramModelResource)) continue;
                                shouldHandle = true;
                                continue;
                            }
                            if (targetObject instanceof Diagram && NotificationUtilities.isRemoved((Notification)nextNotification)) {
                                mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject));
                                if (mr == null || !mr.equals(diagramMR)) continue;
                                shouldHandle = true;
                                continue;
                            }
                            if (!(targetObject instanceof Diagram) || !(notification.getNewValue() instanceof DiagramLinkType)) continue;
                            shouldHandle = true;
                        }
                    } else {
                        ModelResource mr;
                        Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
                        if (changedObj != null && changedObj instanceof EmfResource && (mr = ModelUtilities.getModelResource((Resource)((Resource)changedObj), (boolean)false)) == diagramMR) {
                            shouldHandle = true;
                        }
                    }
                }
            } else {
                Object targetObject = ModelerCore.getModelEditor().getChangedObject(notification);
                if (targetObject != null) {
                    ModelResource mr;
                    if (targetObject instanceof EObject && !DiagramUiUtilities.isNonDrawingDiagramObject((EObject)targetObject)) {
                        ModelResource mr2 = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject));
                        if (mr2 != null && mr2.equals(diagramMR)) {
                            shouldHandle = true;
                        }
                    } else if (targetObject instanceof Resource && diagramModelResource != null) {
                        Resource targetResource = (Resource)targetObject;
                        if (targetResource.equals(diagramModelResource)) {
                            shouldHandle = true;
                        }
                    } else if (targetObject instanceof Diagram && NotificationUtilities.isRemoved((Notification)notification) && (mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetObject))) != null && mr.equals(diagramMR)) {
                        shouldHandle = true;
                    }
                }
            }
        }
        return shouldHandle;
    }

    private boolean sourceIsNotThis(Notification notification) {
        if (notification instanceof SourcedNotification) {
            Object source = ((SourcedNotification)notification).getSource();
            if (source == null) {
                return true;
            }
            return !source.equals(this);
        }
        return true;
    }

    public Diagram getDiagram(EObject someTarget) {
        ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)someTarget);
        try {
            List returnedDiagrams = modelResource.getModelDiagrams().getDiagrams(someTarget);
            if (returnedDiagrams.size() == 1) {
                return (Diagram)returnedDiagrams.get(0);
            }
            for (Diagram nextDiagram : returnedDiagrams) {
                if (nextDiagram.getType() == null || !nextDiagram.getType().equals("packageDiagramType")) continue;
                return nextDiagram;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void handleNotification(Notification notification, DiagramModelNode packageDiagramModelNode) {
        if (notification instanceof SourcedNotification) {
            Collection notifications = ((SourcedNotification)notification).getNotifications();
            if (!notifications.isEmpty()) {
                Iterator iter = notifications.iterator();
                while (iter.hasNext()) {
                    this.handleSingleNotification((Notification)iter.next(), packageDiagramModelNode);
                }
            } else {
                this.handleSingleNotification(notification, packageDiagramModelNode);
            }
        } else {
            this.handleSingleNotification(notification, packageDiagramModelNode);
        }
    }

    private void handleSingleNotification(Notification notification, DiagramModelNode packageDiagramModelNode) {
        if (NotificationUtilities.isAdded((Notification)notification)) {
            this.performAdd(notification, packageDiagramModelNode);
        } else if (NotificationUtilities.isRemoved((Notification)notification)) {
            this.performRemove(notification, packageDiagramModelNode);
        } else if (NotificationUtilities.isChanged((Notification)notification)) {
            this.performChange(notification, packageDiagramModelNode);
        }
    }

    private void performAdd(Notification notification, DiagramModelNode packageDiagramModelNode) {
        boolean performedChange = false;
        if (NotificationUtilities.isEObjectNotifier((Notification)notification)) {
            EObject targetObject = NotificationUtilities.getEObject((Notification)notification);
            Diagram diagram = (Diagram)packageDiagramModelNode.getModelObject();
            boolean hasAssociations = false;
            EObject diagramTargetEObject = diagram.getTarget();
            if (diagramTargetEObject.equals(targetObject)) {
                DiagramModelNode childModelNode = null;
                EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
                int iChild = 0;
                while (iChild < newChildren.length) {
                    childModelNode = this.getModelNode(packageDiagramModelNode, newChildren[iChild]);
                    if (childModelNode == null && (childModelNode = this.getGenerator().createModel(newChildren[iChild], (Diagram)packageDiagramModelNode.getModelObject())) != null) {
                        childModelNode.setParent(packageDiagramModelNode);
                        childModelNode.setPosition(this.getStartingPoint());
                        packageDiagramModelNode.addChild(childModelNode);
                        performedChange = true;
                        if (!hasAssociations && childModelNode.getAssociations(this.getNodeMap(packageDiagramModelNode)) != null) {
                            hasAssociations = true;
                        }
                    }
                    ++iChild;
                }
                if (performedChange && hasAssociations) {
                    this.updateAssociations(packageDiagramModelNode, packageDiagramModelNode);
                }
            } else if (NotificationUtilities.addedChildrenParentIsNotifier((Notification)notification)) {
                EObject parentEObject;
                DiagramModelNode parentNode;
                EObject[] newChildren;
                boolean isNested = false;
                DiagramModelNode targetNode = this.getNodeInDiagram(packageDiagramModelNode, targetObject);
                if (targetNode == null && (targetNode = this.getModelNode(packageDiagramModelNode, targetObject)) != null) {
                    isNested = true;
                }
                if (targetNode != null && (newChildren = NotificationUtilities.getAddedChildren((Notification)notification)).length > 0) {
                    EObject childParent = newChildren[0].eContainer();
                    DiagramModelNode parentNode2 = this.getModelNode(packageDiagramModelNode, childParent);
                    if (parentNode2 != null) {
                        if (parentNode2 instanceof UmlClassifierNode) {
                            this.addReconcileClassifier(parentNode2);
                        } else {
                            int iChild = 0;
                            while (iChild < newChildren.length) {
                                DiagramModelNode newNode = this.getGenerator().createChildModel(parentNode2, newChildren[iChild]);
                                if (newNode != null) {
                                    performedChange = true;
                                }
                                ++iChild;
                            }
                        }
                    }
                    if (performedChange) {
                        this.updateAssociations(parentNode2, packageDiagramModelNode);
                    }
                }
                if (isNested && (parentNode = this.getModelNode(packageDiagramModelNode, parentEObject = targetObject.eContainer())) != null) {
                    parentNode.updateForChild(false);
                }
            } else {
                this.updateAssociations(packageDiagramModelNode, packageDiagramModelNode);
            }
        } else {
            Diagram diagram = (Diagram)packageDiagramModelNode.getModelObject();
            EObject diagramTargetEObject = diagram.getTarget();
            Resource diagramModelResource = null;
            boolean hasAssociations = false;
            if (diagramTargetEObject instanceof ModelAnnotation) {
                diagramModelResource = diagramTargetEObject.eResource();
            }
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
            if (diagramModelResource != null && changedObj != null && changedObj instanceof Resource) {
                Resource targetResource = (Resource)changedObj;
                if (targetResource.equals(diagramModelResource)) {
                    DiagramModelNode childModelNode = null;
                    EObject[] newChildren = NotificationUtilities.getAddedChildren((Notification)notification);
                    int iChild = 0;
                    while (iChild < newChildren.length) {
                        childModelNode = this.getModelNode(packageDiagramModelNode, newChildren[iChild]);
                        if (childModelNode == null && (childModelNode = this.getGenerator().createModel(newChildren[iChild], (Diagram)packageDiagramModelNode.getModelObject())) != null) {
                            childModelNode.setParent(packageDiagramModelNode);
                            childModelNode.setPosition(this.getStartingPoint());
                            packageDiagramModelNode.addChild(childModelNode);
                            performedChange = true;
                            if (childModelNode.getAssociations(this.getNodeMap(packageDiagramModelNode)) != null) {
                                hasAssociations = true;
                            }
                        }
                        ++iChild;
                    }
                }
                if (performedChange && hasAssociations) {
                    this.updateAssociations(packageDiagramModelNode, packageDiagramModelNode);
                }
            }
        }
    }

    private void performRemove(Notification notification, DiagramModelNode packageDiagramModelNode) {
        if (NotificationUtilities.isEObjectNotifier((Notification)notification)) {
            EObject targetObject = NotificationUtilities.getEObject((Notification)notification);
            DiagramModelNode parentNode = this.getModelNode(packageDiagramModelNode, targetObject);
            DiagramModelNode removedNode = null;
            EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
            int iChild = 0;
            while (iChild < removedChildren.length) {
                removedNode = this.getModelNode(packageDiagramModelNode, removedChildren[iChild]);
                if (removedNode != null) {
                    if (parentNode != null) {
                        if (!(parentNode instanceof UmlClassifierNode)) {
                            parentNode.removeChild(removedNode, false);
                        }
                    } else {
                        this.removeAllAssociationsFromNode(removedNode, packageDiagramModelNode);
                        packageDiagramModelNode.removeChild(removedNode, true);
                    }
                }
                ++iChild;
            }
            if (parentNode instanceof UmlClassifierNode) {
                this.addReconcileClassifier(parentNode);
            }
        } else {
            Resource targetResource;
            Diagram diagram = (Diagram)packageDiagramModelNode.getModelObject();
            EObject diagramTargetEObject = diagram.getTarget();
            Resource diagramModelResource = null;
            if (diagramTargetEObject instanceof ModelAnnotation) {
                diagramModelResource = diagramTargetEObject.eResource();
            }
            Object changedObj = ModelerCore.getModelEditor().getChangedObject(notification);
            if (diagramModelResource != null && changedObj != null && changedObj instanceof Resource && (targetResource = (Resource)changedObj).equals(diagramModelResource)) {
                DiagramModelNode removedNode = null;
                EObject[] removedChildren = NotificationUtilities.getRemovedChildren((Notification)notification);
                int iChild = 0;
                while (iChild < removedChildren.length) {
                    removedNode = this.getModelNode(packageDiagramModelNode, removedChildren[iChild]);
                    if (removedNode != null) {
                        this.removeAllAssociationsFromNode(removedNode, packageDiagramModelNode);
                        packageDiagramModelNode.removeChild(removedNode, true);
                    }
                    ++iChild;
                }
            }
        }
    }

    protected void performChange(Notification notification, DiagramModelNode packageDiagramModelNode) {
        EObject targetObject = NotificationUtilities.getEObject((Notification)notification);
        if (notification.getEventType() == 7) {
            DiagramModelNode targetNode = this.getModelNode(packageDiagramModelNode, targetObject);
            if (targetNode != null) {
                targetNode.updateForChild(true);
            }
        } else if (targetObject instanceof Diagram) {
            if (notification.getNewValue() instanceof DiagramLinkType) {
                String newValue = ((DiagramLinkType)notification.getNewValue()).getName();
                String oldValue = null;
                if (notification.getOldValue() instanceof DiagramLinkType) {
                    oldValue = ((DiagramLinkType)notification.getOldValue()).getName();
                }
                packageDiagramModelNode.update("router", oldValue, newValue);
            }
        } else {
            DiagramModelNode targetNode = this.getModelNode(packageDiagramModelNode, targetObject);
            if (targetNode != null) {
                DiagramModelNode topClassNode;
                this.getGenerator().performUpdate(targetNode, notification);
                if (this.getGenerator().isAssociation(targetObject)) {
                    DiagramModelNode topClassNode2 = DiagramUiUtilities.getTopClassifierParentNode(targetNode);
                    if (topClassNode2 != null) {
                        this.updateAssociations(topClassNode2, packageDiagramModelNode);
                    }
                    DiagramUiUtilities.hiliteCurrentSelectionDependencies();
                } else if ((notification.getEventType() == 4 || notification.getEventType() == 3) && (topClassNode = DiagramUiUtilities.getTopClassifierParentNode(targetNode)) != null) {
                    this.updateAssociations(topClassNode, packageDiagramModelNode);
                }
            }
        }
    }

    protected boolean associationExists(DiagramModelNode diagramModelNode, NodeConnectionModel targetAssociation) {
        List currentChildren = diagramModelNode.getChildren();
        for (DiagramModelNode childModelNode : currentChildren) {
            Vector sourceConnections = childModelNode.getSourceConnections();
            NodeConnectionModel nextAssociation2 = null;
            for (NodeConnectionModel nextAssociation2 : sourceConnections) {
                if (!this.associationsMatch(targetAssociation, nextAssociation2)) continue;
                return true;
            }
            Vector targetConnections = childModelNode.getTargetConnections();
            for (NodeConnectionModel nextAssociation2 : targetConnections) {
                if (!this.associationsMatch(targetAssociation, nextAssociation2)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean associationsMatch(NodeConnectionModel associationOne, NodeConnectionModel associationTwo) {
        if (associationOne.getSourceNode().equals(associationTwo.getSourceNode()) && associationOne.getTargetNode().equals(associationTwo.getTargetNode())) {
            return true;
        }
        return associationTwo.getSourceNode().equals(associationOne.getSourceNode()) && associationTwo.getTargetNode().equals(associationOne.getTargetNode());
    }

    protected List getStaleAssociations(List expectedAssociations, DiagramModelNode diagramModelNode) {
        List currentAssociations = this.getCurrentAssociations(diagramModelNode);
        if (currentAssociations.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return this.getStaleAssociations(expectedAssociations, currentAssociations);
    }

    protected List getStaleAssociations(List expectedAssociations, List currentAssociations) {
        ArrayList<NodeConnectionModel> staleAssociations = new ArrayList<NodeConnectionModel>();
        Iterator iter = currentAssociations.iterator();
        Iterator expectedIter = null;
        NodeConnectionModel nextCurrentAssociation = null;
        NodeConnectionModel nextExpectedAssociation = null;
        boolean foundMatch = false;
        while (iter.hasNext()) {
            foundMatch = false;
            nextCurrentAssociation = (NodeConnectionModel)iter.next();
            expectedIter = expectedAssociations.iterator();
            while (expectedIter.hasNext() && !foundMatch) {
                nextExpectedAssociation = (NodeConnectionModel)expectedIter.next();
                if (!this.associationsMatch(nextExpectedAssociation, nextCurrentAssociation)) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            staleAssociations.add(nextCurrentAssociation);
        }
        return staleAssociations;
    }

    protected List getCurrentAssociations(DiagramModelNode diagramModelNode) {
        ArrayList<NodeConnectionModel> currentAssociations = new ArrayList<NodeConnectionModel>();
        for (DiagramModelNode childModelNode : diagramModelNode.getChildren()) {
            Vector sourceConnections = childModelNode.getSourceConnections();
            NodeConnectionModel nextAssociation2 = null;
            for (NodeConnectionModel nextAssociation2 : sourceConnections) {
                if (currentAssociations.contains(nextAssociation2)) continue;
                currentAssociations.add(nextAssociation2);
            }
            Vector targetConnections = childModelNode.getTargetConnections();
            for (NodeConnectionModel nextAssociation2 : targetConnections) {
                if (currentAssociations.contains(nextAssociation2)) continue;
                currentAssociations.add(nextAssociation2);
            }
        }
        return currentAssociations;
    }

    protected List cleanUpStaleAssociations(List staleAssociations, DiagramModelNode diagramModelNode) {
        HashMap<Object, String> updatedNodes = new HashMap<Object, String>();
        Iterator iter = staleAssociations.iterator();
        NodeConnectionModel nextAssociation = null;
        while (iter.hasNext()) {
            List labelNodes;
            nextAssociation = (NodeConnectionModel)iter.next();
            ((DiagramModelNode)nextAssociation.getSourceNode()).removeSourceConnection(nextAssociation);
            ((DiagramModelNode)nextAssociation.getTargetNode()).removeTargetConnection(nextAssociation);
            if (updatedNodes.get(nextAssociation.getSourceNode()) == null) {
                updatedNodes.put(nextAssociation.getSourceNode(), "x");
            }
            if (updatedNodes.get(nextAssociation.getTargetNode()) == null) {
                updatedNodes.put(nextAssociation.getTargetNode(), "x");
            }
            if ((labelNodes = nextAssociation.getLabelNodes()) == null || labelNodes.isEmpty()) continue;
            Iterator labelIter = labelNodes.iterator();
            LabelModelNode nextNode = null;
            while (labelIter.hasNext()) {
                nextNode = (LabelModelNode)labelIter.next();
                diagramModelNode.removeChild(nextNode, false);
            }
        }
        return new ArrayList(updatedNodes.keySet());
    }

    protected void removeAllAssociationsFromNode(DiagramModelNode diagramModelNode, DiagramModelNode diagramNode) {
        ArrayList sourceConnections = new ArrayList(diagramModelNode.getSourceConnections());
        Iterator iter = sourceConnections.iterator();
        NodeConnectionModel nextAssociation = null;
        DiagramModelNode otherNode = null;
        while (iter.hasNext()) {
            nextAssociation = (NodeConnectionModel)iter.next();
            otherNode = (DiagramModelNode)nextAssociation.getTargetNode();
            diagramModelNode.removeSourceConnection(nextAssociation);
            otherNode.removeTargetConnection(nextAssociation);
            diagramModelNode.updateAssociations();
            otherNode.updateAssociations();
            List labelNodes = nextAssociation.getLabelNodes();
            if (labelNodes == null || labelNodes.isEmpty()) continue;
            Iterator labelIter = labelNodes.iterator();
            LabelModelNode nextNode = null;
            while (labelIter.hasNext()) {
                nextNode = (LabelModelNode)labelIter.next();
                diagramNode.removeChild(nextNode, false);
            }
        }
        ArrayList targetConnections = new ArrayList(diagramModelNode.getTargetConnections());
        iter = targetConnections.iterator();
        nextAssociation = null;
        while (iter.hasNext()) {
            nextAssociation = (NodeConnectionModel)iter.next();
            otherNode = (DiagramModelNode)nextAssociation.getSourceNode();
            diagramModelNode.removeTargetConnection(nextAssociation);
            otherNode.removeSourceConnection(nextAssociation);
            diagramModelNode.updateAssociations();
            otherNode.updateAssociations();
            List labelNodes = nextAssociation.getLabelNodes();
            if (labelNodes == null || labelNodes.isEmpty()) continue;
            Iterator labelIter = labelNodes.iterator();
            LabelModelNode nextNode = null;
            while (labelIter.hasNext()) {
                nextNode = (LabelModelNode)labelIter.next();
                diagramNode.removeChild(nextNode, false);
            }
        }
    }

    protected void updateAssociations(DiagramModelNode diagramModelNode, DiagramModelNode diagramNode) {
        HashMap nodeMap = this.getNodeMap(diagramNode);
        String currentRouterStyle = DiagramLinkType.get((int)DiagramEditorUtil.getCurrentDiagramRouterStyle()).getName();
        if (diagramModelNode instanceof PackageDiagramNode) {
            NodeConnectionModel nextAssociation2 = null;
            ArrayList realAssociations = new ArrayList();
            List currentChildren = diagramModelNode.getChildren();
            for (DiagramModelNode childModelNode : currentChildren) {
                List allAssociations;
                if (childModelNode == null || (allAssociations = childModelNode.getAssociations(nodeMap)) == null || allAssociations.isEmpty()) continue;
                Iterator subIter = allAssociations.iterator();
                Object nextAss = null;
                while (subIter.hasNext()) {
                    nextAss = subIter.next();
                    if (realAssociations.contains(nextAss)) continue;
                    realAssociations.add(nextAss);
                }
            }
            List staleAssociations = this.getStaleAssociations(realAssociations, diagramModelNode);
            ArrayList changedNodes = new ArrayList(this.cleanUpStaleAssociations(staleAssociations, diagramModelNode));
            HashMap<Object, String> updatedNodes = new HashMap<Object, String>();
            Iterator<Object> iter = changedNodes.iterator();
            while (iter.hasNext()) {
                updatedNodes.put(iter.next(), "x");
            }
            for (NodeConnectionModel nextAssociation2 : realAssociations) {
                List labelNodes;
                if (this.associationExists(diagramModelNode, nextAssociation2)) continue;
                if (nextAssociation2.getDiagramLink() == null) {
                    nextAssociation2.setRouterStyle(currentRouterStyle);
                }
                ((DiagramModelNode)nextAssociation2.getSourceNode()).addSourceConnection(nextAssociation2);
                ((DiagramModelNode)nextAssociation2.getTargetNode()).addTargetConnection(nextAssociation2);
                if (updatedNodes.get(nextAssociation2.getSourceNode()) == null) {
                    updatedNodes.put(nextAssociation2.getSourceNode(), "x");
                }
                if (updatedNodes.get(nextAssociation2.getTargetNode()) == null) {
                    updatedNodes.put(nextAssociation2.getTargetNode(), "x");
                }
                if ((labelNodes = nextAssociation2.getLabelNodes()) == null || labelNodes.isEmpty()) continue;
                Iterator labelIter = labelNodes.iterator();
                LabelModelNode nextNode = null;
                while (labelIter.hasNext()) {
                    nextNode = (LabelModelNode)labelIter.next();
                    diagramModelNode.addChild(nextNode);
                }
            }
            for (NodeConnectionModel nextAssociation2 : this.getCurrentAssociations(diagramModelNode)) {
                nextAssociation2.updateLabels();
                ((DiagramModelNode)nextAssociation2.getSourceNode()).updateAssociations();
                ((DiagramModelNode)nextAssociation2.getTargetNode()).updateAssociations();
            }
            if (!updatedNodes.isEmpty()) {
                iter = updatedNodes.keySet().iterator();
                DiagramModelNode nextNode = null;
                while (iter.hasNext()) {
                    nextNode = (DiagramModelNode)iter.next();
                    nextNode.updateAssociations();
                }
            }
        } else if (diagramModelNode instanceof UmlClassifierNode) {
            NodeConnectionModel nextAssociation3 = null;
            ArrayList realAssociations = new ArrayList();
            List allAssociations = diagramModelNode.getAssociations(nodeMap);
            if (allAssociations != null && !allAssociations.isEmpty()) {
                Iterator subIter = allAssociations.iterator();
                Object nextAss = null;
                while (subIter.hasNext()) {
                    nextAss = subIter.next();
                    if (realAssociations.contains(nextAss)) continue;
                    realAssociations.add(nextAss);
                }
            }
            ArrayList<NodeConnectionModel> currentAssociations = new ArrayList<NodeConnectionModel>();
            Vector sourceConnections = diagramModelNode.getSourceConnections();
            for (NodeConnectionModel nextAssociation3 : sourceConnections) {
                if (currentAssociations.contains(nextAssociation3)) continue;
                currentAssociations.add(nextAssociation3);
            }
            Vector targetConnections = diagramModelNode.getTargetConnections();
            for (NodeConnectionModel nextAssociation3 : targetConnections) {
                if (currentAssociations.contains(nextAssociation3)) continue;
                currentAssociations.add(nextAssociation3);
            }
            List staleAssociations = this.getStaleAssociations(realAssociations, currentAssociations);
            ArrayList changedNodes = new ArrayList(this.cleanUpStaleAssociations(staleAssociations, diagramNode));
            HashMap<Object, String> updatedNodes = new HashMap<Object, String>();
            updatedNodes.put(diagramModelNode, "x");
            Iterator iter = changedNodes.iterator();
            while (iter.hasNext()) {
                updatedNodes.put(iter.next(), "x");
            }
            this.updateNodeAssociations(updatedNodes.keySet());
            updatedNodes = new HashMap();
            updatedNodes.put(diagramModelNode, "x");
            for (NodeConnectionModel nextAssociation3 : realAssociations) {
                List labelNodes;
                if (nextAssociation3.getDiagramLink() == null) {
                    nextAssociation3.setRouterStyle(currentRouterStyle);
                }
                if (this.associationExists(diagramNode, nextAssociation3)) continue;
                ((DiagramModelNode)nextAssociation3.getSourceNode()).addSourceConnection(nextAssociation3);
                ((DiagramModelNode)nextAssociation3.getTargetNode()).addTargetConnection(nextAssociation3);
                if (updatedNodes.get(nextAssociation3.getSourceNode()) == null) {
                    updatedNodes.put(nextAssociation3.getSourceNode(), "x");
                }
                if (updatedNodes.get(nextAssociation3.getTargetNode()) == null) {
                    updatedNodes.put(nextAssociation3.getTargetNode(), "x");
                }
                if ((labelNodes = nextAssociation3.getLabelNodes()) == null || labelNodes.isEmpty()) continue;
                Iterator labelIter = labelNodes.iterator();
                LabelModelNode nextNode = null;
                while (labelIter.hasNext()) {
                    nextNode = (LabelModelNode)labelIter.next();
                    diagramNode.addChild(nextNode);
                }
            }
            for (NodeConnectionModel nextAssociation3 : this.getCurrentAssociations(diagramNode)) {
                nextAssociation3.updateLabels();
            }
            this.updateNodeAssociations(updatedNodes.keySet());
        }
    }

    protected void updateNodeAssociations(Set diagramModelNodes) {
        if (!diagramModelNodes.isEmpty()) {
            Iterator iter = diagramModelNodes.iterator();
            DiagramModelNode nextNode = null;
            while (iter.hasNext()) {
                nextNode = (DiagramModelNode)iter.next();
                nextNode.updateAssociations();
                nextNode.update("bendpoint");
            }
        }
    }

    public String toString() {
        return "PackageDiagamModelFactory()";
    }

    private Point getStartingPoint() {
        Point thisPoint = new Point(startingPoint);
        if (PackageDiagramModelFactory.startingPoint.x < 600) {
            PackageDiagramModelFactory.startingPoint.x += 20;
            PackageDiagramModelFactory.startingPoint.y += 10;
        } else {
            PackageDiagramModelFactory.startingPoint.x = 20;
            PackageDiagramModelFactory.startingPoint.y = yInc += 20;
        }
        return thisPoint;
    }

    @Override
    public boolean isDrawable(EObject eObject) {
        boolean result = true;
        if (eObject instanceof JdbcSource) {
            result = false;
        }
        return result;
    }

    protected HashMap getNodeMap(DiagramModelNode diagramNode) {
        HashMap<EObject, DiagramModelNode> nodeMap = new HashMap<EObject, DiagramModelNode>();
        Iterator iter = diagramNode.getChildren().iterator();
        DiagramModelNode dmn = null;
        while (iter.hasNext()) {
            dmn = (DiagramModelNode)iter.next();
            if (dmn.getModelObject() == null) continue;
            nodeMap.put(dmn.getModelObject(), dmn);
        }
        return nodeMap;
    }

    public String getSNotationId() {
        return this.sNotationId;
    }

    public void setSNotationId(String string) {
        this.sNotationId = string;
    }

    private void addReconcileClassifier(DiagramModelNode classifierNode) {
        if (this.reconcileClassifierNodes == null) {
            this.reconcileClassifierNodes = new HashMap();
        }
        if (this.reconcileClassifierNodes.get(classifierNode) == null) {
            this.reconcileClassifierNodes.put(classifierNode, "x");
        }
    }

    private void reconcileClassifiers(DiagramModelNode packageDiagramNode) {
        if (this.reconcileClassifierNodes != null && !this.reconcileClassifierNodes.isEmpty()) {
            UmlClassifierNode nextNode2 = null;
            for (UmlClassifierNode nextNode2 : this.reconcileClassifierNodes.keySet()) {
                nextNode2.reconcile();
                DiagramModelNode dNode2 = null;
                for (DiagramModelNode dNode2 : nextNode2.getChildren()) {
                    dNode2.update("children");
                    dNode2.update("layout");
                }
                nextNode2.update("children");
                nextNode2.update("layout");
                this.updateAssociations(nextNode2, packageDiagramNode);
            }
        }
        this.reconcileClassifierNodes = null;
    }

    @Override
    public boolean shouldRefreshDiagram(Notification notification, DiagramModelNode diagramModelNode, String sDiagramTypeId) {
        String mrName;
        DefaultIgnorableNotificationSource isrc;
        SourcedNotification sNot;
        return notification instanceof SourcedNotification && (sNot = (SourcedNotification)notification).getSource() instanceof DefaultIgnorableNotificationSource && (isrc = (DefaultIgnorableNotificationSource)sNot.getSource()).getActualSource().getClass().getName().indexOf("JdbcImportWizard") > -1 && isrc.getSourceIdentifier() != null && (mrName = ModelUtilities.getModelResource((Object)diagramModelNode.getModelObject()).getItemName()).equalsIgnoreCase(isrc.getSourceIdentifier());
    }
}

