/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.pakkage;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.aspect.MetamodelAspect;
import org.teiid.designer.core.metamodel.aspect.uml.UmlPackage;
import org.teiid.designer.core.workspace.ModelDiagrams;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.pakkage.IPackageDiagramProvider;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramUtil;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PackageDiagramProvider
implements IPackageDiagramProvider {
    private Diagram createPackageDiagram(EObject target, ModelResource modelResource, boolean forceCreate) {
        if (forceCreate) {
            Diagram pDiagram = null;
            boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Creating Package Diagram", (Object)this);
            boolean succeeded = false;
            try {
                pDiagram = PackageDiagramUtil.createPackageDiagram(target, modelResource);
                succeeded = true;
            }
            finally {
                if (started) {
                    if (succeeded) {
                        ModelerCore.commitTxn();
                    } else {
                        ModelerCore.rollbackTxn();
                    }
                }
            }
            return pDiagram;
        }
        if (target == null) {
            try {
                target = modelResource.getModelAnnotation();
            }
            catch (ModelWorkspaceException err) {
                DiagramUiConstants.Util.log((Throwable)err);
            }
        }
        return new DiagramProxy(target, "packageDiagramType", modelResource);
    }

    @Override
    public Diagram getPackageDiagram(ModelResource modelResource, EObject eObject, boolean forceCreate) {
        ModelDiagrams modelDiagrams = null;
        Diagram packageDiagram = null;
        if (modelResource != null && ModelUtilities.supportsDiagrams((ModelResource)modelResource)) {
            block9: {
                try {
                    ArrayList diagramList;
                    modelDiagrams = modelResource.getModelDiagrams();
                    if (modelDiagrams != null && eObject != null) {
                        ArrayList diagramList2 = new ArrayList(modelDiagrams.getDiagrams(eObject));
                        Iterator iter = diagramList2.iterator();
                        Diagram nextDiagram = null;
                        while (iter.hasNext() && packageDiagram == null) {
                            nextDiagram = (Diagram)iter.next();
                            if (nextDiagram.getType() == null || !nextDiagram.getType().equals("packageDiagramType")) continue;
                            packageDiagram = nextDiagram;
                        }
                    } else if (modelDiagrams != null && !(diagramList = new ArrayList(modelDiagrams.getDiagrams(null))).isEmpty()) {
                        Iterator iter = diagramList.iterator();
                        Diagram nextDiagram = null;
                        while (iter.hasNext() && packageDiagram == null) {
                            nextDiagram = (Diagram)iter.next();
                            if (nextDiagram.getType() == null || !nextDiagram.getType().equals("packageDiagramType")) continue;
                            packageDiagram = nextDiagram;
                        }
                    }
                }
                catch (ModelWorkspaceException e) {
                    if (modelResource.hasErrors()) break block9;
                    String message = DiagramUiConstants.Util.getString("PackageDiagramContentProvider.getPackageDiagramError", (Object)modelResource.toString());
                    DiagramUiConstants.Util.log(4, (Throwable)e, message);
                }
            }
            if (packageDiagram == null) {
                packageDiagram = this.createPackageDiagram(eObject, modelResource, forceCreate);
            }
        }
        return packageDiagram;
    }

    @Override
    public Diagram getPackageDiagram(Object targetObject, boolean forceCreate) {
        Diagram diagram = null;
        if (targetObject instanceof EObject) {
            EObject eObject = (EObject)targetObject;
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)eObject);
            if (eObject.eContainer() != null) {
                EObject packageEObject;
                if (eObject.eContainer() != null && (packageEObject = this.getPackage(eObject)) != null && modelResource != null) {
                    diagram = this.getPackageDiagram(modelResource, packageEObject, forceCreate);
                }
            } else if (DiagramUiUtilities.isStandardUmlPackage(targetObject)) {
                diagram = this.getPackageDiagram(modelResource, eObject, forceCreate);
            }
        }
        return diagram;
    }

    private EObject getPackage(EObject eObject) {
        EObject packageEObject = null;
        EObject parentObject = eObject.eContainer();
        if (parentObject instanceof EObject) {
            MetamodelAspect aspect = DiagramUiPlugin.getDiagramAspectManager().getUmlAspect(parentObject);
            packageEObject = aspect != null && aspect instanceof UmlPackage ? parentObject : this.getPackage(parentObject);
        }
        return packageEObject;
    }
}

