/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.pakkage;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.diagram.ui.AbstractDiagramType;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.editor.IDiagramActionAdapter;
import org.teiid.designer.diagram.ui.figure.DiagramFigureFactory;
import org.teiid.designer.diagram.ui.model.DiagramModelFactory;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramFigureFactory;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramModelFactory;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramPartFactory;
import org.teiid.designer.diagram.ui.pakkage.PackageDiagramProvider;
import org.teiid.designer.diagram.ui.pakkage.actions.PackageDiagramActionAdapter;
import org.teiid.designer.diagram.ui.part.DiagramEditPartFactory;
import org.teiid.designer.diagram.ui.preferences.DiagramColorObject;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.diagram.ui.util.dialog.LargeDiagramDialog;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.util.DiagramProxy;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class PackageDiagramType
extends AbstractDiagramType {
    private static DiagramEditPartFactory editPartFactory;
    private static DiagramModelFactory modelFactory;
    private static DiagramFigureFactory figureFactory;
    private static DiagramColorObject bkgdColorObject;
    private static PackageDiagramProvider diagramProvider;
    private static final int N_LARGE_VALUE = 300;
    private static final String LARGE_DIAGRAM_DIALOG_TITLE;

    static {
        LARGE_DIAGRAM_DIALOG_TITLE = DiagramUiConstants.Util.getString("PackageDiagramType.largeDiagramDialogTitle", new Object[0]);
    }

    @Override
    public DiagramEditPartFactory getEditPartFactory() {
        if (editPartFactory == null) {
            editPartFactory = new PackageDiagramPartFactory();
        }
        return editPartFactory;
    }

    @Override
    public DiagramFigureFactory getFigureFactory() {
        if (figureFactory == null) {
            figureFactory = new PackageDiagramFigureFactory();
        }
        return figureFactory;
    }

    @Override
    public DiagramModelFactory getModelFactory() {
        if (modelFactory == null) {
            modelFactory = new PackageDiagramModelFactory();
        }
        return modelFactory;
    }

    @Override
    public IDiagramActionAdapter getActionAdapter(ModelEditorPage editor) {
        return new PackageDiagramActionAdapter(editor);
    }

    @Override
    public String getDisplayName() {
        return DiagramUiConstants.Util.getString("DiagramNames.packageDiagram", new Object[0]);
    }

    @Override
    public boolean canOpenContext(Object input) {
        boolean canOpen = false;
        if (input instanceof EObject) {
            EObject eObj = (EObject)input;
            boolean eObjectIsStale = ModelObjectUtilities.isStale((EObject)eObj);
            if (eObj instanceof Diagram && ((Diagram)eObj).getType() != null && ((Diagram)eObj).getType().equals("packageDiagramType")) {
                EObject targetEObj = ((Diagram)eObj).getTarget();
                if (targetEObj != null && !ModelObjectUtilities.isStale((EObject)targetEObj)) {
                    canOpen = true;
                } else if (targetEObj == null) {
                    return true;
                }
            } else if (!eObjectIsStale) {
                if (DiagramUiUtilities.isStandardUmlPackage(input)) {
                    canOpen = true;
                } else if (DiagramUiUtilities.isModelResourceChild(input)) {
                    canOpen = true;
                } else if (DiagramUiUtilities.hasParentPackage(input)) {
                    canOpen = true;
                } else {
                    EObject topClassifier = DiagramUiUtilities.getParentClassifier((EObject)input);
                    if (topClassifier != null && DiagramUiUtilities.isModelResourceChild(topClassifier)) {
                        canOpen = true;
                    }
                }
            }
        } else if (input instanceof ModelResource && ((ModelResource)input).exists()) {
            canOpen = true;
        }
        return canOpen;
    }

    @Override
    public Diagram getDiagramForContext(Object actualInput) {
        ModelResource mr;
        Diagram packageDiagram = null;
        Object input = actualInput;
        if (input instanceof DiagramProxy && (input = ((DiagramProxy)actualInput).getTarget()) == null) {
            input = ((DiagramProxy)actualInput).getModelResource();
        }
        if (input instanceof Diagram && ((Diagram)input).getType() != null && ((Diagram)input).getType().equals("packageDiagramType")) {
            packageDiagram = (Diagram)input;
        } else if (input instanceof ModelResource) {
            packageDiagram = this.getDiagramProvider().getPackageDiagram((ModelResource)input, null, true);
        } else if (DiagramUiUtilities.isStandardUmlPackage(input)) {
            mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)input));
            packageDiagram = this.getDiagramProvider().getPackageDiagram(mr, (EObject)input, true);
        } else if (input instanceof ModelResource) {
            packageDiagram = this.getDiagramProvider().getPackageDiagram((ModelResource)input, null, true);
        } else if (DiagramUiUtilities.isModelResourceChild(input)) {
            mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)input));
            packageDiagram = this.getDiagramProvider().getPackageDiagram(mr, null, true);
        } else if (DiagramUiUtilities.hasParentPackage(input)) {
            EObject thePackage = DiagramUiUtilities.getParentPackage(input);
            if (thePackage != null) {
                packageDiagram = this.getDiagramProvider().getPackageDiagram(input, true);
            }
        } else {
            EObject topClassifier = DiagramUiUtilities.getParentClassifier((EObject)input);
            if (topClassifier != null && DiagramUiUtilities.isModelResourceChild(topClassifier)) {
                ModelResource mr2 = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)input));
                packageDiagram = this.getDiagramProvider().getPackageDiagram(mr2, null, true);
            }
        }
        if (packageDiagram == null) {
            mr = null;
            if (input instanceof ModelResource) {
                mr = (ModelResource)input;
            } else if (input instanceof EObject) {
                mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)input));
            }
            if (mr != null) {
                packageDiagram = this.getDiagramProvider().getPackageDiagram(mr, null, true);
            }
        }
        return packageDiagram;
    }

    @Override
    public DiagramColorObject getBackgroundColorObject(String extensionID) {
        if (bkgdColorObject == null) {
            bkgdColorObject = new DiagramColorObject(this.getDisplayName(), "modeler.preference.diagram.package.backgroundcolor");
        }
        return bkgdColorObject;
    }

    @Override
    public Diagram getDiagramForGoToMarkerEObject(EObject eObject) {
        return this.getDiagramForContext(eObject);
    }

    @Override
    public String getDisplayedPath(Diagram diagram, EObject eObject) {
        return null;
    }

    @Override
    public EObject getInitialSelection(Object object) {
        if (object instanceof Diagram) {
            return ((Diagram)object).getTarget();
        }
        if (object instanceof ModelResource) {
            ModelAnnotation modelAnnotation = null;
            try {
                modelAnnotation = ((ModelResource)object).getModelAnnotation();
            }
            catch (ModelWorkspaceException theException) {
                String message = DiagramUiConstants.Util.getString("ModelErrors.getIResourceerror", (Object)((ModelResource)object).getItemName());
                DiagramUiConstants.Util.log(4, (Throwable)theException, message);
            }
            return modelAnnotation;
        }
        return null;
    }

    private PackageDiagramProvider getDiagramProvider() {
        if (diagramProvider == null) {
            diagramProvider = new PackageDiagramProvider();
        }
        return diagramProvider;
    }

    @Override
    public boolean isDiagramLarge(Diagram diagram) {
        return this.getDiagramObjectCount(diagram) > 300;
    }

    @Override
    public boolean isDiagramTooLarge(Diagram diagram) {
        boolean tooLarge;
        int maxLimit = DiagramUiPlugin.getDefault().getPreferenceStore().getInt("largeModelSize");
        int nObjects = this.getDiagramObjectCount(diagram);
        boolean bl = tooLarge = nObjects > maxLimit;
        if (tooLarge) {
            Shell shell = DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            LargeDiagramDialog largeDiagramDialog = new LargeDiagramDialog(shell, LARGE_DIAGRAM_DIALOG_TITLE, nObjects, maxLimit);
            largeDiagramDialog.open();
        }
        return tooLarge;
    }

    private int getDiagramObjectCount(Diagram diagram) {
        int nObjects = 0;
        EObject targetObject = diagram.getTarget();
        List contents = null;
        if (targetObject != null && targetObject instanceof EObject && !(targetObject instanceof ModelAnnotation)) {
            contents = diagram.getTarget().eContents();
        } else if (targetObject != null && targetObject instanceof EObject && targetObject instanceof ModelAnnotation) {
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)diagram);
            if (modelResource != null) {
                try {
                    contents = modelResource.getEObjects();
                }
                catch (ModelWorkspaceException e) {
                    contents = Collections.EMPTY_LIST;
                    String message = DiagramUiConstants.Util.getString("ModelErrors.getContentError", (Object)modelResource.getItemName());
                    DiagramUiConstants.Util.log(4, (Throwable)e, message);
                }
            } else {
                contents = Collections.EMPTY_LIST;
            }
        } else {
            contents = Collections.EMPTY_LIST;
        }
        nObjects = contents.size();
        if (nObjects > 1) {
            EObject nextEObject2 = null;
            for (EObject nextEObject2 : contents) {
                if (nextEObject2.eContents() == null || nextEObject2.eContents().isEmpty()) continue;
                nObjects += nextEObject2.eContents().size();
            }
        }
        return nObjects;
    }

    @Override
    public Object getDiagramSelectionStandin(Diagram diagram) {
        EObject target = diagram.getTarget();
        if (target instanceof ModelAnnotation) {
            ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)diagram);
            IResource ir = null;
            if (mr != null) {
                try {
                    ir = mr.getCorrespondingResource();
                }
                catch (ModelWorkspaceException err) {
                    String message = DiagramUiConstants.Util.getString("ModelErrors.getIResourceerror", (Object)mr.getItemName());
                    DiagramUiConstants.Util.log(4, (Throwable)err, message);
                }
            }
            return ir;
        }
        return target;
    }
}

