/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.pakkage.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.teiid.designer.diagram.ui.actions.DiagramGlobalActionsMap;
import org.teiid.designer.diagram.ui.actions.LockDiagramAction;
import org.teiid.designer.diagram.ui.actions.RefreshAction;
import org.teiid.designer.diagram.ui.actions.RouterTypeMenuManager;
import org.teiid.designer.diagram.ui.actions.SaveDiagramAction;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.editor.DiagramActionAdapter;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.part.UmlClassifierEditPart;
import org.teiid.designer.diagram.ui.pakkage.actions.IPackageDiagramActionConstants;
import org.teiid.designer.diagram.ui.pakkage.actions.RenameAction;
import org.teiid.designer.diagram.ui.pakkage.actions.ShowParentDiagramAction;
import org.teiid.designer.diagram.ui.util.RelationalUmlEObjectHelper;
import org.teiid.designer.ui.actions.IModelerActionConstants;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.actions.GlobalActionsMap;
import org.teiid.designer.ui.common.actions.IActionConstants;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorPage;

public class PackageDiagramActionAdapter
extends DiagramActionAdapter
implements IPackageDiagramActionConstants,
IModelerActionConstants {
    private static final String D_MARKER = "diagramStart";
    private RefreshAction refreshDiagramAction;
    private ShowParentDiagramAction upPackageDiagramAction;
    private MenuManager linkTypeManager;
    private RenameAction renameAction;
    private AbstractAction saveDiagramAction;
    private LockDiagramAction lockDiagramAction;
    private GlobalActionsMap actionsMap;

    public PackageDiagramActionAdapter(ModelEditorPage page) {
        super(page);
    }

    private boolean singleLinkSelected() {
        Object selectedEP;
        List selectedEPs = this.getSelectedInDiagram();
        return !selectedEPs.isEmpty() && selectedEPs.size() == 1 && (selectedEP = selectedEPs.get(0)) instanceof NodeConnectionEditPart;
    }

    private boolean diagramSelected() {
        EObject eObj;
        ISelectionProvider selProvider = this.getEditorPage().getModelObjectSelectionProvider();
        ISelection selection = selProvider.getSelection();
        return SelectionUtilities.isSingleSelection((ISelection)selection) && (eObj = SelectionUtilities.getSelectedEObject((ISelection)selection)) != null && RelationalUmlEObjectHelper.getEObjectType(eObj) == 0 && this.getDiagramEditor() != null && this.getDiagramEditor().getDiagramViewer().getSelectedEditParts().isEmpty();
    }

    private boolean doRemoveOpen() {
        Object selectedEP;
        List selectedEPs = this.getSelectedInDiagram();
        return !selectedEPs.isEmpty() && selectedEPs.size() == 1 && (selectedEP = selectedEPs.get(0)) instanceof UmlClassifierEditPart;
    }

    private IAction getAction(String theActionId) {
        IAction action = null;
        try {
            action = this.getActionService().getAction(theActionId);
        }
        catch (CoreException coreException) {}
        return action;
    }

    @Override
    public GlobalActionsMap getGlobalActions() {
        if (this.actionsMap == null) {
            this.actionsMap = new DiagramGlobalActionsMap();
            this.actionsMap.reset();
            this.renameAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
            this.actionsMap.put((Object)IActionConstants.EclipseGlobalActions.RENAME, (Object)this.renameAction);
        }
        this.updateLinkTypeMenu();
        return this.actionsMap;
    }

    private void updateLinkTypeMenu() {
        DiagramModelNode currentModel = this.getDiagramEditor().getCurrentModel();
        if (currentModel != null) {
            boolean readOnly = currentModel.isReadOnly();
            ((RouterTypeMenuManager)this.linkTypeManager).setEnabled(!readOnly);
        }
    }

    @Override
    protected void initActions() {
        super.initActions();
        this.refreshDiagramAction = (RefreshAction)this.getRegisteredAction(RefreshAction.class.getName());
        if (this.refreshDiagramAction == null) {
            this.refreshDiagramAction = new RefreshAction();
            this.registerAction(this.refreshDiagramAction);
        }
        this.upPackageDiagramAction = (ShowParentDiagramAction)this.getRegisteredAction(ShowParentDiagramAction.class.getName());
        if (this.upPackageDiagramAction == null) {
            this.upPackageDiagramAction = new ShowParentDiagramAction();
            this.registerAction(this.upPackageDiagramAction);
        }
        this.linkTypeManager = new RouterTypeMenuManager();
        this.saveDiagramAction = (AbstractAction)this.getRegisteredAction(SaveDiagramAction.class.getName());
        if (this.saveDiagramAction == null) {
            this.saveDiagramAction = new SaveDiagramAction((DiagramEditor)this.getEditorPage());
            this.registerAction(this.saveDiagramAction);
        }
        this.renameAction = (RenameAction)this.getRegisteredAction(RenameAction.class.getName());
        if (this.renameAction == null) {
            this.renameAction = new RenameAction();
            this.registerAction((AbstractAction)this.renameAction);
        }
        this.lockDiagramAction = new LockDiagramAction((DiagramEditor)this.getEditorPage());
        this.registerAction((AbstractAction)this.lockDiagramAction);
    }

    @Override
    public void createContextMenu() {
        this.createContextMenu("diagramEditorPage.contextMenu", this.getEditorPage().getControl());
    }

    private void clearAllActions(IMenuManager theMenuMgr) {
        IContributionItem[] allContributions = theMenuMgr.getItems();
        ArrayList<IContributionItem> removeItems = new ArrayList<IContributionItem>(allContributions.length);
        int i = 0;
        while (i < allContributions.length) {
            IContributionItem nextItem = allContributions[i];
            if (!(nextItem instanceof GroupMarker) && !(nextItem instanceof Separator)) {
                removeItems.add(nextItem);
            }
            ++i;
        }
        Iterator iter = removeItems.iterator();
        while (iter.hasNext()) {
            theMenuMgr.remove((IContributionItem)iter.next());
        }
    }

    @Override
    public void contributeToMenuManager(IMenuManager theMenuMgr, ISelection selection) {
        this.removeDiagramActions(theMenuMgr);
        if (this.diagramSelected()) {
            this.addDiagramActions(theMenuMgr);
        } else if (this.singleLinkSelected()) {
            this.clearAllActions(theMenuMgr);
            ((RouterTypeMenuManager)this.linkTypeManager).setSingleLinkEdit(true);
            ((RouterTypeMenuManager)this.linkTypeManager).setInitialSelection();
            this.addDiagramActions(theMenuMgr);
        } else {
            IAction openAction;
            this.addDiagramActions(theMenuMgr);
            if (this.doRemoveOpen() && (openAction = this.getAction(IModelerActionConstants.ModelerGlobalActions.OPEN)) != null && theMenuMgr.find(openAction.getId()) != null) {
                theMenuMgr.remove(openAction.getId());
            }
        }
    }

    private void addDiagramActions(IMenuManager theMenuMgr) {
        theMenuMgr.add((IContributionItem)new Separator());
        theMenuMgr.add((IContributionItem)new GroupMarker(D_MARKER));
        theMenuMgr.appendToGroup(D_MARKER, (IContributionItem)this.linkTypeManager);
        ((RouterTypeMenuManager)this.linkTypeManager).setInitialSelection();
        theMenuMgr.appendToGroup(D_MARKER, (IAction)this.refreshDiagramAction);
        theMenuMgr.appendToGroup(D_MARKER, (IAction)this.upPackageDiagramAction);
        theMenuMgr.appendToGroup(D_MARKER, (IAction)this.saveDiagramAction);
        theMenuMgr.add((IContributionItem)new Separator());
    }

    private void removeDiagramActions(IMenuManager theMenuMgr) {
        if (theMenuMgr.find(D_MARKER) != null) {
            theMenuMgr.remove(D_MARKER);
        }
        if (theMenuMgr.find(this.refreshDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.refreshDiagramAction.getId());
        }
        if (theMenuMgr.find(this.upPackageDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.upPackageDiagramAction.getId());
        }
        if (theMenuMgr.find(this.linkTypeManager.getId()) != null) {
            theMenuMgr.remove(this.linkTypeManager.getId());
        }
        if (theMenuMgr.find(this.saveDiagramAction.getId()) != null) {
            theMenuMgr.remove(this.saveDiagramAction.getId());
        }
    }

    @Override
    public void contributeExportedActions(IMenuManager theMenuMgr) {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.linkTypeManager = null;
    }

    @Override
    public void contributeToDiagramToolBar() {
        ToolBarManager tbm = ((DiagramEditor)this.getEditorPage()).getToolBarManager();
        if (tbm != null) {
            tbm.removeAll();
            tbm.add((IAction)this.refreshDiagramAction);
            tbm.add((IAction)this.upPackageDiagramAction);
            tbm.add((IAction)this.lockDiagramAction);
            tbm.add((IContributionItem)new Separator());
            tbm.add((IContributionItem)new Separator());
            tbm.add((IAction)this.saveDiagramAction);
            this.refreshDiagramAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
            this.upPackageDiagramAction.setDiagramEditor((DiagramEditor)this.getEditorPage());
            tbm.update(true);
        }
    }

    @Override
    public void handleNotification(Notification theNotification) {
    }

    @Override
    public void enableDiagramToolbarActions() {
        if (this.upPackageDiagramAction != null) {
            this.upPackageDiagramAction.determineEnablement();
        }
    }

    @Override
    public boolean shouldOverrideMenu(ISelection selection) {
        boolean value = false;
        if (this.singleLinkSelected()) {
            return true;
        }
        if (!this.singleLinkSelected()) {
            value = false;
        }
        return value;
    }
}

