/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.part;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ExposeHelper;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ViewportExposeHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.actions.ScaledFontManager;
import org.teiid.designer.diagram.ui.connection.AnchorManager;
import org.teiid.designer.diagram.ui.connection.NodeConnectionEditPart;
import org.teiid.designer.diagram.ui.connection.NodeConnectionModel;
import org.teiid.designer.diagram.ui.editor.DiagramEditorUtil;
import org.teiid.designer.diagram.ui.figure.DiagramFigure;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPartFactory;
import org.teiid.designer.diagram.ui.part.DropEditPart;
import org.teiid.designer.diagram.ui.part.DropEditPartHelper;
import org.teiid.designer.diagram.ui.part.PropertyChangeManager;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.diagram.DiagramLinkType;

public abstract class AbstractDefaultEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
DiagramEditPart,
DropEditPart {
    private boolean canResize = true;
    private boolean isPrimary = false;
    private boolean isSelectable = true;
    private String sNotationId;
    private String sDiagramTypeId;
    private DropEditPartHelper dropHelper = null;
    private boolean underConstruction;
    private PropertyChangeManager changeManager;
    private AnchorManager anchorManager;
    private static final String SOURCE = "source";
    private static final String TARGET = "target";
    private Font currentDiagramFont;

    public AbstractDefaultEditPart() {
        this.init();
    }

    private void init() {
    }

    @Override
    public EObject getModelObject() {
        return ((DiagramModelNode)this.getModel()).getModelObject();
    }

    @Override
    public DiagramFigure getDiagramFigure() {
        if (this.getFigure() instanceof DiagramFigure) {
            return (DiagramFigure)this.getFigure();
        }
        return null;
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        ((DiagramModelNode)this.getModel()).addPropertyChangeListener(this);
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().activate();
        }
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        ((DiagramModelNode)this.getModel()).removePropertyChangeListener(this);
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().deactivate();
        }
    }

    protected List getModelChildren() {
        List children = ((DiagramModelNode)this.getModel()).getChildren();
        return children;
    }

    @Override
    public void clearSelections(boolean clearSubSelections) {
    }

    @Override
    public void layout(boolean layoutChildren) {
        if (layoutChildren) {
            List editPartChildren = this.getChildren();
            Iterator iter = editPartChildren.iterator();
            EditPart nextEP = null;
            while (iter.hasNext()) {
                nextEP = (EditPart)iter.next();
                if (!(nextEP instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEP).layout(layoutChildren);
            }
        }
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().layoutFigure();
        }
        this.updateModelSize();
        List containerChildren = this.getChildren();
        for (Object nextObj : containerChildren) {
            if (!(nextObj instanceof DiagramEditPart)) continue;
            ((DiagramEditPart)nextObj).updateModelPosition();
        }
    }

    @Override
    public void layout() {
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().layoutFigure();
        }
        this.updateModelSize();
        List containerChildren = this.getChildren();
        for (Object nextObj : containerChildren) {
            if (!(nextObj instanceof DiagramEditPart)) continue;
            ((DiagramEditPart)nextObj).updateModelPosition();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("children")) {
            this.getChangeManager().refresh(0, true);
            this.getChangeManager().refresh(11, true);
        } else if (prop.equals("size")) {
            this.getChangeManager().refresh(1, false);
        } else if (prop.equals("location")) {
            this.getChangeManager().refresh(1, false);
        } else if (prop.equals("prop")) {
            this.getChangeManager().refresh(1, false);
        } else if (prop.equals("name")) {
            this.getChangeManager().refresh(2, false);
            this.getChangeManager().refresh(3, false);
            this.getChangeManager().refresh(1, false);
            DiagramEditPart topParent = DiagramUiUtilities.getTopClassifierParent(this);
            if (topParent != null) {
                topParent.getChangeManager().refresh(11, false);
            }
        } else if (prop.equals("errors")) {
            this.getDiagramFigure().updateForError(((DiagramModelNode)this.getModel()).hasErrors());
            this.getDiagramFigure().updateForWarning(((DiagramModelNode)this.getModel()).hasWarnings());
            this.getChangeManager().refresh(1, false);
        } else if (prop.equals("layout")) {
            this.getChangeManager().refresh(10, false);
        }
    }

    @Override
    public void updateContent() {
    }

    @Override
    public void updateModelPosition() {
        ((DiagramModelNode)this.getModel()).setPosition(new Point(this.getFigure().getBounds().x, this.getFigure().getBounds().y));
    }

    @Override
    public void updateModelSize() {
        ((DiagramModelNode)this.getModel()).setSize(this.getFigure().getSize());
    }

    @Override
    public void resizeChildren() {
    }

    @Override
    public void refreshName() {
        this.getDiagramFigure().updateForName(((DiagramModelNode)this.getModel()).getName());
    }

    @Override
    public void selectPrimaryParent() {
        DiagramEditPart editPart = this.getPrimaryParent();
        if (editPart != null) {
            editPart.setSelected(2);
        }
    }

    @Override
    public DiagramEditPart getPrimaryParent() {
        if (this.getParent() instanceof DiagramEditPart) {
            if (((DiagramEditPart)this.getParent()).isPrimaryParent()) {
                return (DiagramEditPart)this.getParent();
            }
            return this.getPrimaryParent();
        }
        return null;
    }

    @Override
    public boolean isPrimaryParent() {
        return this.isPrimary;
    }

    protected void setPrimaryParent(boolean primary) {
        this.isPrimary = primary;
    }

    @Override
    public boolean isSelectablePart() {
        return this.isSelectable;
    }

    protected void setSelectablePart(boolean selectable) {
        this.isSelectable = selectable;
    }

    @Override
    public DiagramEditPartFactory getEditPartFactory() {
        return DiagramUiPlugin.getDiagramTypeManager().getDiagram(this.getDiagramTypeId()).getEditPartFactory();
    }

    @Override
    public DiagramEditPart getEditPart(DiagramModelNode someModelNode) {
        if (this.getModel() != null && this.getModel().equals(someModelNode)) {
            return this;
        }
        DiagramEditPart matchedPart = (DiagramEditPart)this.getViewer().getEditPartRegistry().get(someModelNode);
        return matchedPart;
    }

    @Override
    public EditPart getEditPart(EObject someModelObject, boolean linksAllowed) {
        if (this.getModelObject() != null) {
            EObject targetEObject;
            if (this.getModelObject() instanceof Diagram ? (targetEObject = ((Diagram)this.getModelObject()).getTarget()) != null && targetEObject.equals(someModelObject) : this.getModelObject().equals(someModelObject)) {
                return this;
            }
            if (linksAllowed) {
                Object nextObject = null;
                NodeConnectionEditPart ncep = null;
                Iterator iter = this.getSourceConnections().iterator();
                EObject connEObject = null;
                while (iter.hasNext()) {
                    nextObject = iter.next();
                    if (!(nextObject instanceof NodeConnectionEditPart) || (connEObject = ((NodeConnectionModel)(ncep = (NodeConnectionEditPart)nextObject).getModel()).getModelObject()) == null || !connEObject.equals(someModelObject)) continue;
                    return ncep;
                }
            }
        }
        List contents = this.getChildren();
        Iterator iter = contents.iterator();
        Object nextObj = null;
        EditPart matchedPart = null;
        while (iter.hasNext() && matchedPart == null) {
            nextObj = iter.next();
            if (!(nextObj instanceof DiagramEditPart)) continue;
            matchedPart = ((DiagramEditPart)nextObj).getEditPart(someModelObject, linksAllowed);
        }
        return matchedPart;
    }

    @Override
    public String getNotationId() {
        return this.sNotationId;
    }

    @Override
    public void setNotationId(String sNotationId) {
        this.sNotationId = sNotationId;
    }

    @Override
    public String getDiagramTypeId() {
        return this.sDiagramTypeId;
    }

    @Override
    public void setDiagramTypeId(String sDiagramTypeId) {
        this.sDiagramTypeId = sDiagramTypeId;
    }

    @Override
    public EditPartViewer getViewer() {
        if (this.getRoot() != null) {
            return this.getRoot().getViewer();
        }
        return null;
    }

    public boolean isValidViewer() {
        boolean bIsValid = false;
        try {
            EditPartViewer epv = this.getRoot().getViewer();
            if (epv != null) {
                bIsValid = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            bIsValid = false;
        }
        return bIsValid;
    }

    public Object getAdapter(Class key) {
        if (key == ExposeHelper.class) {
            return new ViewportExposeHelper((GraphicalEditPart)this);
        }
        return super.getAdapter(key);
    }

    protected void addTargetConnection(ConnectionEditPart connection, int index) {
        this.primAddTargetConnection(connection, index);
        connection.setTarget((EditPart)this);
        this.fireTargetConnectionAdded(connection, index);
    }

    protected void addSourceConnection(ConnectionEditPart connection, int index) {
        this.primAddSourceConnection(connection, index);
        connection.setSource((EditPart)this);
        if (this.isActive()) {
            connection.activate();
        }
        this.fireSourceConnectionAdded(connection, index);
    }

    protected List getModelSourceConnections() {
        Vector sourceConnections = ((DiagramModelNode)this.getModel()).getSourceConnections();
        return sourceConnections;
    }

    protected List getModelTargetConnections() {
        return ((DiagramModelNode)this.getModel()).getTargetConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (this.getAnchorManager() != null) {
            return this.getAnchorManager().getSourceAnchor((NodeConnectionEditPart)connection);
        }
        return null;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (this.getAnchorManager() != null) {
            return this.getAnchorManager().getTargetAnchor((NodeConnectionEditPart)connection);
        }
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    @Override
    public AnchorManager getAnchorManager() {
        return this.anchorManager;
    }

    @Override
    public void createOrUpdateAnchorsLocations(boolean updateOtherEnds) {
        List sourceConn;
        if (this.getAnchorManager() == null) {
            return;
        }
        Dimension size = ((DiagramModelNode)this.getModel()).getSize();
        if (size != null) {
            this.getAnchorManager().reorderAllAnchors(updateOtherEnds);
        }
        if ((sourceConn = this.getModelSourceConnections()) != null && !sourceConn.isEmpty()) {
            Iterator iter = sourceConn.iterator();
            NodeConnectionModel ncm = null;
            while (iter.hasNext()) {
                ncm = (NodeConnectionModel)iter.next();
                ncm.refreshBendPoints();
            }
        }
    }

    @Override
    public void refreshFont(boolean refreshChildren) {
        this.setCurrentDiagramFont(ScaledFontManager.getFont());
        if (refreshChildren) {
            List editPartChildren = this.getChildren();
            Iterator iter = editPartChildren.iterator();
            EditPart nextEP = null;
            while (iter.hasNext()) {
                nextEP = (EditPart)iter.next();
                if (!(nextEP instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextEP).refreshFont(refreshChildren);
            }
        }
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().refreshFont();
            ((DiagramModelNode)this.getModel()).setSize(this.getFigure().getSize());
            ((DiagramModelNode)this.getModel()).setPosition(new Point(this.getFigure().getBounds().x, this.getFigure().getBounds().y));
        }
        this.refreshAllLabels();
    }

    public void refreshAllLabels() {
        List tConnections;
        NodeConnectionModel daAssociation;
        NodeConnectionEditPart ncepPart;
        List sConnections;
        Dimension size = ((DiagramModelNode)this.getModel()).getSize();
        String currentRouterType = DiagramLinkType.get((int)DiagramEditorUtil.getCurrentDiagramRouterStyle()).getName();
        if (size != null && !(sConnections = this.getSourceConnections()).isEmpty()) {
            int iSource = 0;
            while (iSource < sConnections.size()) {
                if (sConnections.get(iSource) instanceof NodeConnectionEditPart) {
                    ncepPart = (NodeConnectionEditPart)sConnections.get(iSource);
                    daAssociation = (NodeConnectionModel)ncepPart.getModel();
                    daAssociation.setRouterStyle(currentRouterType);
                    this.resizeLabelsForAssociation(daAssociation);
                    this.refreshAssociationLabels(ncepPart, daAssociation, SOURCE);
                }
                ++iSource;
            }
        }
        if (size != null && !(tConnections = this.getTargetConnections()).isEmpty()) {
            int iTarget = 0;
            while (iTarget < tConnections.size()) {
                if (tConnections.get(iTarget) instanceof NodeConnectionEditPart) {
                    ncepPart = (NodeConnectionEditPart)tConnections.get(iTarget);
                    daAssociation = (NodeConnectionModel)ncepPart.getModel();
                    daAssociation.setRouterStyle(currentRouterType);
                    this.resizeLabelsForAssociation(daAssociation);
                    this.refreshAssociationLabels(ncepPart, daAssociation, TARGET);
                }
                ++iTarget;
            }
        }
    }

    private void resizeLabelsForAssociation(NodeConnectionModel daAssociation) {
        Iterator iter = daAssociation.getLabelNodes().iterator();
        DiagramModelNode nextLabelNode = null;
        DiagramEditPart nextEditPart = null;
        while (iter.hasNext()) {
            nextLabelNode = (DiagramModelNode)iter.next();
            nextEditPart = DiagramUiUtilities.getDiagramEditPart(this, nextLabelNode);
            if (nextEditPart == null || nextEditPart.getDiagramFigure() == null) continue;
            nextLabelNode.setSize(nextEditPart.getFigure().getSize());
        }
    }

    private void refreshAssociationLabels(NodeConnectionEditPart ncepPart, NodeConnectionModel daAssociation, String sType) {
        ConnectionAnchor ncaSourceAnchor = null;
        ConnectionAnchor ncaTargetAnchor = null;
        if (sType.equals(SOURCE)) {
            DiagramEditPart depTargetEditPart;
            ncaSourceAnchor = this.getAnchorManager().getSourceAnchor(ncepPart);
            if (ncaSourceAnchor == null) {
                ncaSourceAnchor = this.getSourceConnectionAnchor((ConnectionEditPart)ncepPart);
            }
            if ((depTargetEditPart = (DiagramEditPart)ncepPart.getTarget()) != null) {
                ncaTargetAnchor = depTargetEditPart.getTargetConnectionAnchor((ConnectionEditPart)ncepPart);
                if (ncaTargetAnchor == null) {
                    ncaTargetAnchor = this.getTargetConnectionAnchor((ConnectionEditPart)ncepPart);
                }
                if (ncaSourceAnchor != null && ncaTargetAnchor != null) {
                    daAssociation.layout(ncaSourceAnchor, ncaTargetAnchor, this);
                }
            }
        } else {
            DiagramEditPart depSourceEditPart;
            ncaTargetAnchor = this.getAnchorManager().getTargetAnchor(ncepPart);
            if (ncaTargetAnchor == null) {
                ncaTargetAnchor = this.getTargetConnectionAnchor((ConnectionEditPart)ncepPart);
            }
            if ((depSourceEditPart = (DiagramEditPart)ncepPart.getSource()) != null) {
                ncaSourceAnchor = depSourceEditPart.getSourceConnectionAnchor((ConnectionEditPart)ncepPart);
                if (ncaSourceAnchor == null) {
                    ncaSourceAnchor = this.getSourceConnectionAnchor((ConnectionEditPart)ncepPart);
                }
                if (ncaSourceAnchor != null && ncaTargetAnchor != null) {
                    daAssociation.layout(ncaSourceAnchor, ncaTargetAnchor, this);
                }
            }
        }
    }

    @Override
    public void hiliteBackground(Color hiliteColor) {
    }

    @Override
    public boolean shouldHiliteBackground(List sourceEditParts) {
        return false;
    }

    @Override
    public void setAnchorManager(AnchorManager anchorManager) {
        this.anchorManager = anchorManager;
    }

    protected IFigure createFigure() {
        return null;
    }

    public void setSelected(int value) {
        super.setSelected(value);
        if (value == 0) {
            this.showSelected(false);
        } else {
            this.showSelected(true);
        }
    }

    @Override
    public void showSelected(boolean selected) {
        if (this.getDiagramFigure() != null) {
            this.getDiagramFigure().showSelected(selected);
        }
    }

    @Override
    public void clearHiliting() {
        List contents = this.getChildren();
        Iterator iter = contents.iterator();
        Object nextObj = null;
        while (iter.hasNext()) {
            nextObj = iter.next();
            if (!(nextObj instanceof DiagramEditPart)) continue;
            ((DiagramEditPart)nextObj).clearHiliting();
        }
        this.hiliteBackground(null);
    }

    @Override
    public List getDependencies() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isResizable() {
        return this.canResize;
    }

    @Override
    public void setResizable(boolean canResize) {
        this.canResize = canResize;
    }

    @Override
    public void updateForPreferences() {
    }

    @Override
    public boolean shouldReveal() {
        return true;
    }

    @Override
    public Font getCurrentDiagramFont() {
        return this.currentDiagramFont;
    }

    public void setCurrentDiagramFont(Font font) {
        this.currentDiagramFont = font;
    }

    @Override
    public void handleZoomChanged() {
    }

    public DropEditPartHelper getDropHelper() {
        return this.dropHelper;
    }

    public void setDropHelper(DropEditPartHelper dropHelper) {
        this.dropHelper = dropHelper;
    }

    @Override
    public void drop(Point dropPoint, List dropList) {
        if (this.dropHelper != null) {
            this.dropHelper.drop(dropPoint, dropList);
        }
    }

    @Override
    public void hilite(boolean hilite) {
        if (this.dropHelper != null) {
            this.dropHelper.hilite(hilite);
        }
    }

    @Override
    public Point getLastHoverPoint() {
        if (this.dropHelper != null) {
            return this.dropHelper.getLastHoverPoint();
        }
        return new Point(0, 0);
    }

    @Override
    public void setLastHoverPoint(Point lastHoverPoint) {
        if (this.dropHelper != null) {
            this.dropHelper.setLastHoverPoint(lastHoverPoint);
        }
    }

    @Override
    public boolean allowsDrop(Object target, List dropList) {
        if (this.dropHelper != null) {
            return this.dropHelper.allowsDrop(target, dropList);
        }
        return false;
    }

    @Override
    public PropertyChangeManager getChangeManager() {
        if (this.changeManager == null) {
            this.changeManager = new PropertyChangeManager(this);
        }
        return this.changeManager;
    }

    @Override
    public boolean isUnderConstruction() {
        return this.underConstruction;
    }

    @Override
    public void setUnderConstruction(boolean theUnderConstruction) {
        this.underConstruction = theUnderConstruction;
        List contents = this.getChildren();
        Iterator iter = contents.iterator();
        Object nextObj = null;
        while (iter.hasNext()) {
            nextObj = iter.next();
            if (!(nextObj instanceof DiagramEditPart)) continue;
            ((DiagramEditPart)nextObj).setUnderConstruction(theUnderConstruction);
        }
        this.getChangeManager().reset();
    }

    @Override
    public void constructionCompleted(boolean updateLinkedParts) {
        if (this.underConstruction) {
            List contents = this.getChildren();
            Iterator iter = contents.iterator();
            Object nextObj = null;
            while (iter.hasNext()) {
                nextObj = iter.next();
                if (!(nextObj instanceof DiagramEditPart)) continue;
                ((DiagramEditPart)nextObj).constructionCompleted(updateLinkedParts);
            }
            this.getChangeManager().executeRefresh(updateLinkedParts);
        }
        this.setUnderConstruction(false);
    }

    @Override
    public void refreshAllLabels(boolean theForceRefresh) {
        this.refreshAllLabels();
    }

    @Override
    public void refreshAnchors(boolean updateOtherEnds) {
        this.createOrUpdateAnchorsLocations(updateOtherEnds);
    }

    @Override
    public void refreshChildren(boolean theForceRefresh) {
        this.refreshChildren();
    }

    @Override
    public void refreshPath(boolean theForceRefresh) {
    }

    @Override
    public void refreshSourceConnections(boolean theForceRefresh) {
        this.refreshSourceConnections();
    }

    @Override
    public void refreshTargetConnections(boolean theForceRefresh) {
        this.refreshTargetConnections();
    }

    @Override
    public void refreshVisuals(boolean theForceRefresh) {
        this.refreshVisuals();
    }

    @Override
    public void resizeChildren(boolean theForceRefresh) {
        this.resizeChildren();
    }
}

