/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.part;

import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;

public class PropertyChangeManager
implements DiagramUiConstants.DiagramNodeProperties {
    public static final int GENERAL = 0;
    public static final int VISUALS = 1;
    public static final int NAME = 2;
    public static final int LABELS = 3;
    public static final int ANCHORS = 4;
    public static final int SOURCE_CONNECTIONS = 5;
    public static final int TARGET_CONNECTIONS = 6;
    public static final int PATH = 7;
    public static final int CHILDREN = 8;
    public static final int RESIZE_CHILDREN = 9;
    public static final int LAYOUT = 10;
    public static final int LAYOUT_ALL = 11;
    private DiagramEditPart editPart;
    private boolean bRefresh = false;
    private boolean bRefreshVisuals = false;
    private boolean bRefreshName = false;
    private boolean bRefreshAllLabels = false;
    private boolean bRefreshAnchors = false;
    private boolean bRefreshSourceConnections = false;
    private boolean bRefreshTargetConnections = false;
    private boolean bRefreshPath = false;
    private boolean bRefreshChildren = false;
    private boolean bResizeChildren = false;
    private boolean bLayout = false;
    private boolean bLayoutAll = false;
    private boolean updateLinkedParts = false;
    private static int nStoppedRefreshes = 0;

    public PropertyChangeManager(DiagramEditPart theEditPart) {
        this.editPart = theEditPart;
    }

    public void refresh(int type, boolean forceRefresh) {
        boolean doIt = false;
        if (!this.editPart.isUnderConstruction() || forceRefresh) {
            doIt = true;
            this.setState(type, false);
        } else {
            int cfr_ignored_0 = ++nStoppedRefreshes % 100;
            this.setState(type, true);
        }
        if (doIt) {
            this.refresh(type);
        }
    }

    private void setState(int type, boolean state) {
        switch (type) {
            case 0: {
                this.bRefresh = state;
                if (!this.bRefresh) break;
                this.bRefreshVisuals = false;
                this.bRefreshTargetConnections = false;
                this.bRefreshSourceConnections = false;
                this.bRefreshChildren = false;
                break;
            }
            case 1: {
                this.bRefreshVisuals = state;
                break;
            }
            case 2: {
                this.bRefreshName = state;
                break;
            }
            case 3: {
                this.bRefreshAllLabels = state;
                break;
            }
            case 4: {
                this.bRefreshAnchors = state;
                break;
            }
            case 5: {
                this.bRefreshSourceConnections = state;
                break;
            }
            case 6: {
                this.bRefreshTargetConnections = state;
                break;
            }
            case 7: {
                this.bRefreshPath = state;
                break;
            }
            case 8: {
                this.bRefreshChildren = state;
                break;
            }
            case 9: {
                this.bResizeChildren = state;
                break;
            }
            case 10: {
                this.bLayout = state;
                break;
            }
            case 11: {
                this.bLayoutAll = state;
                break;
            }
        }
    }

    public void refresh(int type) {
        switch (type) {
            case 0: {
                this.editPart.refresh();
                break;
            }
            case 1: {
                this.editPart.refreshVisuals(true);
                break;
            }
            case 2: {
                this.editPart.refreshName();
                break;
            }
            case 3: {
                this.editPart.refreshAllLabels(true);
                break;
            }
            case 4: {
                this.editPart.refreshAnchors(this.updateLinkedParts);
                break;
            }
            case 5: {
                this.editPart.refreshSourceConnections(true);
                break;
            }
            case 6: {
                this.editPart.refreshTargetConnections(true);
                break;
            }
            case 7: {
                this.editPart.refreshPath(true);
                break;
            }
            case 8: {
                this.editPart.refreshChildren(true);
                break;
            }
            case 9: {
                this.editPart.resizeChildren(true);
                break;
            }
            case 10: {
                this.editPart.layout(false);
                break;
            }
            case 11: {
                this.editPart.layout(true);
                break;
            }
        }
    }

    public void executeRefresh(boolean updateLinkedParts) {
        if (this.editPart.isUnderConstruction()) {
            this.updateLinkedParts = updateLinkedParts;
            boolean refreshEPVisuals = this.bRefreshVisuals;
            if (this.bRefresh) {
                this.refresh(0, true);
            }
            if (this.bRefreshName) {
                this.refresh(2, true);
            }
            if (this.bRefreshAllLabels) {
                this.refresh(3, true);
            }
            if (this.bRefreshSourceConnections) {
                this.refresh(5, true);
            }
            if (this.bRefreshTargetConnections) {
                this.refresh(6, true);
            }
            if (this.bRefreshAnchors) {
                this.refresh(4, true);
            }
            if (this.bRefreshPath) {
                this.refresh(7, true);
            }
            if (this.bRefreshChildren) {
                this.refresh(8, true);
            }
            if (this.bResizeChildren) {
                this.refresh(9, true);
            }
            if (this.bLayout) {
                this.refresh(10, true);
                refreshEPVisuals = true;
            }
            if (this.bLayoutAll) {
                this.refresh(11, true);
                refreshEPVisuals = true;
            }
            if (refreshEPVisuals) {
                this.refresh(1, true);
            }
        }
    }

    public void reset() {
        this.bRefresh = false;
        this.bRefreshVisuals = false;
        this.bRefreshName = false;
        this.bRefreshAllLabels = false;
        this.bRefreshAnchors = false;
        this.bRefreshSourceConnections = false;
        this.bRefreshTargetConnections = false;
        this.bRefreshPath = false;
        this.bRefreshChildren = false;
        this.bResizeChildren = false;
        this.bLayout = false;
        this.bLayoutAll = false;
        this.updateLinkedParts = false;
    }
}

