/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.preferences;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.diagram.ui.DiagramTypeManager;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.PluginConstants;
import org.teiid.designer.diagram.ui.preferences.ColorObjectAndSelector;
import org.teiid.designer.diagram.ui.preferences.DiagramColorObject;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class AppearanceProcessor
implements DiagramUiConstants,
PluginConstants {
    private ColorObjectAndSelector[] colorInfo;
    private Button changeFontButton;
    private Label fontLabel;
    private IPreferenceStore preferenceStore;
    private Shell shell;
    private FontData currentFontData;

    public AppearanceProcessor(IPreferenceStore preferenceStore, Shell shell) {
        this.preferenceStore = preferenceStore;
        this.shell = shell;
    }

    public Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        String fontGroupHdr = Util.getString("DiagramAppearancePrefPage.fontBorderText", new Object[0]);
        Group fontGroup = WidgetFactory.createGroup((Composite)comp, (String)fontGroupHdr, (int)768, (int)1, (int)3);
        Label fontTypeLabel = new Label((Composite)fontGroup, 0);
        String fontTypeLabelStr = Util.getString("DiagramAppearancePrefPage.fontType", new Object[0]);
        fontTypeLabel.setText(fontTypeLabelStr);
        this.fontLabel = new Label((Composite)fontGroup, 0);
        GridData fontLabelGridData = new GridData(768);
        fontLabelGridData.horizontalIndent = 6;
        this.fontLabel.setLayoutData((Object)fontLabelGridData);
        this.changeFontButton = new Button((Composite)fontGroup, 8);
        String changeFontStr = Util.getString("DiagramAppearancePrefPage.change", new Object[0]);
        this.changeFontButton.setText(changeFontStr);
        this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                AppearanceProcessor.this.changeFontButtonPressed();
            }
        });
        String backgroundColorGroupHdr = Util.getString("DiagramAppearancePrefPage.backgrdColorBorderText", new Object[0]);
        Group backgroundGroup = WidgetFactory.createGroup((Composite)comp, (String)backgroundColorGroupHdr, (int)768, (int)1, (int)4);
        DiagramTypeManager mgr = DiagramUiPlugin.getDiagramTypeManager();
        List<DiagramColorObject> colorInfoList = mgr.getDiagramColorInfo();
        this.colorInfo = new ColorObjectAndSelector[colorInfoList.size()];
        Iterator<DiagramColorObject> it = colorInfoList.iterator();
        int i = 0;
        while (it.hasNext()) {
            GridData gdForLabels = new GridData();
            gdForLabels.horizontalAlignment = 3;
            GridData gdForColorButtons = new GridData();
            gdForColorButtons.horizontalAlignment = 1;
            DiagramColorObject dco = it.next();
            Label diagramColorLabel = new Label((Composite)backgroundGroup, 0);
            diagramColorLabel.setLayoutData((Object)gdForLabels);
            String diagramLabelStr = String.valueOf(dco.getDisplayName()) + ':';
            diagramColorLabel.setText(diagramLabelStr);
            ColorSelector sel = new ColorSelector((Composite)backgroundGroup);
            RGB color = dco.getPreferenceValue();
            sel.setColorValue(color);
            this.colorInfo[i] = new ColorObjectAndSelector(dco, sel);
            sel.getButton().setLayoutData((Object)gdForColorButtons);
            ++i;
        }
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)this.preferenceStore, (String)"modeler.preference.diagram.font");
        this.setFontData(fontData);
        return comp;
    }

    private void setFontData(FontData fontData) {
        String name = fontData.getName();
        int height = fontData.getHeight();
        int style = fontData.getStyle();
        boolean isBold = (style & 1) != 0;
        boolean isItalic = (style & 2) != 0;
        String styleStr = "";
        if (isBold) {
            styleStr = String.valueOf(styleStr) + Util.getString("DiagramAppearancePrefPage.bold", new Object[0]);
        }
        if (isItalic) {
            if (styleStr.length() > 0) {
                styleStr = String.valueOf(styleStr) + " ";
            }
            styleStr = String.valueOf(styleStr) + Util.getString("DiagramAppearancePrefPage.italic", new Object[0]);
        }
        if (styleStr.length() == 0) {
            styleStr = Util.getString("DiagramAppearancePrefPage.regular", new Object[0]);
        }
        String fontStr = String.valueOf(name) + " - " + styleStr + " - " + height;
        this.fontLabel.setText(fontStr);
        this.currentFontData = fontData;
    }

    void changeFontButtonPressed() {
        FontDialog dialog = new FontDialog(this.shell);
        FontData[] fontDataArray = new FontData[]{this.currentFontData};
        dialog.setFontList(fontDataArray);
        FontData newFontData = dialog.open();
        if (newFontData != null && !this.currentFontData.equals((Object)newFontData)) {
            this.setFontData(newFontData);
        }
    }

    public boolean performOk() {
        PreferenceConverter.setValue((IPreferenceStore)this.preferenceStore, (String)"modeler.preference.diagram.font", (FontData)this.currentFontData);
        int i = 0;
        while (i < this.colorInfo.length) {
            PreferenceConverter.setValue((IPreferenceStore)this.preferenceStore, (String)this.colorInfo[i].getColorObject().getRGBPreferenceKey(), (RGB)this.colorInfo[i].getSelector().getColorValue());
            ++i;
        }
        DiagramUiPlugin.getDefault().savePreferences();
        return true;
    }

    public void performDefaults() {
        this.currentFontData = PreferenceConverter.getDefaultFontData((IPreferenceStore)this.preferenceStore, (String)"modeler.preference.diagram.font");
        this.setFontData(this.currentFontData);
        int i = 0;
        while (i < this.colorInfo.length) {
            RGB color = PreferenceConverter.getDefaultColor((IPreferenceStore)this.preferenceStore, (String)this.colorInfo[i].getColorObject().getRGBPreferenceKey());
            if (color != null) {
                this.colorInfo[i].getSelector().setColorValue(color);
            }
            ++i;
        }
    }
}

