/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.PluginConstants;
import org.teiid.designer.diagram.ui.preferences.AppearanceProcessor;
import org.teiid.designer.ui.common.util.WidgetFactory;

public class DiagramPreferencePage
extends PreferencePage
implements DiagramUiConstants,
PluginConstants,
IWorkbenchPreferencePage {
    private static final String KEY_PAGE_DESCRIPTION = "DiagramPrefPage.description";
    private String[] routers;
    private Combo routerCombo;
    private AppearanceProcessor appearanceProcessor;
    private Button fkShowNameButton;
    private Button fkShowMultiplicityButton;
    private boolean wasCancelled = false;
    private boolean wasOKed = false;
    Text modelSizeTextField;
    String modelSizeError;

    public DiagramPreferencePage() {
        this.setPreferenceStore(DiagramUiPlugin.getDefault().getPreferenceStore());
        this.setDescription(Util.getString(KEY_PAGE_DESCRIPTION, new Object[0]));
    }

    public void init(IWorkbench workbench) {
    }

    public Control createContents(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        String routersHdr = Util.getString("DiagramPrefPage.routers", new Object[0]);
        Group routersGroup = WidgetFactory.createGroup((Composite)comp, (String)routersHdr, (int)768, (int)1, (int)2);
        routersGroup.setText(routersHdr);
        GridData routersGroupGridData = new GridData(768);
        routersGroup.setLayoutData((Object)routersGroupGridData);
        Label routerLabel = new Label((Composite)routersGroup, 0);
        String routerStr = Util.getString("DiagramPrefPage.defaultRouter", new Object[0]);
        routerLabel.setText(routerStr);
        this.routerCombo = new Combo((Composite)routersGroup, 12);
        GridData routerComboGridData = new GridData(768);
        routerComboGridData.horizontalIndent = 10;
        this.routerCombo.setLayoutData((Object)routerComboGridData);
        this.routers = DiagramUiConstants.LinkRouter.types;
        int i = 0;
        while (i < this.routers.length) {
            this.routerCombo.add(this.routers[i]);
            ++i;
        }
        this.selectCurrentRouter();
        this.appearanceProcessor = new AppearanceProcessor(this.getPreferenceStore(), this.getShell());
        Control appearanceControl = this.appearanceProcessor.createContents(comp);
        GridData appearanceControlGridData = new GridData(768);
        appearanceControl.setLayoutData((Object)appearanceControlGridData);
        String modelSizeHeader = Util.getString("DiagramPrefPage.largeModelSizeHeader", new Object[0]);
        Group modelSizeGroup = WidgetFactory.createGroup((Composite)comp, (String)modelSizeHeader, (int)768, (int)1, (int)2);
        this.modelSizeError = Util.getString("DiagramPrefPage.largeModelSizeError", new Object[0]);
        String modelSizeButtonStr = Util.getString("DiagramPrefPage.largeModelSize", new Object[0]);
        WidgetFactory.createLabel((Composite)modelSizeGroup, (String)modelSizeButtonStr);
        this.modelSizeTextField = WidgetFactory.createTextField((Composite)modelSizeGroup, (int)768);
        this.modelSizeTextField.addModifyListener((ModifyListener)new SizeModifyListener());
        String largeModelSizeStr = this.getPreferenceStore().getString("largeModelSize");
        this.modelSizeTextField.setText(largeModelSizeStr);
        Group fkRelationshipsGroup = WidgetFactory.createGroup((Composite)comp, (String)Util.getString("DiagramPrefPage.relationshipOptionsLabel", new Object[0]), (int)768);
        this.fkShowNameButton = new Button((Composite)fkRelationshipsGroup, 32);
        this.fkShowNameButton.setText(Util.getString("DiagramPrefPage.showRoleNamesLabel", new Object[0]));
        boolean showName = this.getPreferenceStore().getBoolean("showFkName");
        this.fkShowNameButton.setSelection(showName);
        this.fkShowMultiplicityButton = new Button((Composite)fkRelationshipsGroup, 32);
        this.fkShowMultiplicityButton.setText(Util.getString("DiagramPrefPage.showMultiplicityLabel", new Object[0]));
        boolean showMulti = this.getPreferenceStore().getBoolean("showFkMultiplicity");
        this.fkShowMultiplicityButton.setSelection(showMulti);
        return comp;
    }

    private void selectCurrentRouter() {
        String prefName = "modeler.preference.diagram.diagramRouterStyle";
        String router = this.getPreferenceStore().getString(prefName);
        this.selectRouter(router);
    }

    private void selectDefaultRouter() {
        String prefName = "modeler.preference.diagram.diagramRouterStyle";
        String router = this.getPreferenceStore().getDefaultString(prefName);
        this.selectRouter(router);
    }

    private void selectRouter(String router) {
        boolean selected = false;
        int i = 0;
        while (!selected && i < this.routers.length) {
            String thisRouter = this.routers[i];
            if (thisRouter.equals(router)) {
                this.routerCombo.select(i);
                selected = true;
                continue;
            }
            ++i;
        }
    }

    private void selectDefaultShowFKValues() {
        boolean defShowName = this.getPreferenceStore().getDefaultBoolean("showFkName");
        this.fkShowNameButton.setSelection(defShowName);
        boolean defShowMulti = this.getPreferenceStore().getDefaultBoolean("showFkMultiplicity");
        this.fkShowMultiplicityButton.setSelection(defShowMulti);
    }

    public boolean performOk() {
        boolean currentShowMulti;
        boolean currentShowName;
        String currentLargeModelSize;
        String oldLargeModelSize;
        String currentStoredID;
        String id;
        boolean savePrefs = false;
        int selectedIndex = this.routerCombo.getSelectionIndex();
        if (selectedIndex >= 0 && !(id = this.routers[selectedIndex]).equals(currentStoredID = this.getPreferenceStore().getString("modeler.preference.diagram.diagramRouterStyle"))) {
            savePrefs = true;
            this.getPreferenceStore().setValue("modeler.preference.diagram.diagramRouterStyle", id);
        }
        if (!(oldLargeModelSize = this.getPreferenceStore().getString("largeModelSize")).equals(currentLargeModelSize = this.modelSizeTextField.getText())) {
            savePrefs = true;
            this.getPreferenceStore().setValue("largeModelSize", currentLargeModelSize);
        }
        boolean appearanceOk = this.appearanceProcessor.performOk();
        if (!savePrefs) {
            savePrefs = appearanceOk;
        }
        if ((currentShowName = this.getPreferenceStore().getBoolean("showFkName")) != this.fkShowNameButton.getSelection()) {
            savePrefs = true;
            boolean newValue = this.fkShowNameButton.getSelection();
            this.getPreferenceStore().setValue("showFkName", newValue);
        }
        if ((currentShowMulti = this.getPreferenceStore().getBoolean("showFkMultiplicity")) != this.fkShowMultiplicityButton.getSelection()) {
            boolean newValue = this.fkShowMultiplicityButton.getSelection();
            this.getPreferenceStore().setValue("showFkMultiplicity", newValue);
            savePrefs = true;
        }
        if (savePrefs) {
            DiagramUiPlugin.getDefault().savePreferences();
            DiagramUiPlugin.updateEditorForPreferences();
        }
        this.wasOKed = true;
        return true;
    }

    public void performDefaults() {
        this.selectDefaultRouter();
        this.appearanceProcessor.performDefaults();
        this.modelSizeTextField.setText(String.valueOf(this.getPreferenceStore().getDefaultInt("largeModelSize")));
        this.selectDefaultShowFKValues();
    }

    public void dispose() {
        if (!this.wasCancelled && !this.wasOKed) {
            DiagramUiPlugin.updateEditorForPreferences();
        }
        super.dispose();
    }

    public boolean performCancel() {
        this.wasCancelled = true;
        return super.performCancel();
    }

    class SizeModifyListener
    implements ModifyListener {
        SizeModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            try {
                Integer.parseInt(DiagramPreferencePage.this.modelSizeTextField.getText());
                DiagramPreferencePage.this.setValid(true);
                DiagramPreferencePage.this.setErrorMessage(null);
            }
            catch (Exception exception) {
                DiagramPreferencePage.this.setErrorMessage(DiagramPreferencePage.this.modelSizeError);
                DiagramPreferencePage.this.setValid(false);
            }
        }
    }
}

