/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.preferences.FilterSettings;

public class FilterPreferencePage
extends PreferencePage
implements DiagramUiConstants,
IWorkbenchPreferencePage {
    private static final String KEY_PAGE_DESCRIPTION = "DiagramFilterPrefPage.description";
    private static final String KEY_DIAGRAM_TAB_TITLE = "DiagramFilterPrefPage.diagram.tabTitle";
    private static final String KEY_PACKAGE_TAB_TITLE = "DiagramFilterPrefPage.package.tabTitle";
    private static final String KEY_GROUP_TAB_TITLE = "DiagramFilterPrefPage.group.tabTitle";
    private static final String KEY_ATTRIBUTE_TAB_TITLE = "DiagramFilterPrefPage.attribute.tabTitle";
    private static final String KEY_OPERATIONS_TAB_TITLE = "DiagramFilterPrefPage.operations.tabTitle";
    private static final String KEY_ASSOCIATIONS_TAB_TITLE = "DiagramFilterPrefPage.associations.tabTitle";
    private static final String KEY_DIAGRAM_TAB_DESC = "DiagramFilterPrefPage.diagram.tabDesc";
    private static final String KEY_PACKAGE_TAB_DESC = "DiagramFilterPrefPage.package.tabDesc";
    private static final String KEY_GROUP_TAB_DESC = "DiagramFilterPrefPage.group.tabDesc";
    private static final String KEY_ATTRIBUTE_TAB_DESC = "DiagramFilterPrefPage.attribute.tabDesc";
    private static final String KEY_OPERATIONS_TAB_DESC = "DiagramFilterPrefPage.operations.tabDesc";
    private static final String KEY_ASSOCIATIONS_TAB_DESC = "DiagramFilterPrefPage.associations.tabDesc";
    private ArrayList settingControls;
    HashSet changedControls = null;

    public FilterPreferencePage() {
        this.setDescription(Util.getString(KEY_PAGE_DESCRIPTION, new Object[0]));
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(container, 0);
        GridData gd = new GridData(1808);
        folder.setLayoutData((Object)gd);
        this.settingControls = new ArrayList();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilterPreferencePage.this.changedControls == null) {
                    FilterPreferencePage.this.changedControls = new HashSet();
                }
                FilterPreferencePage.this.changedControls.add(e.widget);
            }
        };
        this.createPage(folder, Util.getString(KEY_DIAGRAM_TAB_TITLE, new Object[0]), 0);
        this.createPage(folder, Util.getString(KEY_PACKAGE_TAB_TITLE, new Object[0]), 1);
        this.createPage(folder, Util.getString(KEY_GROUP_TAB_TITLE, new Object[0]), 2);
        this.createPage(folder, Util.getString(KEY_ATTRIBUTE_TAB_TITLE, new Object[0]), 3);
        this.createPage(folder, Util.getString(KEY_OPERATIONS_TAB_TITLE, new Object[0]), 4);
        this.createPage(folder, Util.getString(KEY_ASSOCIATIONS_TAB_TITLE, new Object[0]), 5);
        int i = 0;
        while (i < this.settingControls.size()) {
            Control control = (Control)this.settingControls.get(i);
            if (control instanceof Button) {
                ((Button)control).addSelectionListener((SelectionListener)listener);
            }
            ++i;
        }
        return container;
    }

    private void createPage(TabFolder folder, String name, int index) {
        Composite page = new Composite((Composite)folder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        page.setLayout((Layout)layout);
        TabItem tab = new TabItem(folder, 0);
        tab.setText(name);
        tab.setControl((Control)page);
        Group group = new Group(page, 0);
        group.setLayoutData((Object)new GridData(1808));
        String descKey = index == 0 ? KEY_DIAGRAM_TAB_DESC : (index == 1 ? KEY_PACKAGE_TAB_DESC : (index == 2 ? KEY_GROUP_TAB_DESC : (index == 3 ? KEY_ATTRIBUTE_TAB_DESC : (index == 4 ? KEY_OPERATIONS_TAB_DESC : KEY_ASSOCIATIONS_TAB_DESC))));
        group.setText(Util.getString(descKey, new Object[0]));
        group.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        String[] settingIDs = FilterSettings.getSettings(index);
        int i = 0;
        while (i < settingIDs.length) {
            Control control = this.createSetting((Composite)group, settingIDs[i]);
            this.settingControls.add(control);
            ++i;
        }
    }

    private Control createSetting(Composite page, String settingID) {
        Button control = null;
        Button button = new Button(page, 32);
        button.setText(Util.getString(settingID, new Object[0]));
        button.setSelection(FilterSettings.getBoolean(settingID));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        button.setLayoutData((Object)gd);
        control = button;
        control.setData((Object)settingID);
        return control;
    }

    protected void performDefaults() {
        int i = 0;
        while (i < this.settingControls.size()) {
            Control control = (Control)this.settingControls.get(i);
            String settingID = (String)control.getData();
            if (control instanceof Button) {
                ((Button)control).setSelection(FilterSettings.getDefaultBoolean(settingID));
            }
            ++i;
        }
        this.changedControls = null;
    }

    public boolean performOk() {
        if (this.changedControls != null) {
            for (Control control : this.changedControls) {
                String settingID = (String)control.getData();
                if (!(control instanceof Button)) continue;
                boolean value = ((Button)control).getSelection();
                FilterSettings.setBoolean(settingID, value);
            }
            FilterSettings.save();
        }
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }
}

