/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.diagram.ui.util.DiagramEntityAdapter;
import org.teiid.designer.diagram.ui.util.DiagramUiUtilities;
import org.teiid.designer.metamodels.diagram.DiagramLink;
import org.teiid.designer.metamodels.diagram.DiagramLinkType;
import org.teiid.designer.metamodels.diagram.DiagramPosition;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class DiagramLinkAdapter
extends DiagramEntityAdapter {
    public static List getBendpoints(DiagramLink diagramLink) {
        CoreArgCheck.isNotNull((Object)diagramLink);
        EList positions = diagramLink.getRoutePoints();
        if (positions != null && !positions.isEmpty()) {
            ArrayList<Point> bendpoints = new ArrayList<Point>(positions.size());
            Iterator iter = positions.iterator();
            DiagramPosition position = null;
            while (iter.hasNext()) {
                position = (DiagramPosition)iter.next();
                bendpoints.add(new Point(position.getXPosition(), position.getYPosition()));
            }
            return bendpoints;
        }
        return Collections.EMPTY_LIST;
    }

    public static void setBendpoints(DiagramLink diagramLink, List bendpoints) {
        CoreArgCheck.isNotNull((Object)diagramLink);
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Link Bendpoints", (Object)diagramLink);
        boolean succeeded = false;
        try {
            ArrayList currentPoints = new ArrayList(diagramLink.getRoutePoints());
            if (!currentPoints.isEmpty()) {
                ModelObjectUtilities.delete(currentPoints, (boolean)false, (boolean)false, (Object)diagramLink);
            }
            DiagramUiUtilities.createDiagramPositions(diagramLink, bendpoints);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public static void addBendpoint(DiagramLink diagramLink, int index, Point newBendpoint) {
        CoreArgCheck.isNotNull((Object)diagramLink);
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Link Bendpoint", (Object)diagramLink);
        boolean succeeded = false;
        try {
            DiagramPosition newPos = DiagramUiUtilities.createDiagramPosition(diagramLink, newBendpoint);
            diagramLink.getRoutePoints().move(index, (Object)newPos);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public static void removeBendpoint(DiagramLink diagramLink, int index) {
        CoreArgCheck.isNotNull((Object)diagramLink);
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Remove Link Bendpoint", (Object)diagramLink);
        boolean succeeded = false;
        try {
            EList currentPoints = diagramLink.getRoutePoints();
            currentPoints.remove(index);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public static void clearBendpoints(DiagramLink diagramLink) {
        CoreArgCheck.isNotNull((Object)diagramLink);
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Remove Link Bendpoint", (Object)diagramLink);
        boolean succeeded = false;
        try {
            int nPoints = diagramLink.getRoutePoints().size();
            int i = nPoints - 1;
            while (i >= 0) {
                DiagramLinkAdapter.removeBendpoint(diagramLink, i);
                --i;
            }
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public static void setBendpoint(DiagramLink diagramLink, int index, Point newLocation) {
        CoreArgCheck.isNotNull((Object)diagramLink);
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add Link Bendpoint", (Object)diagramLink);
        boolean succeeded = false;
        try {
            EList currentPoints = diagramLink.getRoutePoints();
            ((DiagramPosition)currentPoints.get(index)).setXPosition(newLocation.x);
            ((DiagramPosition)currentPoints.get(index)).setYPosition(newLocation.y);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    public static int getType(DiagramLink diagramLink) {
        int type = 0;
        type = diagramLink.getType().getValue();
        return type;
    }

    public static void setType(DiagramLink diagramLink, int newType) {
        CoreArgCheck.isNotNull((Object)diagramLink);
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Set Link Type", (Object)diagramLink);
        boolean succeeded = false;
        try {
            DiagramLinkType theType = DiagramLinkType.get((int)newType);
            diagramLink.setType(theType);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }
}

