/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.association.AssociationDescriptor;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.notation.uml.part.SetAssociationCommand;
import org.teiid.designer.diagram.ui.part.AbstractDefaultEditPart;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.diagram.ui.part.DropEditPart;
import org.teiid.designer.diagram.ui.util.DiagramNodeSelectionEditPolicy;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.viewsupport.ModelObjectUtilities;

public class HiliteDndNodeSelectionEditPolicy
extends DiagramNodeSelectionEditPolicy {
    protected boolean hilited = false;

    private boolean canCreateAssociation() {
        boolean canCreate;
        block11: {
            List selectedEObjects;
            canCreate = false;
            if (!this.isDiagramReadOnly() && this.isPackageDiagram() && (selectedEObjects = this.getSelectedEObjects()).size() > 1) {
                try {
                    Collection descriptors = ModelerCore.getModelEditor().getNewAssociationDescriptors(selectedEObjects);
                    if (descriptors.size() == 1) {
                        AssociationDescriptor theDescriptor = (AssociationDescriptor)descriptors.iterator().next();
                        if (theDescriptor != null) {
                            this.printDescriptor(theDescriptor);
                            if (theDescriptor.isAmbiguous()) {
                                DiagramUiConstants.Util.log(1, "HiliteDndNodeSelectionEditPolicy.canCreateAssociation() The Association Descriptor is AMBIGUOUS");
                            }
                            if (theDescriptor.isComplete()) {
                                canCreate = true;
                            }
                        }
                        break block11;
                    }
                    Iterator iter = descriptors.iterator();
                    AssociationDescriptor theDescriptor = null;
                    while (iter.hasNext()) {
                        theDescriptor = (AssociationDescriptor)iter.next();
                        if (theDescriptor.isAmbiguous()) {
                            DiagramUiConstants.Util.log(1, "HiliteDndNodeSelectionEditPolicy.canCreateAssociation() The Association Descriptor is AMBIGUOUS");
                        }
                        if (theDescriptor.isComplete()) {
                            canCreate = true;
                        }
                        if (!canCreate) {
                            continue;
                        }
                        break;
                    }
                }
                catch (ModelerCoreException modelerCoreException) {
                    DiagramUiConstants.Util.log(4, "HiliteDndNodeSelectionEditPolicy.canCreateAssociation() ERROR getting New Association Descriptors");
                }
            }
        }
        return canCreate;
    }

    public void eraseTargetFeedback(Request request) {
        if (request != null && request.getType().equals("add children")) {
            this.showHighlight(false);
        }
    }

    public Command getCommand(Request request) {
        DiagramEditPart thisEditPart = (DiagramEditPart)this.getHost();
        if (thisEditPart.getModelObject() instanceof Diagram) {
            return null;
        }
        List eObjs = this.getSelectedEObjects();
        if (eObjs.size() > 1 && request.getType().equals("move") || request.getType().equals("add children")) {
            SetAssociationCommand newCommand = new SetAssociationCommand(this.getSelectedEObjects());
            return newCommand;
        }
        return null;
    }

    private List getSelectedEditParts() {
        if (this.getViewer() != null) {
            return this.getViewer().getSelectedEditParts();
        }
        return Collections.EMPTY_LIST;
    }

    private List getSelectedEObjects() {
        Iterator iter = this.getSelectedEditParts().iterator();
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        DiagramEditPart nextEP = null;
        DiagramModelNode nextDMN = null;
        while (iter.hasNext()) {
            nextEP = (DiagramEditPart)iter.next();
            if (nextEP.getModel() == null || !(nextEP.getModel() instanceof DiagramModelNode) || (nextDMN = (DiagramModelNode)nextEP.getModel()).getModelObject() == null || selectedEObjects.contains(nextDMN.getModelObject())) continue;
            selectedEObjects.add(nextDMN.getModelObject());
        }
        DiagramEditPart thisEditPart = (DiagramEditPart)this.getHost();
        if (thisEditPart.getModel() != null && thisEditPart.getModel() instanceof DiagramModelNode && (nextDMN = (DiagramModelNode)thisEditPart.getModel()).getModelObject() != null && !selectedEObjects.contains(nextDMN.getModelObject())) {
            selectedEObjects.add(nextDMN.getModelObject());
        }
        return selectedEObjects;
    }

    public EditPart getTargetEditPart(Request request) {
        if (request != null && request.getType() != null) {
            return request.getType().equals("add children") ? this.getHost() : null;
        }
        return null;
    }

    private DiagramViewer getViewer() {
        AbstractDefaultEditPart adep;
        EditPart ep = this.getHost();
        if (ep != null && ep instanceof AbstractDefaultEditPart && (adep = (AbstractDefaultEditPart)ep).isValidViewer() && adep.getViewer() instanceof DiagramViewer) {
            return (DiagramViewer)adep.getViewer();
        }
        return null;
    }

    protected boolean isDiagramReadOnly() {
        if (this.getViewer() != null) {
            Diagram diagram = this.getViewer().getEditor().getDiagram();
            return ModelObjectUtilities.isReadOnly((EObject)diagram);
        }
        return true;
    }

    private boolean isPackageDiagram() {
        Diagram diagram;
        boolean result = false;
        if (this.getViewer() != null && (diagram = this.getViewer().getEditor().getDiagram()) != null && diagram.getType() != null && diagram.getType().equals("packageDiagramType")) {
            result = true;
        }
        return result;
    }

    private void printDescriptor(AssociationDescriptor theDescriptor) {
    }

    protected void showHighlight(boolean hilite) {
        DiagramEditPart selectedEditPart = (DiagramEditPart)this.getHost();
        if (selectedEditPart instanceof DropEditPart) {
            ((DropEditPart)((Object)selectedEditPart)).hilite(hilite);
        } else if (hilite && !this.hilited) {
            this.hilited = true;
            selectedEditPart.hiliteBackground(ColorConstants.lightGreen);
        } else if (!hilite && this.hilited) {
            selectedEditPart.hiliteBackground(null);
            this.hilited = false;
        }
    }

    public void showTargetFeedback(Request request) {
        if ((request.getType().equals("move") || request.getType().equals("add children")) && this.canCreateAssociation()) {
            this.showHighlight(true);
        }
    }

    public boolean understandsRequest(Request request) {
        return false;
    }
}

