/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.teiid.designer.diagram.ui.DiagramUiConstants;
import org.teiid.designer.diagram.ui.DiagramUiPlugin;
import org.teiid.designer.diagram.ui.editor.DiagramEditor;
import org.teiid.designer.diagram.ui.editor.DiagramViewer;
import org.teiid.designer.diagram.ui.model.DiagramModelNode;
import org.teiid.designer.diagram.ui.part.DiagramEditPart;
import org.teiid.designer.ui.IDiagramTypeEditPart;

public class SaveDiagramHelper
implements DiagramUiConstants {
    private static final String FILE_DIALOG_TITLE = "SaveDiagramDialog.title";
    private static final long MAX_SAVEABLE_DIAGRAM_SIZE = 81000000L;
    private static final int COLOR_DEPTH = 16;

    public void saveDiagramToFile(DiagramEditor editor) {
        if (editor != null) {
            ImageLoader imageLoader = null;
            DiagramViewer viewer = editor.getDiagramViewer();
            List lstEditParts = viewer.getSelectedEditParts();
            imageLoader = lstEditParts.size() > 0 && this.selectionIsValid(lstEditParts) ? this.createImageLoaderForSelection(editor, lstEditParts) : this.createImageLoaderForFullDiagram(editor);
            if (imageLoader == null) {
                return;
            }
            System.gc();
            this.saveThisImageFile(imageLoader);
        }
    }

    private boolean checkDiagramSize(Rectangle rect) {
        long lRectangleSize = rect.width * rect.height;
        if (lRectangleSize > 81000000L) {
            String sMessage = String.valueOf(Util.getString("SaveDiagramWarningDialog1.message", (Object)81000000L)) + Util.getString("SaveDiagramWarningDialog2.message", (Object)lRectangleSize);
            MessageDialog.openWarning((Shell)this.getShell(), (String)Util.getString("SaveDiagramWarningDialog.title", new Object[0]), (String)sMessage);
            return false;
        }
        return true;
    }

    protected Shell getShell() {
        return DiagramUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }

    private boolean selectionIsValid(List lstEditParts) {
        Object oEditPart;
        return lstEditParts.size() != 1 || !((oEditPart = lstEditParts.iterator().next()) instanceof IDiagramTypeEditPart);
    }

    private void saveThisImageFile(ImageLoader imageLoader) {
        String[] aryDisplayExtensions = new String[]{"*.jpg", "*.bmp"};
        String[] aryExactExtensions = new String[]{".jpg", ".bmp"};
        int[] nArray = new int[2];
        nArray[0] = 4;
        int[] aryConstants = nArray;
        Shell shell = DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        FileDialog dlg = new FileDialog(shell, 8196);
        dlg.setText(DiagramUiConstants.Util.getString(FILE_DIALOG_TITLE, new Object[0]));
        dlg.setFilterExtensions(aryDisplayExtensions);
        String file = dlg.open();
        if (file != null) {
            String finalFileName = file;
            int iSelectedExtension = -1;
            int i = 0;
            while (i < aryExactExtensions.length) {
                if (file.endsWith(aryExactExtensions[i])) {
                    iSelectedExtension = i;
                    break;
                }
                ++i;
            }
            int iExtensionType = 4;
            if (iSelectedExtension != -1) {
                iExtensionType = aryConstants[iSelectedExtension];
            }
            final String sFileName = finalFileName;
            final int iSelectedExtensionType = iExtensionType;
            final ImageLoader finalImageLoader = imageLoader;
            final String sProgressMessage = Util.getString("SaveDiagramDialog.progressMessage", new Object[0]);
            if (finalImageLoader != null) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor theMonitor) {
                        theMonitor.beginTask(sProgressMessage, 100);
                        theMonitor.worked(50);
                        System.gc();
                        finalImageLoader.save(sFileName, iSelectedExtensionType);
                        theMonitor.done();
                    }
                };
                try {
                    new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, true, op);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    DiagramUiConstants.Util.log(e.getTargetException());
                }
                catch (Exception e) {
                    DiagramUiConstants.Util.log((Object)e.getMessage());
                }
            }
        }
    }

    private ImageLoader createImageLoaderForSelection(DiagramEditor editor, List lstEditParts) {
        ImageLoader imageLoader = null;
        DiagramViewer viewer = editor.getDiagramViewer();
        Rectangle rectSelection = this.createRectangleForSelectedEditParts(lstEditParts);
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure f = lm.getLayer((Object)"Printable Layers");
        Rectangle rectFullDiagram = f.getBounds();
        Display display = Display.getDefault();
        Image startingImage = null;
        ImageData scaledIData = null;
        System.gc();
        int iStartDiagramWidth = rectSelection.x + rectSelection.width;
        int iStartDiagramHeight = rectSelection.y + rectSelection.height;
        Rectangle rectSmallestRect = new Rectangle(0, 0, iStartDiagramWidth, iStartDiagramHeight);
        boolean bContinue = this.checkDiagramSize(rectSmallestRect);
        if (!bContinue) {
            return imageLoader;
        }
        try {
            startingImage = new Image((Device)display, 10, 10);
            ImageData imageData = new ImageData(10, 10, 16, new PaletteData(255, 65280, 0xFF0000));
            scaledIData = imageData.scaledTo(iStartDiagramWidth, iStartDiagramHeight);
            startingImage = new Image((Device)display, scaledIData);
        }
        catch (Exception e) {
            DiagramUiConstants.Util.log((Object)e.getMessage());
        }
        GC gcStarting = new GC((Drawable)startingImage);
        SWTGraphics graphics = new SWTGraphics(gcStarting);
        f.paint((Graphics)graphics);
        gcStarting.setClipping(rectFullDiagram.x, rectFullDiagram.y, rectFullDiagram.width, rectFullDiagram.height);
        gcStarting.copyArea(rectSelection.x, rectSelection.y, rectSelection.width, rectSelection.height, 0, 0);
        Image finalImage = new Image((Device)display, rectSelection.width, rectSelection.height);
        GC gcFinal = new GC((Drawable)finalImage);
        gcFinal.drawImage(startingImage, 0, 0, rectSelection.width, rectSelection.height, 0, 0, rectSelection.width, rectSelection.height);
        imageLoader = new ImageLoader();
        imageLoader.logicalScreenWidth = rectSelection.width;
        imageLoader.logicalScreenHeight = rectSelection.height;
        imageLoader.data = new ImageData[]{finalImage.getImageData()};
        gcStarting.dispose();
        gcFinal.dispose();
        graphics.dispose();
        startingImage.dispose();
        finalImage.dispose();
        return imageLoader;
    }

    private Rectangle createRectangleForSelectedEditParts(List lstEditParts) {
        int iSmallestX = -1;
        int iLargestXPlusWidth = 0;
        int iSmallestY = -1;
        int iLargestYPlusHeight = 0;
        int iX = 0;
        int iWidth = 0;
        int iXPlusWidth = 0;
        int iY = 0;
        int iHeight = 0;
        int iYPlusHeight = 0;
        for (EditPart ep : lstEditParts) {
            if (!(ep instanceof DiagramEditPart)) continue;
            DiagramEditPart dep = (DiagramEditPart)ep;
            DiagramModelNode dmNode = (DiagramModelNode)dep.getModel();
            iX = dmNode.getX();
            iWidth = dmNode.getWidth();
            iXPlusWidth = iX + iWidth;
            iY = dmNode.getY();
            iHeight = dmNode.getHeight();
            iYPlusHeight = iY + iHeight;
            if (iSmallestX == -1 || iX < iSmallestX) {
                iSmallestX = iX;
            }
            if (iXPlusWidth > iLargestXPlusWidth) {
                iLargestXPlusWidth = iXPlusWidth;
            }
            if (iSmallestY == -1 || iY < iSmallestY) {
                iSmallestY = iY;
            }
            if (iYPlusHeight <= iLargestYPlusHeight) continue;
            iLargestYPlusHeight = iYPlusHeight;
        }
        int iFullWidth = iLargestXPlusWidth - iSmallestX;
        int iFullHeight = iLargestYPlusHeight - iSmallestY;
        Rectangle rect = new Rectangle(iSmallestX, iSmallestY, iFullWidth, iFullHeight);
        return rect;
    }

    private ImageLoader createImageLoaderForFullDiagram(DiagramEditor editor) {
        ImageLoader imageLoader = null;
        Image finalImage = null;
        DiagramViewer viewer = editor.getDiagramViewer();
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure f = lm.getLayer((Object)"Printable Layers");
        Rectangle rectFullDiagram = f.getBounds();
        boolean bContinue = this.checkDiagramSize(rectFullDiagram);
        if (!bContinue) {
            return imageLoader;
        }
        Display display = Display.getDefault();
        System.gc();
        ImageData imageData = new ImageData(10, 10, 16, new PaletteData(255, 65280, 0xFF0000));
        ImageData scaledIData = imageData.scaledTo(rectFullDiagram.width, rectFullDiagram.height);
        finalImage = new Image((Device)display, scaledIData);
        GC graphicContext = new GC((Drawable)finalImage);
        SWTGraphics graphics = new SWTGraphics(graphicContext);
        f.paint((Graphics)graphics);
        imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{finalImage.getImageData()};
        imageLoader.logicalScreenHeight = rectFullDiagram.height;
        imageLoader.logicalScreenWidth = rectFullDiagram.width;
        graphicContext.dispose();
        graphics.dispose();
        finalImage.dispose();
        return imageLoader;
    }
}

