/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.diagram.ui.util.directedit;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Text;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditFigure;
import org.teiid.designer.diagram.ui.util.directedit.DirectEditPart;
import org.teiid.designer.ui.common.graphics.GlobalUiFontManager;

public class DirectEditPartManager
extends DirectEditManager {
    Font scaledFont;

    public DirectEditPartManager(GraphicalEditPart source, Class<? extends CellEditor> editorType, CellEditorLocator locator) {
        super(source, editorType, locator);
    }

    protected void bringDown() {
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        if (this.getEditPart() instanceof DirectEditPart) {
            DirectEditFigure figure = (DirectEditFigure)this.getEditPart().getFigure();
            Label label = figure.getLabelFigure();
            String initialLabelText = ((DirectEditPart)this.getEditPart()).getEditString();
            this.getCellEditor().setValue((Object)initialLabelText);
            Text text = (Text)this.getCellEditor().getControl();
            this.scaledFont = label.getFont();
            FontData data = this.scaledFont.getFontData()[0];
            Dimension fontSize = new Dimension(0, data.getHeight());
            label.translateToAbsolute((Translatable)fontSize);
            data.setHeight(fontSize.height);
            this.scaledFont = GlobalUiFontManager.getFont((FontData)data);
            text.setFont(this.scaledFont);
            text.selectAll();
        }
    }

    public void commitAndDispose() {
        if (this.getCellEditor() != null && this.getCellEditor().isActivated()) {
            super.commit();
        }
    }
}

