/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.adapters.properties;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.DataAssociation;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.DataObjectReference;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.DataStore;
import org.eclipse.bpmn2.DataStoreReference;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.ItemDefinition;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.Property;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.ThrowEvent;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.adapters.FeatureDescriptor;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.preferences.ModelEnablements;
import org.eclipse.bpmn2.modeler.core.utils.AnchorUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.EventDefinitionsUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.adapters.properties.Messages;
import org.eclipse.bpmn2.modeler.ui.features.flow.DataAssociationFeatureContainer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IReconnectionContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.ReconnectionContext;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FixPointAnchor;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.osgi.util.NLS;

public class DataAssociationPropertiesAdapter
extends ExtendedPropertiesAdapter<DataAssociation> {
    public DataAssociationPropertiesAdapter(AdapterFactory adapterFactory, DataAssociation object) {
        super(adapterFactory, (EObject)object);
        EReference ref = Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef();
        this.setFeatureDescriptor((EStructuralFeature)ref, new SourceTargetFeatureDescriptor(this, object, (EStructuralFeature)ref));
        this.setProperty((EStructuralFeature)ref, "ui.can.edit.inline", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.edit", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.create.new", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.is.multi.choice", Boolean.TRUE);
        ref = Bpmn2Package.eINSTANCE.getDataAssociation_TargetRef();
        this.setFeatureDescriptor((EStructuralFeature)ref, new SourceTargetFeatureDescriptor(this, object, (EStructuralFeature)ref));
        this.setProperty((EStructuralFeature)ref, "ui.can.edit.inline", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.edit", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.can.create.new", Boolean.FALSE);
        this.setProperty((EStructuralFeature)ref, "ui.is.multi.choice", Boolean.TRUE);
    }

    public class SourceTargetFeatureDescriptor
    extends FeatureDescriptor<DataAssociation> {
        public SourceTargetFeatureDescriptor(ExtendedPropertiesAdapter<DataAssociation> owner, DataAssociation object, EStructuralFeature feature) {
            super(owner, (EObject)object, feature);
        }

        public String getLabel() {
            if (this.feature == Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef()) {
                return Messages.DataAssociationPropertiesAdapter_Source;
            }
            return Messages.DataAssociationPropertiesAdapter_Target;
        }

        public Hashtable<String, Object> getChoiceOfValues() {
            ArrayList values = new ArrayList();
            EObject container = ModelUtil.getContainer((EObject)this.object);
            Object p = this.owner.getProperty("show.items.in.scope");
            if (p instanceof Boolean && ((Boolean)p).booleanValue()) {
                values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"properties", (Class[])new Class[]{Activity.class}));
                values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"properties", (Class[])new Class[]{Process.class}));
                values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"properties", (Class[])new Class[]{Event.class}));
                values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"dataStore", (Class[])new Class[]{DocumentRoot.class}));
                values.addAll(ModelUtil.collectAncestorObjects((EObject)container, (String)"flowElements", (Class[])new Class[]{FlowElementsContainer.class}, (Class[])new Class[]{ItemAwareElement.class}));
            } else if (container instanceof Activity) {
                Activity activity = (Activity)container;
                if (this.object instanceof DataInputAssociation) {
                    values.addAll(ModelUtil.getItemAwareElements((List)activity.getDataInputAssociations()));
                } else {
                    values.addAll(ModelUtil.getItemAwareElements((List)activity.getDataOutputAssociations()));
                }
            } else if (container instanceof ThrowEvent) {
                ThrowEvent event = (ThrowEvent)container;
                values.addAll(ModelUtil.getItemAwareElements((List)event.getDataInputAssociation()));
            } else if (container instanceof CatchEvent) {
                CatchEvent event = (CatchEvent)container;
                values.addAll(ModelUtil.getItemAwareElements((List)event.getDataOutputAssociation()));
            }
            super.setChoiceOfValues(values);
            return super.getChoiceOfValues();
        }

        public EObject createFeature(Resource resource, EClass eClass) {
            if (eClass == null) {
                if (ModelUtil.findNearestAncestor((EObject)this.object, (Class[])new Class[]{Process.class, Event.class}) != null) {
                    eClass = Bpmn2Package.eINSTANCE.getProperty();
                } else if (ModelUtil.findNearestAncestor((EObject)this.object, (Class[])new Class[]{DocumentRoot.class}) != null) {
                    eClass = Bpmn2Package.eINSTANCE.getDataStore();
                }
            }
            if (eClass != null) {
                return Bpmn2ModelerFactory.createObject((Resource)resource, (EClass)eClass, (Bpmn2ModelerFactory.KeyValue[])new Bpmn2ModelerFactory.KeyValue[0]);
            }
            return null;
        }

        protected void internalSet(DataAssociation association, EStructuralFeature feature, Object value, int index) {
            EObject container = null;
            EStructuralFeature containerFeature = null;
            if (value instanceof Property) {
                if (((Property)value).eContainer() == null) {
                    container = ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{Activity.class});
                    if (container == null) {
                        container = ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{Event.class});
                    }
                    if (container == null) {
                        container = ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{Process.class});
                    }
                    containerFeature = container.eClass().getEStructuralFeature("properties");
                }
            } else if (value instanceof DataStore) {
                if (((DataStore)value).eContainer() == null) {
                    container = ModelUtil.findNearestAncestor((EObject)association, (Class[])new Class[]{DocumentRoot.class});
                    containerFeature = container.eClass().getEStructuralFeature("dataStore");
                }
            } else if (value instanceof String) {
                Hashtable<String, Object> choices = this.getChoiceOfValues();
                Property property = (Property)choices.get(value);
                if (property == null) {
                    DiagramEditor editor = ModelUtil.getEditor((EObject)this.object);
                    ModelEnablements modelEnablement = (ModelEnablements)editor.getAdapter(ModelEnablements.class);
                    container = association;
                    do {
                        if ((container = ModelUtil.findNearestAncestor((EObject)container, (Class[])new Class[]{Activity.class, Event.class, Process.class})) == null) {
                            return;
                        }
                        containerFeature = container.eClass().getEStructuralFeature("properties");
                    } while (!modelEnablement.isEnabled(container.eClass(), containerFeature));
                    containerFeature = container.eClass().getEStructuralFeature("properties");
                    property = (Property)Bpmn2ModelerFactory.createObject((Resource)association.eResource(), Property.class);
                    ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((EObject)property);
                    adapter.getObjectDescriptor().setTextValue((String)value);
                }
                value = property;
            }
            EObject c = container;
            EStructuralFeature cf = containerFeature;
            ItemAwareElement v = (ItemAwareElement)value;
            if (feature == Bpmn2Package.eINSTANCE.getDataAssociation_SourceRef()) {
                this.setSourceRef(association, v, c, cf);
            } else {
                this.setTargetRef(association, v, c, cf);
            }
        }

        private void setSourceRef(DataAssociation association, ItemAwareElement value, EObject container, EStructuralFeature containerFeature) {
            if (association.getSourceRef().size() == 0) {
                if (container != null) {
                    if (containerFeature.isMany()) {
                        ((List)container.eGet(containerFeature)).add(value);
                    } else {
                        container.eSet(containerFeature, (Object)value);
                    }
                }
                if (value == null) {
                    association.getSourceRef().clear();
                } else {
                    association.getSourceRef().add(value);
                }
                this.updateConnectionIfNeeded(association, value);
            } else {
                if (container != null) {
                    if (containerFeature.isMany()) {
                        ((List)container.eGet(containerFeature)).add(value);
                    } else {
                        container.eSet(containerFeature, (Object)value);
                    }
                }
                this.updateConnectionIfNeeded(association, value);
                if (value == null) {
                    association.getSourceRef().clear();
                } else {
                    association.getSourceRef().set(0, value);
                }
                this.updateConnectionIfNeeded(association, value);
            }
            if (association.getTargetRef() != null) {
                ItemAwareElement targetRef = association.getTargetRef();
                if (association.eContainer() instanceof Event) {
                    ItemDefinition id;
                    ErrorUtils.showErrorMessage(null);
                    EventDefinition ed = EventDefinitionsUtil.getEventDefinition((ItemAwareElement)targetRef);
                    if (ed != null && value != null && (id = EventDefinitionsUtil.getItemDefinition((EventDefinition)ed)) != null && !ModelUtil.equals((Object)id, (Object)value.getItemSubjectRef())) {
                        RootElement re = EventDefinitionsUtil.getEventDefinitionTarget((EventDefinition)ed);
                        String sourceLabel = ExtendedPropertiesProvider.getTextValue((EObject)value);
                        String targetLabel = ExtendedPropertiesProvider.getTextValue((EObject)re);
                        ErrorUtils.showErrorMessage((String)NLS.bind((String)Messages.DataAssociationPropertiesAdapter_DataTypeMismatch, (Object)sourceLabel, (Object)targetLabel));
                    }
                } else if (value != null) {
                    targetRef.setItemSubjectRef(value.getItemSubjectRef());
                } else {
                    targetRef.setItemSubjectRef(null);
                }
                this.updateConnectionIfNeeded(association, value);
            }
        }

        private void setTargetRef(DataAssociation association, ItemAwareElement value, EObject container, EStructuralFeature containerFeature) {
            if (container != null) {
                if (containerFeature.isMany()) {
                    ((List)container.eGet(containerFeature)).add(value);
                } else {
                    container.eSet(containerFeature, (Object)value);
                }
            }
            this.updateConnectionIfNeeded(association, value);
            association.setTargetRef(value);
            if (!association.getSourceRef().isEmpty()) {
                ItemAwareElement sourceRef = (ItemAwareElement)association.getSourceRef().get(0);
                if (association.eContainer() instanceof Event) {
                    ItemDefinition id;
                    ErrorUtils.showErrorMessage(null);
                    EventDefinition ed = EventDefinitionsUtil.getEventDefinition((ItemAwareElement)sourceRef);
                    if (ed != null && value != null && (id = EventDefinitionsUtil.getItemDefinition((EventDefinition)ed)) != null && !ModelUtil.equals((Object)id, (Object)value.getItemSubjectRef())) {
                        RootElement re = EventDefinitionsUtil.getEventDefinitionTarget((EventDefinition)ed);
                        String sourceLabel = ExtendedPropertiesProvider.getTextValue((EObject)re);
                        String targetLabel = ExtendedPropertiesProvider.getTextValue((EObject)value);
                        ErrorUtils.showErrorMessage((String)NLS.bind((String)Messages.DataAssociationPropertiesAdapter_DataTypeMismatch, (Object)sourceLabel, (Object)targetLabel));
                    }
                } else if (value != null) {
                    sourceRef.setItemSubjectRef(value.getItemSubjectRef());
                } else {
                    sourceRef.setItemSubjectRef(null);
                }
                this.updateConnectionIfNeeded(association, value);
            }
        }

        private void updateConnectionIfNeeded(DataAssociation association, ItemAwareElement value) {
            Connection connection;
            DiagramEditor diagramEditor = ModelUtil.getDiagramEditor((EObject)association);
            if (diagramEditor == null) {
                return;
            }
            boolean hasDoneChanges = false;
            Diagram diagram = diagramEditor.getDiagramTypeProvider().getDiagram();
            IFeatureProvider fp = diagramEditor.getDiagramTypeProvider().getFeatureProvider();
            Shape taskShape = null;
            EObject container = association.eContainer();
            if (container instanceof Activity || container instanceof Event) {
                for (PictogramElement pe : Graphiti.getLinkService().getPictogramElements(diagram, container)) {
                    if (!(pe instanceof Shape) || BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BPMNShape.class) == null) continue;
                    taskShape = (Shape)pe;
                    break;
                }
            }
            Shape dataShape = null;
            if (value instanceof DataObject || value instanceof DataObjectReference || value instanceof DataStore || value instanceof DataStoreReference || value instanceof DataInput || value instanceof DataOutput) {
                List pes = Graphiti.getLinkService().getPictogramElements(diagram, (EObject)value);
                for (PictogramElement p : pes) {
                    if (BusinessObjectUtil.getFirstElementOfType((PictogramElement)p, BPMNShape.class) == null) continue;
                    dataShape = (Shape)p;
                    break;
                }
            }
            if ((connection = DataAssociationFeatureContainer.findDataAssociation(diagram, association)) != null) {
                if (dataShape != null) {
                    Point p;
                    ReconnectionContext rc = null;
                    if (association instanceof DataInputAssociation) {
                        p = GraphicsUtil.createPoint((Anchor)connection.getStart());
                        FixPointAnchor a = AnchorUtil.createAnchor((AnchorContainer)dataShape, (Point)p);
                        rc = new ReconnectionContext(connection, connection.getStart(), (Anchor)a, null);
                        rc.setTargetPictogramElement((PictogramElement)dataShape);
                        rc.setTargetLocation(Graphiti.getPeService().getLocationRelativeToDiagram((Anchor)a));
                        rc.setReconnectType(ReconnectionContext.RECONNECT_SOURCE);
                    } else {
                        p = GraphicsUtil.createPoint((Anchor)connection.getEnd());
                        FixPointAnchor a = AnchorUtil.createAnchor((AnchorContainer)dataShape, (Point)p);
                        rc = new ReconnectionContext(connection, connection.getEnd(), (Anchor)a, null);
                        rc.setTargetPictogramElement((PictogramElement)dataShape);
                        rc.setTargetLocation(Graphiti.getPeService().getLocationRelativeToDiagram((Anchor)a));
                        rc.setReconnectType(ReconnectionContext.RECONNECT_TARGET);
                    }
                    IReconnectionFeature rf = fp.getReconnectionFeature((IReconnectionContext)rc);
                    if (rf.canReconnect((IReconnectionContext)rc)) {
                        rf.reconnect((IReconnectionContext)rc);
                        hasDoneChanges = true;
                    }
                } else {
                    DeleteContext dc = new DeleteContext((PictogramElement)connection);
                    connection.getLink().getBusinessObjects().remove(0);
                    IDeleteFeature df = fp.getDeleteFeature((IDeleteContext)dc);
                    df.delete((IDeleteContext)dc);
                }
            } else if (dataShape != null) {
                PictogramElement pe;
                PictogramElement p;
                p = GraphicsUtil.createPoint(dataShape);
                FixPointAnchor ownerAnchor = AnchorUtil.createAnchor((AnchorContainer)taskShape, (Point)p);
                p = GraphicsUtil.createPoint((AnchorContainer)taskShape);
                FixPointAnchor peAnchor = AnchorUtil.createAnchor((AnchorContainer)dataShape, (Point)p);
                AddConnectionContext ac = null;
                ac = association instanceof DataOutputAssociation ? new AddConnectionContext((Anchor)ownerAnchor, (Anchor)peAnchor) : new AddConnectionContext((Anchor)peAnchor, (Anchor)ownerAnchor);
                ac.putProperty((Object)"businessObject", (Object)association);
                ac.setNewObject((Object)association);
                IAddFeature af = fp.getAddFeature((IAddContext)ac);
                if (af.canAdd((IAddContext)ac) && (pe = af.add((IAddContext)ac)) instanceof Connection) {
                    connection = (Connection)pe;
                    hasDoneChanges = true;
                }
            }
            if (hasDoneChanges) {
                FeatureSupport.updateConnection((IFeatureProvider)diagramEditor.getDiagramTypeProvider().getFeatureProvider(), (Connection)connection);
            }
        }
    }
}

