/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.ResizeExpandableActivityFeature;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ShowDiagramPageFeature;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ExpandFlowNodeFeature
extends ShowDiagramPageFeature {
    private static final String NAME = Messages.ExpandFlowNodeFeature_Name;
    private static final String DESCRIPTION = Messages.ExpandFlowNodeFeature_Description;
    private String name = NAME;
    private String description = DESCRIPTION;

    public ExpandFlowNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getImageId() {
        return ImageProvider.IMG_16_EXPAND;
    }

    @Override
    public boolean isAvailable(IContext context) {
        return true;
    }

    @Override
    public boolean canExecute(ICustomContext context) {
        if (super.canExecute(context)) {
            this.name = super.getName();
            this.description = super.getDescription();
            return true;
        }
        this.name = NAME;
        this.description = DESCRIPTION;
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)pes[0]);
            return !FeatureSupport.isElementExpanded((BaseElement)be);
        }
        return ret;
    }

    @Override
    public void execute(ICustomContext context) {
        if (super.canExecute(context)) {
            super.execute(context);
            return;
        }
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe0 = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe0);
            if (pe0 instanceof ContainerShape && bo instanceof FlowNode) {
                ContainerShape containerShape = (ContainerShape)pe0;
                FlowNode flowNode = (FlowNode)bo;
                try {
                    BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)pe0);
                    BPMNShape bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)bpmnDiagram, (BaseElement)flowNode);
                    if (!bpmnShape.isIsExpanded()) {
                        bpmnShape.setIsExpanded(true);
                        GraphicsAlgorithm ga = containerShape.getGraphicsAlgorithm();
                        ResizeShapeContext resizeContext = new ResizeShapeContext((Shape)containerShape);
                        IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)resizeContext);
                        resizeContext.setX(ga.getX());
                        resizeContext.setY(ga.getY());
                        IDimension oldSize = FeatureSupport.getExpandedSize((PictogramElement)containerShape);
                        int oldWidth = oldSize.getWidth();
                        int oldHeight = oldSize.getHeight();
                        resizeContext.setWidth(oldWidth);
                        resizeContext.setHeight(oldHeight);
                        FeatureSupport.setCollapsedSize((PictogramElement)containerShape, (int)oldWidth, (int)oldHeight);
                        ResizeExpandableActivityFeature.SizeCalculator calculator = new ResizeExpandableActivityFeature.SizeCalculator(resizeContext);
                        int newWidth = calculator.getWidth();
                        int newHeight = calculator.getHeight();
                        resizeContext.setX(ga.getX() + oldWidth / 2 - newWidth / 2);
                        resizeContext.setY(ga.getY() + oldHeight / 2 - newHeight / 2);
                        resizeContext.setWidth(newWidth);
                        resizeContext.setHeight(newHeight);
                        resizeFeature.resizeShape((IResizeShapeContext)resizeContext);
                        UpdateContext updateContext = new UpdateContext((PictogramElement)containerShape);
                        IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
                        if (updateFeature.updateNeeded((IUpdateContext)updateContext).toBoolean()) {
                            updateFeature.update((IUpdateContext)updateContext);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

