/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.DefaultResizeBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.preferences.Bpmn2Preferences;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class ResizeExpandableActivityFeature
extends DefaultResizeBPMNShapeFeature {
    public static final int MARGIN = 20;
    protected Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((EObject)this.getDiagram());

    public ResizeExpandableActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void resizeShape(IResizeShapeContext context) {
        ResizeShapeContext resizeShapeContext = (ResizeShapeContext)context;
        ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
        Activity activity = (Activity)BusinessObjectUtil.getFirstElementOfType((PictogramElement)containerShape, Activity.class);
        this.preferences.getShapeStyle((EObject)activity);
        ArrayList<ContainerShape> movedChildren = new ArrayList<ContainerShape>();
        List containerChildren = FeatureSupport.getContainerChildren((ContainerShape)containerShape);
        try {
            BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)containerShape);
            BPMNShape shape = DIUtils.findBPMNShape((BPMNDiagram)bpmnDiagram, (BaseElement)activity);
            if (shape.isIsExpanded()) {
                GraphicsAlgorithm childGa;
                SizeCalculator sizeCalc = new SizeCalculator(resizeShapeContext);
                int deltaX = sizeCalc.deltaX;
                int deltaY = sizeCalc.deltaY;
                if (deltaX != 0) {
                    for (PictogramElement pe : containerChildren) {
                        childGa = pe.getGraphicsAlgorithm();
                        if (childGa == null) continue;
                        int x = childGa.getX() - deltaX;
                        childGa.setX(x);
                        if (!(pe instanceof ContainerShape)) continue;
                        movedChildren.add((ContainerShape)pe);
                    }
                }
                if (deltaY != 0) {
                    for (PictogramElement pe : containerChildren) {
                        childGa = pe.getGraphicsAlgorithm();
                        if (childGa == null) continue;
                        int y = childGa.getY() - deltaY;
                        childGa.setY(y);
                        if (movedChildren.contains(pe) || !(pe instanceof ContainerShape)) continue;
                        movedChildren.add((ContainerShape)pe);
                    }
                }
            } else {
                for (PictogramElement pe : FeatureSupport.getContainerDecorators((ContainerShape)containerShape)) {
                    GraphicsAlgorithm childGa = pe.getGraphicsAlgorithm();
                    if (childGa == null) continue;
                    childGa.setWidth(context.getWidth());
                    childGa.setHeight(context.getHeight());
                }
            }
        }
        catch (Exception e) {
            Activator.logError((Exception)e);
        }
        super.resizeShape(context);
        FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), movedChildren);
    }

    public static class SizeCalculator {
        int deltaX;
        int deltaY;
        int deltaWidth;
        int deltaHeight;
        int minWidth;
        int minHeight;
        ContainerShape containerShape;
        ResizeShapeContext context;
        ShapeStyle ss;

        public SizeCalculator(ResizeShapeContext context) {
            this.context = context;
            this.setShape((ContainerShape)context.getPictogramElement());
        }

        private void setShape(ContainerShape containerShape) {
            this.containerShape = containerShape;
            Bpmn2Preferences preferences = Bpmn2Preferences.getInstance((Resource)containerShape.eResource());
            this.ss = preferences.getShapeStyle((EObject)BusinessObjectUtil.getFirstBaseElement((PictogramElement)containerShape));
            this.calculate();
        }

        private ILocation getLocationRelativeToContainer(ContainerShape parent, ContainerShape child) {
            ILocation loc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)child);
            ContainerShape container = parent.getContainer();
            if (container instanceof ContainerShape && !(container instanceof Diagram)) {
                ILocation containerLoc = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)container);
                loc.setX(loc.getX() - containerLoc.getX());
                loc.setY(loc.getY() - containerLoc.getY());
            }
            return loc;
        }

        private void calculate() {
            ILocation loc;
            GraphicsAlgorithm ga;
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minChildX = Integer.MAX_VALUE;
            int minChildY = Integer.MAX_VALUE;
            this.minWidth = 0;
            this.minHeight = 0;
            List containerChildren = FeatureSupport.getContainerChildren((ContainerShape)this.containerShape);
            for (PictogramElement pe : containerChildren) {
                ga = pe.getGraphicsAlgorithm();
                if (ga == null) continue;
                if (ga.getX() < minChildX) {
                    minChildX = ga.getX();
                }
                if (ga.getY() < minChildY) {
                    minChildY = ga.getY();
                }
                loc = this.getLocationRelativeToContainer(this.containerShape, (ContainerShape)pe);
                int x = loc.getX();
                int y = loc.getY();
                if (x < minX) {
                    minX = x;
                }
                if (y >= minY) continue;
                minY = y;
            }
            for (PictogramElement pe : containerChildren) {
                ga = pe.getGraphicsAlgorithm();
                if (ga == null) continue;
                loc = this.getLocationRelativeToContainer(this.containerShape, (ContainerShape)pe);
                int w = loc.getX() - minX + ga.getWidth();
                int h = loc.getY() - minY + ga.getHeight();
                if (w > this.minWidth) {
                    this.minWidth = w;
                }
                if (h <= this.minHeight) continue;
                this.minHeight = h;
            }
            if (this.minWidth <= 0) {
                this.minWidth = this.ss.getDefaultWidth();
            }
            if (this.minHeight <= 0) {
                this.minHeight = this.ss.getDefaultHeight();
            }
            minY -= 20;
            this.minWidth += 40;
            this.minHeight += 40;
            ga = this.containerShape.getGraphicsAlgorithm();
            if (this.context.getX() > (minX -= 20)) {
                int dx0 = this.context.getX() - ga.getX();
                this.context.setX(minX);
                int dx1 = this.context.getX() - ga.getX();
                this.context.setWidth(this.context.getWidth() - (dx1 - dx0));
            }
            if (this.context.getY() > minY) {
                int dy0 = this.context.getY() - ga.getY();
                this.context.setY(minY);
                int dy1 = this.context.getY() - ga.getY();
                this.context.setHeight(this.context.getHeight() - (dy1 - dy0));
            }
            if (this.context.getX() != ga.getX()) {
                this.deltaX = this.context.getX() - ga.getX();
            } else if (this.context.getWidth() < this.minWidth + minChildX - 20) {
                this.context.setWidth(this.minWidth + minChildX - 20);
            }
            if (this.context.getY() != ga.getY()) {
                this.deltaY = this.context.getY() - ga.getY();
            } else if (this.context.getHeight() < this.minHeight + minChildY - 20) {
                this.context.setHeight(this.minHeight + minChildY - 20);
            }
        }

        public int getWidth() {
            return this.minWidth;
        }

        public int getHeight() {
            return this.minHeight;
        }
    }
}

