/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.ArrayList;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.osgi.util.NLS;

public class UpdateExpandableActivityFeature
extends AbstractUpdateBaseElementFeature<BaseElement> {
    public UpdateExpandableActivityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        if (super.canUpdate(context)) {
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)context.getPictogramElement());
            return FeatureSupport.isExpandableElement((BaseElement)be);
        }
        return false;
    }

    public IReason updateNeeded(IUpdateContext context) {
        if (this.canUpdate(context)) {
            IReason reason = super.updateNeeded(context);
            if (reason.toBoolean()) {
                return reason;
            }
            PictogramElement pe = context.getPictogramElement();
            Property triggerProperty = Graphiti.getPeService().getProperty((PropertyContainer)pe, "triggered.by.event");
            boolean isExpanded = FeatureSupport.isElementExpanded((PictogramElement)pe);
            SubProcess subprocess = (SubProcess)this.getBusinessObjectForPictogramElement(pe);
            try {
                BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)pe);
                BPMNShape bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)bpmnDiagram, (BaseElement)subprocess);
                if (isExpanded != bpmnShape.isIsExpanded()) {
                    return Reason.createTrueReason((String)Messages.UpdateExpandableActivityFeature_Expand_Changed);
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException(NLS.bind((String)Messages.UpdateExpandableActivityFeature_No_DI_Element, (Object)subprocess));
            }
            if (triggerProperty != null && Boolean.parseBoolean(triggerProperty.getValue()) != subprocess.isTriggeredByEvent()) {
                return Reason.createTrueReason((String)Messages.UpdateExpandableActivityFeature_Trigger_Changed);
            }
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        SubProcess subprocess = (SubProcess)this.getBusinessObjectForPictogramElement(pe);
        ContainerShape container = (ContainerShape)pe;
        boolean isExpanded = false;
        BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)container);
        BPMNShape bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)bpmnDiagram, (BaseElement)subprocess);
        isExpanded = bpmnShape.isIsExpanded();
        Graphiti.getPeService().setPropertyValue((PropertyContainer)pe, "triggered.by.event", Boolean.toString(subprocess.isTriggeredByEvent()));
        FeatureSupport.setElementExpanded((PictogramElement)pe, (boolean)isExpanded);
        GraphicsAlgorithm rectangle = ((PictogramElement)Graphiti.getPeService().getAllContainedPictogramElements(pe).iterator().next()).getGraphicsAlgorithm();
        LineStyle lineStyle = subprocess.isTriggeredByEvent() ? LineStyle.DOT : LineStyle.SOLID;
        rectangle.setLineStyle(lineStyle);
        if (!isExpanded) {
            FeatureSupport.setContainerChildrenVisible((IFeatureProvider)this.getFeatureProvider(), (ContainerShape)container, (boolean)false);
            ShapeDecoratorUtil.showActivityMarker((ContainerShape)container, (String)"activity.marker.expand");
        } else {
            FeatureSupport.setContainerChildrenVisible((IFeatureProvider)this.getFeatureProvider(), (ContainerShape)container, (boolean)true);
            ShapeDecoratorUtil.hideActivityMarker((ContainerShape)container, (String)"activity.marker.expand");
        }
        if (subprocess.isTriggeredByEvent()) {
            ArrayList flows = new ArrayList();
            flows.addAll(subprocess.getIncoming());
            flows.addAll(subprocess.getOutgoing());
            for (SequenceFlow sf : flows) {
                Diagram diagram = this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
                Object[] objectArray = Graphiti.getPeService().getLinkedPictogramElements(new EObject[]{sf}, diagram);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof Connection) {
                        DeleteContext dc = new DeleteContext((PictogramElement)((Connection)o));
                        IDeleteFeature df = this.getFeatureProvider().getDeleteFeature((IDeleteContext)dc);
                        df.delete((IDeleteContext)dc);
                    }
                    ++n2;
                }
            }
        }
        return true;
    }
}

