/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.choreography;

import java.util.ArrayList;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ChoreographyActivity;
import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.features.choreography.Messages;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;
import org.eclipse.graphiti.services.IPeService;

public class UpdateChoreographyMessageFlowFeature
extends AbstractUpdateBaseElementFeature<ChoreographyTask> {
    private final IPeService peService = Graphiti.getPeService();
    private final ILinkService linkService = Graphiti.getLinkService();

    public UpdateChoreographyMessageFlowFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        boolean result = false;
        if (super.canUpdate(context)) {
            PictogramElement pe = context.getPictogramElement();
            result = ChoreographyUtil.isChoreographyActivity((PictogramElement)pe) || ChoreographyUtil.isChoreographyMessage((PictogramElement)pe);
        }
        return result;
    }

    public IReason updateNeeded(IUpdateContext context) {
        IReason reason = super.updateNeeded(context);
        if (reason.toBoolean()) {
            return reason;
        }
        PictogramElement pe = context.getPictogramElement();
        if (ChoreographyUtil.isChoreographyMessage((PictogramElement)pe)) {
            Message message = (Message)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, Message.class);
            TreeIterator iter = message.eContainer().eAllContents();
            block0: while (iter.hasNext()) {
                EObject eo = (EObject)iter.next();
                if (!(eo instanceof ChoreographyTask)) continue;
                ChoreographyTask choreographyTask = (ChoreographyTask)eo;
                for (MessageFlow mf : choreographyTask.getMessageFlowRef()) {
                    String newLabel;
                    if (mf.getMessageRef() != message) continue;
                    String oldLabel = this.peService.getPropertyValue((PropertyContainer)pe, "choreography.messageName");
                    if (oldLabel == null || oldLabel.isEmpty()) {
                        oldLabel = "";
                    }
                    if ((newLabel = ChoreographyUtil.getMessageFlowName((MessageFlow)mf)) == null || newLabel.isEmpty()) {
                        newLabel = "";
                    }
                    if (newLabel.equals(oldLabel)) continue;
                    reason = Reason.createTrueReason((String)Messages.UpdateChoreographyMessageFlowFeature_Message_Changed);
                    continue block0;
                }
            }
        } else {
            String taskIds;
            ContainerShape choreographyTaskShape = ChoreographyUtil.getChoreographyActivityShape((PictogramElement)pe);
            ChoreographyTask choreographyTask = (ChoreographyTask)BusinessObjectUtil.getFirstElementOfType((PictogramElement)choreographyTaskShape, ChoreographyTask.class);
            String shapeIds = ChoreographyUtil.getMessageRefIds((ContainerShape)choreographyTaskShape);
            if (!shapeIds.equals(taskIds = ChoreographyUtil.getMessageRefIds((ChoreographyTask)choreographyTask))) {
                reason = Reason.createTrueReason((String)Messages.UpdateChoreographyMessageFlowFeature_Message_Link_Changed);
            } else {
                shapeIds = ChoreographyUtil.getParticipantRefIds((ContainerShape)choreographyTaskShape);
                if (!shapeIds.equals(taskIds = ChoreographyUtil.getParticipantRefIds((ChoreographyActivity)choreographyTask))) {
                    reason = Reason.createTrueReason((String)Messages.UpdateChoreographyMessageFlowFeature_Participants_Changed);
                }
            }
        }
        return reason;
    }

    public boolean update(IUpdateContext context) {
        boolean result = false;
        PictogramElement pe = context.getPictogramElement();
        Diagram diagram = Graphiti.getPeService().getDiagramForPictogramElement(pe);
        BaseElement be = (BaseElement)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BaseElement.class);
        if (be instanceof ChoreographyTask) {
            result = this.update((ContainerShape)pe, (ChoreographyTask)be);
        } else if (ChoreographyUtil.isChoreographyMessage((PictogramElement)pe)) {
            int updates = 0;
            TreeIterator iter = be.eContainer().eAllContents();
            while (iter.hasNext()) {
                EObject eo = (EObject)iter.next();
                if (!(eo instanceof ChoreographyTask)) continue;
                ChoreographyTask choreographyTask = (ChoreographyTask)eo;
                for (MessageFlow mf : choreographyTask.getMessageFlowRef()) {
                    if (mf.getMessageRef() != be) continue;
                    for (PictogramElement cs : this.linkService.getPictogramElements(diagram, (EObject)choreographyTask)) {
                        if (!(cs instanceof ContainerShape) || !this.update((ContainerShape)cs, choreographyTask)) continue;
                        ++updates;
                    }
                }
            }
            result = updates > 0;
        }
        return result;
    }

    public boolean update(ContainerShape choreographyActivityShape, ChoreographyTask choreographyTask) {
        ArrayList<InteractionNode> sources = new ArrayList<InteractionNode>();
        for (MessageFlow message : choreographyTask.getMessageFlowRef()) {
            sources.add(message.getSourceRef());
        }
        for (ContainerShape band : FeatureSupport.getParticipantBandContainerShapes((ContainerShape)choreographyActivityShape)) {
            Participant participant = (Participant)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, Participant.class);
            BPMNShape bpmnShape = (BPMNShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)band, BPMNShape.class);
            if (!sources.contains(participant) && bpmnShape.isIsMessageVisible()) {
                bpmnShape.setIsMessageVisible(false);
                this.peService.setPropertyValue((PropertyContainer)choreographyActivityShape, "choreography.activity.band.message.visible", Boolean.toString(false));
                continue;
            }
            if (!sources.contains(participant) || bpmnShape.isIsMessageVisible()) continue;
            bpmnShape.setIsMessageVisible(true);
            this.peService.setPropertyValue((PropertyContainer)choreographyActivityShape, "choreography.activity.band.message.visible", Boolean.toString(true));
        }
        String choreoIds = ChoreographyUtil.getMessageRefIds((ChoreographyTask)choreographyTask);
        this.peService.setPropertyValue((PropertyContainer)choreographyActivityShape, "choreography.message.ref.ids", choreoIds);
        return true;
    }
}

