/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.event;

import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.event.AbstractUpdateEventFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.BoundaryEventPositionHelper;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ShapeDecoratorUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.features.event.BoundaryEventFeatureContainer;
import org.eclipse.bpmn2.modeler.ui.features.event.UpdateBoundaryEventFeature;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AddBoundaryEventFeature
extends AbstractBpmn2AddFeature<BoundaryEvent> {
    public static final String BOUNDARY_EVENT_RELATIVE_Y = "boundary.event.relative.y";
    private final IPeService peService = Graphiti.getPeService();
    private final IGaService gaService = Graphiti.getGaService();

    public AddBoundaryEventFeature(IFeatureProvider fp) {
        super(fp);
    }

    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp);
    }

    public boolean canAdd(IAddContext context) {
        if (!(this.getBusinessObject(context) instanceof BoundaryEvent)) {
            return false;
        }
        Object prop = context.getProperty((Object)"is.importing");
        if (prop != null && ((Boolean)prop).booleanValue()) {
            return true;
        }
        Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)context.getTargetContainer());
        return bo != null && bo instanceof Activity;
    }

    public PictogramElement add(IAddContext context) {
        ContainerShape target;
        BoundaryEvent businessObject = (BoundaryEvent)this.getBusinessObject(context);
        boolean isImport = context.getProperty((Object)"is.importing") != null;
        ContainerShape containerShape = target = isImport ? context.getTargetContainer() : (ContainerShape)context.getTargetContainer().eContainer();
        if (target == null) {
            target = context.getTargetContainer();
        }
        ContainerShape containerShape2 = this.peService.createContainerShape(target, true);
        Ellipse ellipse = this.gaService.createEllipse((GraphicsAlgorithmContainer)containerShape2);
        StyleUtil.applyStyle((GraphicsAlgorithm)ellipse, (BaseElement)businessObject);
        int width = this.getWidth(context);
        int height = this.getHeight(context);
        if (isImport) {
            this.gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, context.getX(), context.getY(), width, height);
        } else {
            GraphicsAlgorithm ga = context.getTargetContainer().getGraphicsAlgorithm();
            int x = ga.getX() + context.getX() - width / 2;
            int y = ga.getY() + context.getY() - height / 2;
            this.gaService.setLocationAndSize((GraphicsAlgorithm)ellipse, x, y, height, height);
        }
        Ellipse circle = ShapeDecoratorUtil.createIntermediateEventCircle((Ellipse)ellipse);
        circle.setStyle(StyleUtil.getStyleForClass((Diagram)this.getDiagram()));
        this.createDIShape((Shape)containerShape2, (BaseElement)businessObject, !isImport);
        Activity activity = businessObject.getAttachedToRef();
        PictogramElement foundElem = BusinessObjectUtil.getFirstBaseElementFromDiagram((Diagram)this.getDiagram(), (BaseElement)activity);
        if (foundElem != null && foundElem instanceof ContainerShape) {
            ContainerShape activityContainer = (ContainerShape)foundElem;
            BoundaryEventPositionHelper.PositionOnLine pos = BoundaryEventPositionHelper.getPositionOnLineUsingBPMNShape((Shape)containerShape2, (Shape)activityContainer);
            BoundaryEventPositionHelper.assignPositionOnLineProperty((PropertyContainer)containerShape2, (BoundaryEventPositionHelper.PositionOnLine)pos);
        }
        this.peService.setPropertyValue((PropertyContainer)containerShape2, BoundaryEventFeatureContainer.BOUNDARY_EVENT_CANCEL, Boolean.toString(businessObject.isCancelActivity()));
        this.peService.setPropertyValue((PropertyContainer)containerShape2, "event.marker.container", Boolean.toString(true));
        this.peService.setPropertyValue((PropertyContainer)containerShape2, UpdateBoundaryEventFeature.BOUNDARY_EVENT_MARKER, AbstractUpdateEventFeature.getEventDefinitionsValue((Event)businessObject));
        this.decorateShape(context, containerShape2, (BaseElement)businessObject);
        ChopboxAnchor anchor = this.peService.createChopboxAnchor((AnchorContainer)containerShape2);
        anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)ellipse);
        return containerShape2;
    }

    public Class getBusinessObjectType() {
        return BoundaryEvent.class;
    }
}

