/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.flow;

import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.Message;
import org.eclipse.bpmn2.MessageEventDefinition;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.bpmn2.Operation;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.ReceiveTask;
import org.eclipse.bpmn2.SendTask;
import org.eclipse.bpmn2.ServiceTask;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.di.DIImport;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2UpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.BaseElementConnectionFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.DefaultDeleteBPMNShapeFeature;
import org.eclipse.bpmn2.modeler.core.features.DefaultLayoutBPMNConnectionFeature;
import org.eclipse.bpmn2.modeler.core.features.MultiUpdateFeature;
import org.eclipse.bpmn2.modeler.core.features.choreography.ChoreographyUtil;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractAddFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractCreateFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.flow.AbstractReconnectFlowFeature;
import org.eclipse.bpmn2.modeler.core.features.label.UpdateLabelFeature;
import org.eclipse.bpmn2.modeler.core.model.ModelHandler;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.flow.Messages;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IReconnectionFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.AreaContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.styles.LineStyle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.util.IColorConstant;

public class MessageFlowFeatureContainer
extends BaseElementConnectionFeatureContainer {
    public static final String MESSAGE_REF = "message.ref";
    static final IPeService peService = Graphiti.getPeService();
    static final IGaService gaService = Graphiti.getGaService();

    public Object getApplyObject(IContext context) {
        Object object = super.getApplyObject(context);
        if (context instanceof IPictogramElementContext) {
            PictogramElement pe = ((IPictogramElementContext)context).getPictogramElement();
            if (ChoreographyUtil.isChoreographyMessageLink((PictogramElement)pe)) {
                return null;
            }
            MessageFlow mf = MessageFlowFeatureContainer.getMessageFlow(pe);
            if (mf != null) {
                return mf;
            }
        }
        return object;
    }

    public boolean canApplyTo(Object o) {
        return super.canApplyTo(o) && o instanceof MessageFlow;
    }

    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddMessageFlowFeature(fp);
    }

    public ICreateConnectionFeature getCreateConnectionFeature(IFeatureProvider fp) {
        return new CreateMessageFlowFeature(fp);
    }

    public IDeleteFeature getDeleteFeature(IFeatureProvider fp) {
        return new DeleteMessageFromMessageFlowFeature(fp);
    }

    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        MultiUpdateFeature multiUpdate = new MultiUpdateFeature(fp);
        multiUpdate.addFeature((IUpdateFeature)new UpdateMessageFlowFeature(fp));
        multiUpdate.addFeature((IUpdateFeature)new UpdateLabelFeature(fp));
        return multiUpdate;
    }

    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return new DefaultLayoutBPMNConnectionFeature(fp){

            public boolean layout(ILayoutContext context) {
                return super.layout(context);
            }
        };
    }

    public IReconnectionFeature getReconnectionFeature(IFeatureProvider fp) {
        return new ReconnectMessageFlowFeature(fp);
    }

    public static ContainerShape findMessageShape(Connection connection) {
        ConnectionDecorator d = MessageFlowFeatureContainer.findMessageDecorator(connection);
        if (d != null) {
            return (ContainerShape)BusinessObjectUtil.getFirstElementOfType((PictogramElement)d, ContainerShape.class);
        }
        return null;
    }

    public static MessageFlow getMessageFlow(PictogramElement pe) {
        if (pe instanceof ContainerShape) {
            String id = peService.getPropertyValue((PropertyContainer)pe, MESSAGE_REF);
            if (id != null && !id.isEmpty()) {
                EObject o = pe.eContainer();
                while (!(o instanceof Diagram)) {
                    o = o.eContainer();
                }
                if (o instanceof Diagram) {
                    Diagram diagram = (Diagram)o;
                    for (Connection connection : diagram.getConnections()) {
                        MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, MessageFlow.class);
                        if (messageFlow == null || !id.equals(messageFlow.getId())) continue;
                        return messageFlow;
                    }
                }
            }
        } else {
            if (pe instanceof Connection) {
                MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, MessageFlow.class);
                return messageFlow;
            }
            if (pe instanceof ConnectionDecorator) {
                pe = ((ConnectionDecorator)pe).getConnection();
                MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, MessageFlow.class);
                return messageFlow;
            }
        }
        return null;
    }

    protected static String messageToString(Message message) {
        if (message == null) {
            return "";
        }
        return message.getId();
    }

    protected static Connection getMessageFlowConnection(PictogramElement pe) {
        MessageFlow messageFlow;
        if (pe instanceof ContainerShape) {
            String id = peService.getPropertyValue((PropertyContainer)pe, MESSAGE_REF);
            if (id != null && !id.isEmpty()) {
                EObject o = pe.eContainer();
                while (!(o instanceof Diagram)) {
                    o = o.eContainer();
                }
                if (o instanceof Diagram) {
                    Diagram diagram = (Diagram)o;
                    for (Connection connection : diagram.getConnections()) {
                        MessageFlow messageFlow2 = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, MessageFlow.class);
                        if (messageFlow2 == null || !id.equals(messageFlow2.getId())) continue;
                        return connection;
                    }
                }
            }
        } else if (pe instanceof Connection ? (messageFlow = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, MessageFlow.class)) != null : pe instanceof ConnectionDecorator && (messageFlow = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)(pe = ((ConnectionDecorator)pe).getConnection()), MessageFlow.class)) != null) {
            return (Connection)pe;
        }
        return null;
    }

    protected static ConnectionDecorator findMessageDecorator(Connection connection) {
        for (ConnectionDecorator d : connection.getConnectionDecorators()) {
            if (Graphiti.getPeService().getPropertyValue((PropertyContainer)d, MESSAGE_REF) == null) continue;
            return d;
        }
        return null;
    }

    protected static boolean messageDecoratorMoved(Connection connection) {
        ContainerShape messageShape = MessageFlowFeatureContainer.findMessageShape(connection);
        if (messageShape != null) {
            ILocation loc = peService.getConnectionMidpoint(connection, 0.25);
            int w = 15;
            int h = 10;
            int x = loc.getX() - w;
            int y = loc.getY() - h;
            ILocation shapeLoc = peService.getLocationRelativeToDiagram((Shape)messageShape);
            return x != shapeLoc.getX() || y != shapeLoc.getY();
        }
        return false;
    }

    protected static void adjustMessageDecorator(IFeatureProvider fp, Connection connection) {
        ContainerShape messageShape = MessageFlowFeatureContainer.findMessageShape(connection);
        if (messageShape != null) {
            ILocation loc = peService.getConnectionMidpoint(connection, 0.25);
            int w = 15;
            int h = 10;
            int x = loc.getX() - w;
            int y = loc.getY() - h;
            MoveShapeContext moveContext = new MoveShapeContext((Shape)messageShape);
            moveContext.setX(x);
            moveContext.setY(y);
            IMoveShapeFeature moveFeature = fp.getMoveShapeFeature((IMoveShapeContext)moveContext);
            moveFeature.moveShape((IMoveShapeContext)moveContext);
        }
    }

    protected static void addMessageDecorator(IFeatureProvider fp, Connection connection, Message message, Shape messageShape) {
        ILocation loc = peService.getConnectionMidpoint(connection, 0.25);
        Diagram diagram = peService.getDiagramForPictogramElement((PictogramElement)connection);
        ConnectionDecorator decorator = peService.createConnectionDecorator(connection, true, 0.25, true);
        MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, MessageFlow.class);
        int w = 15;
        int h = 10;
        int x = loc.getX() - w;
        int y = loc.getY() - h;
        if (messageShape == null) {
            AddContext addContext = new AddContext((IAreaContext)new AreaContext(), (Object)message);
            addContext.putProperty((Object)"is.reference", (Object)Boolean.TRUE);
            addContext.setX(x);
            addContext.setY(y);
            addContext.setTargetContainer((ContainerShape)diagram);
            messageShape = (Shape)fp.addIfPossible((IAddContext)addContext);
        } else {
            MoveShapeContext moveContext = new MoveShapeContext(messageShape);
            moveContext.setLocation(x, y);
            moveContext.setSourceContainer(messageShape.getContainer());
            moveContext.setTargetContainer(messageShape.getContainer());
            IMoveShapeFeature moveFeature = fp.getMoveShapeFeature((IMoveShapeContext)moveContext);
            moveFeature.moveShape((IMoveShapeContext)moveContext);
        }
        fp.link((PictogramElement)decorator, new Object[]{message, messageShape});
        peService.setPropertyValue((PropertyContainer)decorator, MESSAGE_REF, "true");
        String id = messageFlow.getId();
        if (id == null || id.isEmpty()) {
            id = ModelUtil.setID((EObject)messageFlow);
        }
        peService.setPropertyValue((PropertyContainer)messageShape, MESSAGE_REF, id);
        messageFlow.setMessageRef(message);
    }

    protected static void removeMessageDecorator(IFeatureProvider fp, Connection connection) {
        ConnectionDecorator decorator = MessageFlowFeatureContainer.findMessageDecorator(connection);
        if (decorator != null) {
            ContainerShape messageShape = MessageFlowFeatureContainer.findMessageShape(connection);
            if (messageShape != null) {
                peService.removeProperty((PropertyContainer)messageShape, MESSAGE_REF);
                DeleteContext deleteContext = new DeleteContext((PictogramElement)messageShape);
                IDeleteFeature deleteFeature = fp.getDeleteFeature((IDeleteContext)deleteContext);
                deleteFeature.delete((IDeleteContext)deleteContext);
            }
            peService.deletePictogramElement((PictogramElement)decorator);
            MessageFlow mf = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, MessageFlow.class);
            mf.setMessageRef(null);
        }
    }

    public static class AddMessageFlowFeature
    extends AbstractAddFlowFeature<MessageFlow> {
        public AddMessageFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canAdd(IAddContext context) {
            IAddConnectionContext acc;
            if (context instanceof IAddConnectionContext && (acc = (IAddConnectionContext)context).getSourceAnchor() != null) {
                AnchorContainer pe = acc.getSourceAnchor().getParent();
                EObject source = BusinessObjectUtil.getFirstElementOfType((PictogramElement)pe, BaseElement.class);
                if (source instanceof EndEvent) {
                    List eventDefinitions = ((EndEvent)source).getEventDefinitions();
                    for (EventDefinition eventDefinition : eventDefinitions) {
                        if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                        return true;
                    }
                    return false;
                }
                if (source instanceof StartEvent) {
                    return false;
                }
            }
            return super.canAdd(context);
        }

        public PictogramElement add(IAddContext context) {
            Connection connection = (Connection)super.add(context);
            if (!DIImport.isImporting((IContext)context)) {
                Operation operation;
                BaseElement source = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection.getStart().getParent());
                BaseElement target = BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection.getEnd().getParent());
                Message message = null;
                if (source instanceof SendTask) {
                    message = ((SendTask)source).getMessageRef();
                } else if (target instanceof ReceiveTask) {
                    message = ((ReceiveTask)target).getMessageRef();
                } else if (source instanceof ServiceTask) {
                    operation = ((ServiceTask)source).getOperationRef();
                    if (operation != null) {
                        message = operation.getInMessageRef();
                    }
                } else if (target instanceof ServiceTask && (operation = ((ServiceTask)target).getOperationRef()) != null) {
                    message = operation.getOutMessageRef();
                }
                if (message != null) {
                    MessageFlow mf = (MessageFlow)BusinessObjectUtil.getFirstElementOfType((PictogramElement)connection, MessageFlow.class);
                    ExtendedPropertiesAdapter adapter = ExtendedPropertiesAdapter.adapt((EObject)mf);
                    adapter.getFeatureDescriptor((EStructuralFeature)Bpmn2Package.eINSTANCE.getMessageFlow_MessageRef()).setValue((Object)message);
                }
            }
            return connection;
        }

        protected Polyline createConnectionLine(Connection connection) {
            MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
            Polyline connectionLine = super.createConnectionLine(connection);
            connectionLine.setLineStyle(LineStyle.DASH);
            connectionLine.setLineWidth(Integer.valueOf(2));
            ConnectionDecorator endDecorator = peService.createConnectionDecorator(connection, false, 1.0, true);
            ConnectionDecorator startDecorator = peService.createConnectionDecorator(connection, false, 0.0, true);
            int w = 5;
            int l = 10;
            int[] nArray = new int[8];
            nArray[0] = -l;
            nArray[1] = w;
            nArray[4] = -l;
            nArray[5] = -w;
            nArray[6] = -l;
            nArray[7] = w;
            Polygon arrowhead = gaService.createPolygon((GraphicsAlgorithmContainer)endDecorator, nArray);
            StyleUtil.applyStyle((GraphicsAlgorithm)arrowhead, (BaseElement)messageFlow);
            arrowhead.setBackground(this.manageColor(IColorConstant.WHITE));
            Ellipse circle = gaService.createEllipse((GraphicsAlgorithmContainer)startDecorator);
            gaService.setSize((GraphicsAlgorithm)circle, 10, 10);
            StyleUtil.applyStyle((GraphicsAlgorithm)circle, (BaseElement)messageFlow);
            circle.setBackground(this.manageColor(IColorConstant.WHITE));
            return connectionLine;
        }

        public Class getBusinessObjectType() {
            return MessageFlow.class;
        }
    }

    public static class CreateMessageFlowFeature
    extends AbstractCreateFlowFeature<MessageFlow, InteractionNode, InteractionNode> {
        public CreateMessageFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean isAvailable(IContext context) {
            ICreateConnectionContext ccc;
            if (context instanceof ICreateConnectionContext && (ccc = (ICreateConnectionContext)context).getSourcePictogramElement() != null) {
                InteractionNode source = (InteractionNode)this.getSourceBo(ccc);
                if (source instanceof SubProcess) {
                    SubProcess subProcess = (SubProcess)source;
                    if (subProcess.isTriggeredByEvent()) {
                        return false;
                    }
                } else if (source instanceof EndEvent) {
                    List eventDefinitions = ((EndEvent)source).getEventDefinitions();
                    for (EventDefinition eventDefinition : eventDefinitions) {
                        if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                        return true;
                    }
                } else if (source instanceof StartEvent) {
                    return false;
                }
            }
            return super.isAvailable(context);
        }

        public boolean canStartConnection(ICreateConnectionContext context) {
            if (!super.canStartConnection(context)) {
                return false;
            }
            return !ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)context.getSourcePictogramElement());
        }

        public boolean canCreate(ICreateConnectionContext context) {
            PictogramElement sourcePE = context.getSourcePictogramElement();
            PictogramElement targetPE = context.getTargetPictogramElement();
            if (ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)sourcePE)) {
                return false;
            }
            if (targetPE != null && ChoreographyUtil.isChoreographyParticipantBand((PictogramElement)targetPE)) {
                return false;
            }
            if (sourcePE == targetPE) {
                return false;
            }
            InteractionNode source = (InteractionNode)this.getSourceBo(context);
            if (source instanceof EndEvent) {
                boolean allow = false;
                List eventDefinitions = ((EndEvent)source).getEventDefinitions();
                for (EventDefinition eventDefinition : eventDefinitions) {
                    if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                    allow = true;
                    break;
                }
                if (!allow) {
                    return false;
                }
            }
            InteractionNode target = (InteractionNode)this.getTargetBo(context);
            if (source instanceof ReceiveTask) {
                return false;
            }
            if (target instanceof SendTask) {
                return false;
            }
            return super.canCreate(context) && this.isDifferentParticipants(source, target);
        }

        protected String getStencilImageId() {
            return ImageProvider.IMG_16_MESSAGE_FLOW;
        }

        protected Class<InteractionNode> getSourceClass() {
            return InteractionNode.class;
        }

        protected Class<InteractionNode> getTargetClass() {
            return InteractionNode.class;
        }

        private boolean isDifferentParticipants(InteractionNode source, InteractionNode target) {
            if (source == null || target == null) {
                return true;
            }
            boolean different = false;
            ModelHandler mh = ModelHandler.getInstance((EObject)this.getDiagram());
            Participant sourceParticipant = mh.getParticipant((Object)source);
            Participant targetParticipant = mh.getParticipant((Object)target);
            if (sourceParticipant == null) {
                return targetParticipant != null;
            }
            different = !sourceParticipant.equals(targetParticipant);
            return different;
        }

        public EClass getBusinessObjectClass() {
            return Bpmn2Package.eINSTANCE.getMessageFlow();
        }
    }

    public static class DeleteMessageFromMessageFlowFeature
    extends DefaultDeleteBPMNShapeFeature {
        boolean canDeleteMessage = true;
        Connection messageFlowConnection;

        public DeleteMessageFromMessageFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canDelete(IDeleteContext context) {
            PictogramElement pe = context.getPictogramElement();
            return MessageFlowFeatureContainer.getMessageFlow(pe) != null;
        }

        public void delete(IDeleteContext context) {
            Message message = null;
            PictogramElement pe = context.getPictogramElement();
            if (pe instanceof ContainerShape) {
                ContainerShape messageShape = (ContainerShape)pe;
                this.messageFlowConnection = MessageFlowFeatureContainer.getMessageFlowConnection((PictogramElement)messageShape);
                message = (Message)BusinessObjectUtil.getFirstElementOfType((PictogramElement)messageShape, Message.class);
            } else if (pe instanceof Connection) {
                this.messageFlowConnection = (Connection)pe;
                MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstBaseElement((PictogramElement)this.messageFlowConnection);
                message = messageFlow.getMessageRef();
            }
            if (message != null) {
                List list = FeatureSupport.findMessageReferences((Diagram)this.getDiagram(), message);
                if (list.size() > 2) {
                    this.canDeleteMessage = false;
                }
                if (this.canDeleteMessage) {
                    EcoreUtil.delete((EObject)message, (boolean)true);
                }
                MessageFlowFeatureContainer.removeMessageDecorator(this.getFeatureProvider(), this.messageFlowConnection);
            }
            super.delete(context);
        }

        protected void deleteBusinessObject(Object bo) {
            if (bo instanceof Message && !this.canDeleteMessage) {
                return;
            }
            super.deleteBusinessObject(bo);
        }

        public void postDelete(IDeleteContext context) {
            MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstBaseElement((PictogramElement)this.messageFlowConnection);
            if (messageFlow != null) {
                messageFlow.setMessageRef(null);
                peService.setPropertyValue((PropertyContainer)this.messageFlowConnection, MessageFlowFeatureContainer.MESSAGE_REF, "");
            }
        }
    }

    public static class ReconnectMessageFlowFeature
    extends AbstractReconnectFlowFeature {
        public ReconnectMessageFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        protected Class<? extends EObject> getTargetClass() {
            return InteractionNode.class;
        }

        protected Class<? extends EObject> getSourceClass() {
            return InteractionNode.class;
        }
    }

    public static class UpdateMessageFlowFeature
    extends AbstractBpmn2UpdateFeature {
        public UpdateMessageFlowFeature(IFeatureProvider fp) {
            super(fp);
        }

        public boolean canUpdate(IUpdateContext context) {
            return true;
        }

        public IReason updateNeeded(IUpdateContext context) {
            if (context.getPictogramElement() instanceof Connection) {
                String newMessageRef;
                Connection connection = (Connection)context.getPictogramElement();
                MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
                String oldMessageRef = peService.getPropertyValue((PropertyContainer)connection, MessageFlowFeatureContainer.MESSAGE_REF);
                if (oldMessageRef == null) {
                    oldMessageRef = "";
                }
                if (!oldMessageRef.equals(newMessageRef = MessageFlowFeatureContainer.messageToString(messageFlow.getMessageRef()))) {
                    return Reason.createTrueReason((String)Messages.MessageFlowFeatureContainer_Ref_Changed);
                }
                if (MessageFlowFeatureContainer.messageDecoratorMoved(connection)) {
                    return Reason.createTrueReason((String)Messages.MessageFlowFeatureContainer_Decorator_Moved);
                }
            }
            return super.updateNeeded(context);
        }

        public boolean update(IUpdateContext context) {
            String newMessageRef;
            Connection connection = (Connection)context.getPictogramElement();
            MessageFlow messageFlow = (MessageFlow)BusinessObjectUtil.getFirstBaseElement((PictogramElement)connection);
            Message message = messageFlow.getMessageRef();
            String oldMessageRef = peService.getPropertyValue((PropertyContainer)connection, MessageFlowFeatureContainer.MESSAGE_REF);
            if (oldMessageRef == null) {
                oldMessageRef = "";
            }
            if (!oldMessageRef.equals(newMessageRef = MessageFlowFeatureContainer.messageToString(messageFlow.getMessageRef()))) {
                MessageFlowFeatureContainer.removeMessageDecorator(this.getFeatureProvider(), connection);
                if (message != null) {
                    Shape messageShape = (Shape)context.getProperty((Object)MessageFlowFeatureContainer.MESSAGE_REF);
                    MessageFlowFeatureContainer.addMessageDecorator(this.getFeatureProvider(), connection, message, messageShape);
                }
                peService.setPropertyValue((PropertyContainer)connection, MessageFlowFeatureContainer.MESSAGE_REF, newMessageRef);
            } else {
                MessageFlowFeatureContainer.adjustMessageDecorator(this.getFeatureProvider(), connection);
            }
            return true;
        }
    }
}

