/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property;

import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.runtime.CustomTaskDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.util.PropertyUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class PropertyLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        EObject object = this.getBusinessObject(element);
        if (object != null) {
            CustomTaskDescriptor ctd = this.getCustomTaskDescriptor(object);
            if (ctd != null) {
                return PropertyUtil.getImage("CustomTask");
            }
            return PropertyUtil.getImage(object);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        EObject object = this.getBusinessObject(element);
        if (object != null) {
            String name;
            String text = ExtendedPropertiesProvider.getTextValue((EObject)object);
            CustomTaskDescriptor ctd = this.getCustomTaskDescriptor(object);
            if (ctd != null && !text.equals(name = ctd.getName())) {
                return String.valueOf(name) + ": " + text;
            }
            return text;
        }
        return super.getText(element);
    }

    private EObject getBusinessObject(Object element) {
        if (element instanceof ISelection) {
            return BusinessObjectUtil.getBusinessObjectForSelection((ISelection)((ISelection)element));
        }
        if (element instanceof EObject) {
            return (EObject)element;
        }
        return null;
    }

    private CustomTaskDescriptor getCustomTaskDescriptor(EObject object) {
        TargetRuntime rt = this.getTargetRuntime(object);
        if (rt != null) {
            for (CustomTaskDescriptor ctd : rt.getCustomTaskDescriptors()) {
                if (ctd.getFeatureContainer() == null) continue;
                String id = ctd.getFeatureContainer().getId(object);
                if (!ctd.getId().equals(id)) continue;
                return ctd;
            }
        }
        return null;
    }

    private TargetRuntime getTargetRuntime(EObject object) {
        DiagramEditor editor = ModelUtil.getDiagramEditor((EObject)object);
        if (editor != null) {
            return (TargetRuntime)editor.getAdapter(TargetRuntime.class);
        }
        return null;
    }
}

