/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.wizards;

import java.io.File;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.utils.FileUtils;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.Bpmn2DiagramEditorInput;
import org.eclipse.bpmn2.modeler.ui.editor.BPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.editor.DefaultBPMN2Editor;
import org.eclipse.bpmn2.modeler.ui.wizards.FileService;
import org.eclipse.bpmn2.modeler.ui.wizards.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class BPMN2DiagramCreator {
    public static Bpmn2DiagramEditorInput createDiagram(URI uri, ModelUtil.Bpmn2DiagramType diagramType, String targetNamespace) throws CoreException {
        return BPMN2DiagramCreator.createDiagram(null, uri, diagramType, targetNamespace, null);
    }

    public static Bpmn2DiagramEditorInput createDiagram(IEditorInput oldInput, URI modelUri, ModelUtil.Bpmn2DiagramType diagramType, String targetNamespace, DefaultBPMN2Editor diagramEditor) {
        Bpmn2DiagramEditorInput newInput;
        boolean createNew = true;
        URI diagramUri = null;
        BPMN2Editor otherEditor = BPMN2Editor.findOpenEditor((IEditorPart)diagramEditor, oldInput);
        String modelName = modelUri.trimFragment().trimFileExtension().lastSegment();
        Diagram diagram = DIUtils.createDiagram((String)modelName);
        if (otherEditor != null) {
            diagramUri = otherEditor.getDiagramUri();
            createNew = false;
        } else {
            URI oldUri;
            File oldTempFile;
            if (oldInput instanceof Bpmn2DiagramEditorInput && (oldTempFile = new File((oldUri = ((Bpmn2DiagramEditorInput)oldInput).getUri()).toFileString())) != null && oldTempFile.exists()) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            oldTempFile.delete();
                        }
                        catch (Exception exception) {}
                    }
                });
            }
            String diagramName = FileUtils.createTempName((String)modelName);
            diagramUri = URI.createFileURI((String)diagramName);
            FileService.createEmfFileForDiagram(diagramUri, diagram, diagramEditor);
        }
        String providerId = GraphitiUi.getExtensionManager().getDiagramTypeProviderId(diagram.getDiagramTypeId());
        if (oldInput instanceof Bpmn2DiagramEditorInput) {
            newInput = (Bpmn2DiagramEditorInput)oldInput;
            newInput.updateUri(diagramUri);
        } else {
            newInput = createNew ? new Bpmn2DiagramEditorInput(modelUri, diagramUri, providerId) : (Bpmn2DiagramEditorInput)otherEditor.getEditorInput();
        }
        newInput.setInitialDiagramType(diagramType);
        newInput.setTargetNamespace(targetNamespace);
        if (diagramEditor == null) {
            BPMN2DiagramCreator.openEditor(newInput);
        }
        return newInput;
    }

    public static IEditorPart openEditor(final DiagramEditorInput editorInput) {
        final Object[] result = new Object[]{new Object()};
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart part = null;
                    part = page.findEditor((IEditorInput)editorInput);
                    if (part != null) {
                        page.activate((IWorkbenchPart)part);
                    } else {
                        part = page.openEditor((IEditorInput)editorInput, "org.eclipse.bpmn2.modeler.ui.bpmn2editor");
                    }
                    result[0] = part;
                }
                catch (PartInitException e) {
                    String error = Messages.BPMN2DiagramCreator_Create_Error;
                    Status status = new Status(4, "org.eclipse.bpmn2.modeler.ui", error, (Throwable)e);
                    ErrorUtils.showErrorWithLogging((IStatus)status);
                }
            }
        });
        return (IEditorPart)result[0];
    }
}

