/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.query.ui.UiConstants;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;
import org.teiid.query.ui.builder.util.BuilderUtils;

public abstract class AbstractLanguageObjectEditorModel
implements ILanguageObjectEditorModel,
UiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(AbstractLanguageObjectEditorModel.class);
    private ILanguageObject savedLangObj;
    private List<ILanguageObjectEditorModelListener> listeners;
    protected boolean notifyListeners = true;
    private Class modelType;

    public AbstractLanguageObjectEditorModel(Class theType) {
        this.setModelType(theType);
    }

    @Override
    public boolean addModelListener(ILanguageObjectEditorModelListener theListener) {
        CoreArgCheck.isNotNull((Object)theListener);
        boolean result = false;
        if (this.listeners == null) {
            this.listeners = new ArrayList<ILanguageObjectEditorModelListener>();
        }
        if (!this.listeners.contains(theListener)) {
            result = this.listeners.add(theListener);
        }
        return result;
    }

    @Override
    public void clear() {
        if (this.savedLangObj != null) {
            this.savedLangObj = null;
            this.fireModelChanged("SAVED");
        }
    }

    protected void fireModelChanged(String theType) {
        if (this.notifyListeners && this.listeners != null) {
            LanguageObjectEditorModelEvent event = new LanguageObjectEditorModelEvent(this, theType);
            int size = this.listeners.size();
            int i = 0;
            while (i < size) {
                ILanguageObjectEditorModelListener listener = this.listeners.get(i);
                listener.modelChanged(event);
                ++i;
            }
        }
    }

    @Override
    public abstract ILanguageObject getLanguageObject();

    @Override
    public Class getModelType() {
        return this.modelType;
    }

    protected ILanguageObject getSavedLanguageObject() {
        return this.savedLangObj;
    }

    @Override
    public boolean hasChanged() {
        boolean complete;
        boolean result = false;
        result = this.savedLangObj == null ? this.isComplete() : ((complete = this.isComplete()) ? !this.savedLangObj.equals(this.getLanguageObject()) : false);
        return result;
    }

    @Override
    public abstract boolean isComplete();

    @Override
    public boolean removeModelListener(ILanguageObjectEditorModelListener theListener) {
        CoreArgCheck.isNotNull((Object)theListener);
        boolean result = false;
        if (this.listeners != null) {
            result = this.listeners.remove(theListener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
        return result;
    }

    @Override
    public void reset() {
        this.setLanguageObject(this.savedLangObj);
    }

    @Override
    public void save() {
        this.savedLangObj = this.getLanguageObject();
        this.fireModelChanged("SAVED");
    }

    @Override
    public void setLanguageObject(ILanguageObject theLangObj) {
        if (theLangObj != null && !this.modelType.isAssignableFrom(theLangObj.getClass())) {
            CoreArgCheck.isTrue((boolean)this.modelType.isAssignableFrom(theLangObj.getClass()), (String)Util.getString(String.valueOf(PREFIX) + "wrongLangObjType", new Object[]{theLangObj.getClass().getName(), this.modelType.getName()}));
        }
        this.savedLangObj = theLangObj == null ? theLangObj : BuilderUtils.getBuilderLanguageObject(theLangObj);
    }

    @Override
    public void setModelType(Class theLanguageObjectClass) {
        CoreArgCheck.isNotNull((Object)theLanguageObjectClass, (String)(String.valueOf(PREFIX) + "nullType"));
        CoreArgCheck.isTrue((boolean)ILanguageObject.class.isAssignableFrom(theLanguageObjectClass), (String)(String.valueOf(PREFIX) + "modelTypeNotLangObj"));
        this.modelType = theLanguageObjectClass;
    }
}

