/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.query.ui.builder.model.AbstractLanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public abstract class CompositeLanguageObjectEditorModel
extends AbstractLanguageObjectEditorModel {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(CompositeLanguageObjectEditorModel.class);
    public static final String MODEL_CHANGE = "MODEL_CHANGE";
    private ILanguageObjectEditorModel currentModel;
    private ModelListener listener;
    private List models;

    public CompositeLanguageObjectEditorModel(Class theLanguageObjectType) {
        super(theLanguageObjectType);
    }

    protected void addModel(ILanguageObjectEditorModel theModel) {
        if (this.models == null) {
            this.models = new ArrayList();
            this.listener = new ModelListener();
        }
        this.models.add(theModel);
        theModel.addModelListener(this.listener);
        if (this.currentModel == null) {
            this.currentModel = theModel;
        }
    }

    public ILanguageObjectEditorModel getCurrentModel() {
        CoreArgCheck.isNotNull((Object)this.models, (String)Util.getString(String.valueOf(PREFIX) + "noModelsFound", new Object[]{"getCurrentModel"}));
        return this.currentModel;
    }

    @Override
    public ILanguageObject getLanguageObject() {
        CoreArgCheck.isNotNull((Object)this.models, (String)Util.getString(String.valueOf(PREFIX) + "noModelsFound", new Object[]{"getLanguageObject"}));
        ILanguageObject langObj = null;
        if (this.currentModel != null) {
            langObj = this.currentModel.getLanguageObject();
        }
        return langObj;
    }

    protected void handleModelChanged(LanguageObjectEditorModelEvent theEvent) {
        Object source = theEvent.getSource();
        if (source == this.currentModel) {
            this.fireModelChanged(theEvent.getType());
        }
    }

    @Override
    public boolean isComplete() {
        boolean complete;
        CoreArgCheck.isNotNull((Object)this.models, (String)Util.getString(String.valueOf(PREFIX) + "noModelsFound", new Object[]{"isComplete"}));
        if (this.getCurrentModel() == null) {
            complete = false;
        } else {
            ILanguageObjectEditorModel model = this.getCurrentModel();
            complete = model.isComplete();
        }
        return complete;
    }

    @Override
    public void save() {
        super.save();
        this.currentModel.save();
        int size = this.models.size();
        int i = 0;
        while (i < size) {
            ILanguageObjectEditorModel iLanguageObjectEditorModel = (ILanguageObjectEditorModel)this.models.get(i);
            ++i;
        }
    }

    public void setCurrentModel(ILanguageObjectEditorModel theModel) {
        if (this.models == null) {
            CoreArgCheck.isNotNull((Object)this.models, (String)Util.getString(String.valueOf(PREFIX) + "noModelsFound", new Object[]{"setCurrentModel"}));
        }
        CoreArgCheck.contains((Collection)this.models, (Object)theModel);
        if (this.currentModel == null || this.currentModel != theModel) {
            this.currentModel = theModel;
            this.fireModelChanged(MODEL_CHANGE);
        }
    }

    @Override
    public void setLanguageObject(ILanguageObject theLangObj) {
        CoreArgCheck.isNotNull((Object)this.models, (String)Util.getString(String.valueOf(PREFIX) + "noModelsFound", new Object[]{"setLanguageObject"}));
        super.setLanguageObject(theLangObj);
        ILanguageObject langObj = this.getSavedLanguageObject();
        ILanguageObjectEditorModel newModel = null;
        if (langObj == null) {
            newModel = (ILanguageObjectEditorModel)this.models.get(0);
        } else {
            Class<?> langObjType = langObj.getClass();
            int size = this.models.size();
            int i = 0;
            while (i < size) {
                ILanguageObjectEditorModel model = (ILanguageObjectEditorModel)this.models.get(i);
                if (model.getModelType().isAssignableFrom(langObjType)) {
                    newModel = model;
                    break;
                }
                ++i;
            }
            if (newModel == null) {
                return;
            }
        }
        if (newModel == this.currentModel) {
            this.currentModel.setLanguageObject(langObj);
        } else {
            newModel.setLanguageObject(langObj);
            this.setCurrentModel(newModel);
        }
    }

    class ModelListener
    implements ILanguageObjectEditorModelListener {
        ModelListener() {
        }

        @Override
        public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
            CompositeLanguageObjectEditorModel.this.handleModelChanged(theEvent);
        }
    }
}

