/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.query.ui.builder.model.AbstractLanguageObjectEditorModel;

public class ElementEditorModel
extends AbstractLanguageObjectEditorModel {
    private IElementSymbol selectedElement;

    public ElementEditorModel() {
        super(IElementSymbol.class);
    }

    @Override
    public void clear() {
        this.selectedElement = null;
        super.clear();
    }

    public IElementSymbol getElementSymbol() {
        return (IElementSymbol)this.getLanguageObject();
    }

    @Override
    public ILanguageObject getLanguageObject() {
        return this.selectedElement;
    }

    @Override
    public boolean isComplete() {
        return this.selectedElement != null;
    }

    public boolean selectElementSymbol(IElementSymbol theElement) {
        boolean changed = false;
        if (this.selectedElement == null) {
            changed = theElement != null;
        } else {
            boolean bl = theElement == null ? true : (changed = !this.selectedElement.equals(theElement));
        }
        if (changed) {
            this.selectedElement = theElement;
            this.fireModelChanged("STATE_CHANGE");
        }
        return changed;
    }

    private void setElementSymbol(IElementSymbol theElement) {
        if (theElement == null) {
            this.clear();
        } else {
            this.notifyListeners = false;
            if (this.selectElementSymbol(theElement)) {
                this.notifyListeners = true;
                this.fireModelChanged("SAVED");
            }
            this.notifyListeners = true;
        }
    }

    @Override
    public void setLanguageObject(ILanguageObject theLangObj) {
        super.setLanguageObject(theLangObj);
        this.setElementSymbol((IElementSymbol)theLangObj);
    }
}

