/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.udf.IFunctionForm;
import org.teiid.designer.udf.IFunctionLibrary;
import org.teiid.designer.udf.UdfManager;
import org.teiid.query.ui.builder.model.AbstractLanguageObjectEditorModel;
import org.teiid.query.ui.builder.util.BuilderUtils;

public class FunctionEditorModel
extends AbstractLanguageObjectEditorModel {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(FunctionEditorModel.class);
    private static final String NONE = Util.getString(String.valueOf(PREFIX) + "none", new Object[0]);
    public static final String CATEGORY = "CATEGORY";
    public static final String SELECTED_FUNCTION = "SELECTED_FUNCTION";
    private List argNames;
    private List argValues;
    private String[] categories;
    private String category;
    private String[] functions;
    private IFunctionForm[] functionForms;
    private static String defaultCategory;
    private IFunctionLibrary funcLib;
    private IFunctionForm selectedFunctionForm;

    public FunctionEditorModel() {
        super(IFunction.class);
        this.getCategories();
    }

    @Override
    public void clear() {
        this.argNames = null;
        this.argValues = null;
        this.selectedFunctionForm = null;
        super.clear();
    }

    private IFunctionForm findFunctionForm(String theFunctionName) {
        IFunctionForm result = null;
        if (this.functionForms != null) {
            int i = 0;
            while (i < this.functionForms.length) {
                if (this.functionForms[i].getDisplayString().equals(theFunctionName)) {
                    result = this.functionForms[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public String[] getCategories() {
        Object[] temp;
        this.categories = null;
        this.funcLib = UdfManager.getInstance().getFunctionLibrary();
        List list = this.funcLib.getFunctionCategories();
        if (list != null && !list.isEmpty() && (temp = list.toArray()) != null && temp.length > 0) {
            this.categories = new String[temp.length];
            int i = 0;
            while (i < this.categories.length) {
                this.categories[i] = temp[i].toString();
                ++i;
            }
        }
        if (this.categories == null) {
            this.categories = new String[1];
            this.categories[0] = NONE;
        }
        defaultCategory = this.categories[0];
        return this.categories;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDefaultCategory() {
        return defaultCategory;
    }

    public IFunction getFunction() {
        return (IFunction)this.getLanguageObject();
    }

    @Override
    public ILanguageObject getLanguageObject() {
        if (!this.isComplete()) {
            return null;
        }
        int numArgs = this.argValues.size();
        ArrayList<IExpression> args = new ArrayList<IExpression>();
        int i = 0;
        while (i < numArgs) {
            args.add((IExpression)this.argValues.get(i));
            ++i;
        }
        IQueryService service = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = service.createQueryFactory();
        return factory.createFunction(this.selectedFunctionForm.getName(), args);
    }

    private Object getFunctionArgValue(String theFunctionName, String theArgName, Object theProposedValue) {
        Object result = theProposedValue;
        if (BuilderUtils.isConversionTypeArg(theFunctionName, theArgName)) {
            result = theProposedValue instanceof IConstant && BuilderUtils.isConversionTypeConstant(theProposedValue) ? theProposedValue : BuilderUtils.createConversionTypeConstant();
        }
        return result;
    }

    public String[] getFunctions() {
        return this.functions;
    }

    public List getFunctionArgNames() {
        return this.argNames;
    }

    public String getFunctionDescription() {
        return this.selectedFunctionForm == null ? null : this.selectedFunctionForm.getDescription();
    }

    public String getFunctionName() {
        return this.selectedFunctionForm == null ? null : this.selectedFunctionForm.getDisplayString();
    }

    public List getFunctionArgValues() {
        return this.argValues;
    }

    @Override
    public boolean isComplete() {
        return this.selectedFunctionForm != null;
    }

    public boolean isValid() {
        boolean result = this.isComplete();
        if (result) {
            int size = this.argValues.size();
            int i = 0;
            while (i < size) {
                if (this.argValues.get(i) == null) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void setCategory(String theCategory) {
        if (theCategory != null) {
            boolean changeCategory = true;
            if (this.category == null) {
                changeCategory = true;
            } else if (this.category.toUpperCase() != null && this.category.equals(theCategory.toUpperCase())) {
                changeCategory = false;
            }
            if (changeCategory) {
                this.category = theCategory;
                this.functions = null;
                this.functionForms = null;
                this.selectedFunctionForm = null;
                List forms = this.funcLib.getFunctionForms(this.category);
                if (forms != null && !forms.isEmpty()) {
                    HashSet<String> filteredDisplayStrings = new HashSet<String>();
                    for (IFunctionForm iForm : forms) {
                        String displayString = iForm.getDisplayString();
                        filteredDisplayStrings.add(displayString);
                    }
                    ArrayList filteredList = new ArrayList(filteredDisplayStrings);
                    Collections.sort(filteredList);
                    this.functions = filteredList.toArray(new String[filteredList.size()]);
                    int size = forms.size();
                    this.functionForms = new IFunctionForm[size];
                    int i = 0;
                    while (i < size) {
                        this.functionForms[i] = (IFunctionForm)forms.get(i);
                        ++i;
                    }
                } else {
                    this.functionForms = new IFunctionForm[1];
                    this.functions = new String[1];
                    this.functions[0] = NONE;
                }
                this.fireModelChanged(CATEGORY);
            }
        }
    }

    private void setFunction(IFunction theFunction) {
        this.notifyListeners = false;
        if (theFunction == null) {
            this.clear();
        } else {
            IExpression[] newArgValues = theFunction.getArgs();
            IFunctionForm functionForm = this.funcLib.findFunctionForm(theFunction.getName(), newArgValues.length);
            if (functionForm != null) {
                this.setCategory(functionForm.getCategory());
                this.setFunctionName(functionForm.getDisplayString());
            }
            this.argValues = Arrays.asList(newArgValues);
        }
        this.notifyListeners = true;
        this.fireModelChanged("SAVED");
    }

    public void setFunctionArgValue(IExpression theValue, int theIndex) {
        CoreArgCheck.isNotNull((Object)this.argValues);
        this.argValues.set(theIndex, theValue);
    }

    public void setFunctionName(String theName) {
        IFunctionForm functionForm = this.findFunctionForm(theName);
        CoreArgCheck.isNotNull((Object)functionForm);
        if (this.selectedFunctionForm == null || !this.selectedFunctionForm.equals(functionForm)) {
            this.selectedFunctionForm = functionForm;
            List prevArgValues = this.argValues;
            int prevNumArgs = prevArgValues == null ? 0 : prevArgValues.size();
            this.argNames = this.selectedFunctionForm.getArgNames();
            this.argValues = new ArrayList(this.argNames.size());
            String functionName = this.selectedFunctionForm.getName();
            int numArgs = this.argNames.size();
            int i = 0;
            while (i < numArgs) {
                String argName = (String)this.argNames.get(i);
                Object value = null;
                if (i < prevNumArgs) {
                    Object arg = prevArgValues.get(i);
                    if (!BuilderUtils.isConversionTypeConstant(arg) && !BuilderUtils.isConversionTypeArg(functionName, argName)) {
                        value = this.getFunctionArgValue(functionName, argName, arg);
                    } else if (BuilderUtils.isConversionTypeConstant(arg) && BuilderUtils.isConversionTypeArg(functionName, argName)) {
                        value = this.getFunctionArgValue(functionName, argName, arg);
                    }
                }
                if (value == null) {
                    value = this.getFunctionArgValue(functionName, argName, null);
                }
                this.argValues.add(value);
                ++i;
            }
            this.fireModelChanged(SELECTED_FUNCTION);
        }
    }

    @Override
    public void setLanguageObject(ILanguageObject theLangObj) {
        super.setLanguageObject(theLangObj);
        this.setFunction((IFunction)theLangObj);
    }
}

