/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.model;

import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryFactory;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.IMatchCriteria;
import org.teiid.query.ui.builder.model.AbstractPredicateCriteriaTypeEditorModel;
import org.teiid.query.ui.builder.model.CriteriaExpressionEditorModel;
import org.teiid.query.ui.builder.model.ILanguageObjectEditorModelListener;
import org.teiid.query.ui.builder.model.LanguageObjectEditorModelEvent;

public class MatchCriteriaEditorModel
extends AbstractPredicateCriteriaTypeEditorModel
implements ILanguageObjectEditorModelListener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(MatchCriteriaEditorModel.class);
    private static final String[] OPERATORS = new String[]{Util.getString(String.valueOf(PREFIX) + "like", new Object[0])};
    public static final String LEFT_EXPRESSION = "MATCH CRITERIA LEFT EXPRESSION";
    public static final String RIGHT_EXPRESSION = "MATCH CRITERIA RIGHT EXPRESSION";
    public static final String ESCAPE_CHAR = "MATCH CRITERIA ESCAPE CHAR";
    private final IMatchCriteria emptyMatchCriteria;
    private CriteriaExpressionEditorModel leftExpModel;
    private CriteriaExpressionEditorModel rightExpModel;
    private char escapeChar;

    public MatchCriteriaEditorModel(CriteriaExpressionEditorModel left, CriteriaExpressionEditorModel right) {
        super(IMatchCriteria.class);
        this.leftExpModel = left;
        this.rightExpModel = right;
        this.leftExpModel.addModelListener(this);
        this.rightExpModel.addModelListener(this);
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        this.emptyMatchCriteria = factory.createMatchCriteria();
    }

    public MatchCriteriaEditorModel() {
        this(new CriteriaExpressionEditorModel(), new CriteriaExpressionEditorModel());
    }

    @Override
    public ILanguageObject getLanguageObject() {
        IQueryService queryService = ModelerCore.getTeiidQueryService();
        IQueryFactory factory = queryService.createQueryFactory();
        IMatchCriteria matchCriteria = factory.createMatchCriteria();
        matchCriteria.setLeftExpression(this.leftExpModel.getExpression());
        matchCriteria.setRightExpression(this.rightExpModel.getExpression());
        matchCriteria.setEscapeChar(this.escapeChar);
        return matchCriteria;
    }

    public void setEscapeChar(char escChar) {
        boolean same;
        boolean bl = same = this.escapeChar == escChar;
        if (!same) {
            this.escapeChar = escChar;
            this.fireModelChanged(ESCAPE_CHAR);
        }
    }

    public char getEscapeChar() {
        return this.escapeChar;
    }

    @Override
    public void setLanguageObject(ILanguageObject obj) {
        super.setLanguageObject(obj);
        if (obj == null) {
            this.clear();
        } else {
            IMatchCriteria curMatchCriteria = (IMatchCriteria)obj;
            IExpression newLeftExpression = curMatchCriteria.getLeftExpression();
            this.setLeftExpression(newLeftExpression);
            IExpression newRightExpression = curMatchCriteria.getRightExpression();
            this.setRightExpression(newRightExpression);
            char newEscapeChar = curMatchCriteria.getEscapeChar();
            this.setEscapeChar(newEscapeChar);
        }
    }

    @Override
    public void clear() {
        this.notifyListeners = false;
        this.setLeftExpression(this.emptyMatchCriteria.getLeftExpression());
        this.setRightExpression(this.emptyMatchCriteria.getRightExpression());
        this.setEscapeChar(this.emptyMatchCriteria.getEscapeChar());
        this.notifyListeners = true;
        super.clear();
    }

    @Override
    public void save() {
        super.save();
        this.leftExpModel.save();
        this.rightExpModel.save();
    }

    @Override
    public IExpression getLeftExpression() {
        return this.leftExpModel.getExpression();
    }

    @Override
    public void setLeftExpression(IExpression exp) {
        IExpression oldExp = this.leftExpModel.getExpression();
        boolean same = exp == null ? oldExp == null : exp.equals(oldExp);
        if (!same) {
            this.leftExpModel.setLanguageObject((ILanguageObject)exp);
        }
    }

    @Override
    public IExpression getRightExpression() {
        return this.rightExpModel.getExpression();
    }

    @Override
    public void setRightExpression(IExpression exp) {
        IExpression oldExp = this.rightExpModel.getExpression();
        boolean same = exp == null ? oldExp == null : exp.equals(oldExp);
        if (!same) {
            this.rightExpModel.setLanguageObject((ILanguageObject)exp);
        }
    }

    @Override
    public void modelChanged(LanguageObjectEditorModelEvent theEvent) {
        Object source;
        String type = theEvent.getType();
        String eventType = type.equals("MODEL_CHANGE") ? type : ((source = theEvent.getSource()) == this.leftExpModel ? LEFT_EXPRESSION : RIGHT_EXPRESSION);
        this.fireModelChanged(eventType);
    }

    @Override
    public boolean isComplete() {
        boolean complete = this.leftExpModel.isComplete() && this.rightExpModel.isComplete();
        return complete;
    }

    public CriteriaExpressionEditorModel getLeftExpressionModel() {
        return this.leftExpModel;
    }

    public CriteriaExpressionEditorModel getRightExpressionModel() {
        return this.rightExpModel;
    }

    @Override
    public String[] getOperators() {
        return OPERATORS;
    }

    @Override
    public String getCurrentOperator() {
        return OPERATORS[0];
    }

    @Override
    public void setCurrentOperator(String op) {
    }
}

