/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.builder.util;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.IQueryService;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.lang.ICompoundCriteria;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.lang.INotCriteria;
import org.teiid.designer.query.sql.lang.IPredicateCriteria;
import org.teiid.designer.query.sql.symbol.IConstant;
import org.teiid.designer.query.sql.symbol.IFunction;
import org.teiid.designer.query.sql.symbol.IReference;
import org.teiid.query.ui.UiConstants;
import org.teiid.query.ui.UiPlugin;

public class LanguageObjectLabelProvider
extends LabelProvider
implements UiConstants {
    private static final Image COMPOUND_CRITERIA_IMAGE;
    private static final Image CONSTANT_IMAGE;
    private static final Image FUNCTION_IMAGE;
    private static final Image PREDICATE_IMAGE;
    private static final Image REFERENCE_IMAGE;
    private static final Image UNDEFINED_IMAGE;

    static {
        UiPlugin plugin = UiPlugin.getDefault();
        COMPOUND_CRITERIA_IMAGE = plugin.getImage("icons/full/obj16/compoundCriteriaLangObj.gif");
        CONSTANT_IMAGE = plugin.getImage("icons/full/obj16/constantLangObj.gif");
        FUNCTION_IMAGE = plugin.getImage("icons/full/obj16/functionLangObj.gif");
        PREDICATE_IMAGE = plugin.getImage("icons/full/obj16/predicateCriteriaLangObj.gif");
        REFERENCE_IMAGE = plugin.getImage("icons/full/obj16/referenceLangObj.gif");
        UNDEFINED_IMAGE = plugin.getImage("icons/full/obj16/undefinedLangObj.gif");
    }

    public Image getImage(Object theElement) {
        Image result = null;
        result = theElement instanceof IConstant ? CONSTANT_IMAGE : (theElement instanceof ILanguageObject && theElement instanceof IFunction ? FUNCTION_IMAGE : (theElement instanceof IPredicateCriteria ? PREDICATE_IMAGE : (theElement instanceof ICompoundCriteria ? COMPOUND_CRITERIA_IMAGE : (theElement instanceof INotCriteria ? this.getNotCriteriaIcon((INotCriteria)theElement) : (theElement instanceof IReference ? REFERENCE_IMAGE : UNDEFINED_IMAGE)))));
        return result;
    }

    private Image getNotCriteriaIcon(INotCriteria theCriteria) {
        Image result = null;
        ICriteria crit = theCriteria.getCriteria();
        if (crit instanceof IPredicateCriteria) {
            result = PREDICATE_IMAGE;
        }
        if (crit instanceof ICompoundCriteria) {
            result = COMPOUND_CRITERIA_IMAGE;
        } else if (crit instanceof INotCriteria) {
            result = this.getNotCriteriaIcon((INotCriteria)crit);
        }
        return result;
    }

    public String getText(Object theElement) {
        String result = null;
        if (theElement == null) {
            result = "<undefined>";
        } else if (theElement instanceof ILanguageObject) {
            IQueryService queryService = ModelerCore.getTeiidQueryService();
            ISQLStringVisitor visitor = queryService.getSQLStringVisitor();
            result = visitor.returnSQLString((ILanguageObject)theElement);
        } else {
            result = super.getText(theElement);
        }
        return result;
    }
}

