/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.ui.sqleditor.component;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.query.sql.ISQLStringVisitor;
import org.teiid.designer.query.sql.IToken;
import org.teiid.designer.query.sql.lang.ICriteria;
import org.teiid.designer.query.sql.lang.IExpression;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.query.ui.sqleditor.component.CommentDisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNodeConstants;

public class DisplayNode
implements DisplayNodeConstants {
    protected int startIndex = 0;
    protected int endIndex = 0;
    protected DisplayNode parentNode = null;
    protected ILanguageObject languageObject = null;
    protected List<DisplayNode> childNodeList = new ArrayList<DisplayNode>(1);
    protected List<DisplayNode> displayNodeList = new ArrayList<DisplayNode>(1);
    protected List<CommentDisplayNode> commentNodeList = new ArrayList<CommentDisplayNode>(1);
    private boolean visible = true;

    protected DisplayNode() {
    }

    public DisplayNode getParent() {
        return this.parentNode;
    }

    public ILanguageObject getLanguageObject() {
        return this.languageObject;
    }

    public List<DisplayNode> getChildren() {
        return this.childNodeList;
    }

    public List getDisplayNodeList() {
        return this.displayNodeList;
    }

    public List<CommentDisplayNode> getCommentNodeList() {
        return this.commentNodeList;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible, boolean includeDescendents) {
        this.visible = visible;
        if (includeDescendents && this.childNodeList != null) {
            Iterator<DisplayNode> iter = this.childNodeList.iterator();
            while (iter.hasNext()) {
                iter.next().setVisible(visible, includeDescendents);
            }
        }
        if (this.displayNodeList != null) {
            for (DisplayNode node : this.displayNodeList) {
                if (node.parentNode != this) continue;
                node.setVisible(visible, includeDescendents);
            }
        }
    }

    private String escape(String text, String character, boolean optional) {
        String target = "\\" + character;
        String replacement = "\\\\" + character + (optional ? "?" : "");
        text = text.replaceAll(target, replacement);
        return text;
    }

    private int nextAvailableSpace(String sql, int index) {
        int i = index - 1;
        while (i < sql.length()) {
            char c = sql.charAt(i);
            if (System.lineSeparator().equals(Character.toString(c))) {
                return i + 1;
            }
            ++i;
        }
        return sql.length();
    }

    private int calculateLocation(String sql, CommentDisplayNode comment) {
        int cmtIdx = comment.getOffset();
        LinkedList<? extends IToken> preTokens = new LinkedList<IToken>(comment.getPreTokens());
        if (preTokens.isEmpty()) {
            return cmtIdx;
        }
        StringBuffer regex = new StringBuffer("(?is)");
        Iterator iterator = preTokens.iterator();
        while (iterator.hasNext()) {
            IToken token = (IToken)iterator.next();
            ISQLStringVisitor visitor = ModelerCore.getTeiidQueryService().getSQLStringVisitor();
            String text = visitor.displayName(token);
            text = this.escape(text, "?", false);
            text = this.escape(text, "\"", true);
            text = this.escape(text, "'", true);
            text = this.escape(text, "(", true);
            text = this.escape(text, ")", true);
            String target = "([0-9][0-9]:[0-9][0-9]:[0-9][0-9]\\.[0-9])0";
            String replacement = "$1[0-9]?'";
            text = text.replaceAll(target, replacement);
            target = "\\/\\*\\+\\s*sh";
            replacement = "/*+sh";
            text = text.replaceAll(target, replacement);
            text = this.escape(text, ".", false);
            text = this.escape(text, "{", false);
            text = this.escape(text, "}", true);
            text = this.escape(text, "/", false);
            text = this.escape(text, "*", false);
            text = this.escape(text, "+", false);
            text = this.escape(text, "|", false);
            regex.append(text);
            if (!iterator.hasNext()) continue;
            regex.append(".").append("*").append("?");
        }
        Pattern pattern = Pattern.compile(regex.toString());
        Matcher matcher = pattern.matcher(sql);
        ArrayList<Integer> results = new ArrayList<Integer>();
        boolean result = true;
        while (result) {
            result = matcher.find();
            if (!result) continue;
            results.add(matcher.end());
        }
        if (results.isEmpty()) {
            return -1;
        }
        Integer pref = (Integer)results.get(0);
        int diff = Math.abs(pref - cmtIdx);
        for (Integer poss : results) {
            int pdiff = Math.abs(poss - cmtIdx);
            if (pdiff >= diff) continue;
            pref = poss;
        }
        int offset = pref + 1;
        if (offset != cmtIdx) {
            cmtIdx = offset;
        }
        return this.nextAvailableSpace(sql, cmtIdx);
    }

    private int findIndentLevel(String sql, int index) {
        char c;
        int i;
        if (index == 0) {
            return 0;
        }
        if (index >= sql.length()) {
            return 0;
        }
        int nextTabs = 0;
        char prevChar = sql.charAt(index - 1);
        if (System.lineSeparator().equals(Character.toString(prevChar))) {
            int i2 = index;
            while (i2 < sql.length()) {
                char c2 = sql.charAt(i2);
                if (!System.lineSeparator().equals(Character.toString(c2))) {
                    if ('\t' == c2) {
                        ++nextTabs;
                    }
                    ++i2;
                    continue;
                }
                break;
            }
        } else {
            boolean count = false;
            i = index;
            while (i < sql.length() && index > 0) {
                c = sql.charAt(i);
                if (System.lineSeparator().equals(Character.toString(c))) {
                    count = true;
                } else if (count) {
                    if ('\t' != c) break;
                    ++nextTabs;
                }
                ++i;
            }
        }
        int prevTabs = 0;
        i = index - 1;
        while (i > 0 && index < sql.length()) {
            c = sql.charAt(i);
            if ('\t' == c) {
                ++prevTabs;
            } else if (prevTabs > 0) break;
            --i;
        }
        return Math.max(nextTabs, prevTabs);
    }

    private void addComments(StringBuffer buf) {
        for (CommentDisplayNode comment : this.commentNodeList) {
            String text = buf.toString();
            int insertIdx = this.calculateLocation(text, comment);
            if (insertIdx == -1) continue;
            int indentLevel = this.findIndentLevel(text, insertIdx);
            if (insertIdx >= text.length()) {
                if (!text.endsWith("\n")) {
                    buf.append("\n");
                }
                int i = 0;
                while (i < indentLevel) {
                    buf.append("\t");
                    ++i;
                }
                buf.append(comment.toDisplayString());
                if (comment.isMultiLine()) continue;
                buf.append("\n");
                continue;
            }
            StringBuffer cmt = new StringBuffer();
            int i = 0;
            while (i < indentLevel) {
                cmt.append("\t");
                ++i;
            }
            cmt.append(comment.toDisplayString());
            cmt.append("\n");
            buf.insert(insertIdx, cmt.toString());
        }
    }

    private String generateString() {
        ISQLStringVisitor sqlStringVisitor = ModelerCore.getTeiidQueryService().getSQLStringVisitor();
        sqlStringVisitor.disableComments((Object)this);
        StringBuffer sb = new StringBuffer();
        Iterator<DisplayNode> iter = this.displayNodeList.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toDisplayString());
        }
        this.addComments(sb);
        sqlStringVisitor.enableComments((Object)this);
        return sb.toString();
    }

    public String toDisplayString() {
        return this.generateString();
    }

    public String toString() {
        return this.generateString();
    }

    public boolean hasChildren() {
        return this.childNodeList != null && this.childNodeList.size() > 0;
    }

    public boolean hasDisplayNodes() {
        return this.displayNodeList.size() > 0;
    }

    public boolean supportsElement() {
        return false;
    }

    public boolean supportsGroup() {
        return false;
    }

    public boolean supportsExpression() {
        return this.isInExpression();
    }

    public boolean isInExpression() {
        return this.getExpression() != null;
    }

    public DisplayNode getExpression() {
        DisplayNode parentNode = this;
        while (parentNode != null) {
            if (parentNode.languageObject != null && parentNode.languageObject instanceof IExpression) {
                return parentNode;
            }
            parentNode = parentNode.getParent();
        }
        return null;
    }

    public boolean supportsCriteria() {
        return this.isInCriteria();
    }

    public boolean isInCriteria() {
        return this.getCriteria() != null;
    }

    public DisplayNode getCriteria() {
        DisplayNode parentNode = this;
        while (parentNode != null) {
            if (parentNode.languageObject instanceof ICriteria) {
                return parentNode;
            }
            parentNode = parentNode.getParent();
        }
        return null;
    }

    public int setStartIndex(int index) {
        this.startIndex = index;
        this.endIndex = index;
        Iterator<DisplayNode> iter = this.displayNodeList.iterator();
        DisplayNode node = null;
        if (iter.hasNext()) {
            node = iter.next();
            this.endIndex = node.setStartIndex(this.endIndex);
        }
        this.startIndex = this.endIndex + 1;
        while (iter.hasNext()) {
            node = iter.next();
            this.endIndex = node.setStartIndex(this.startIndex);
            this.startIndex = this.endIndex + 1;
        }
        for (DisplayNode displayNode : this.displayNodeList) {
            this.reindexParents(displayNode);
        }
        return this.endIndex;
    }

    private void reindexParents(DisplayNode node) {
        while (node != null) {
            List childDisplayNodes;
            int nd;
            DisplayNode parentNode = node.getParent();
            if (parentNode != null && (nd = (childDisplayNodes = parentNode.getDisplayNodeList()).size()) != 0) {
                parentNode.startIndex = ((DisplayNode)childDisplayNodes.get(0)).getStartIndex();
                parentNode.endIndex = ((DisplayNode)childDisplayNodes.get(nd - 1)).getEndIndex();
            }
            node = parentNode;
        }
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int length() {
        return this.endIndex - this.startIndex + 1;
    }

    public boolean isIndexAtStart(int index) {
        return index == this.startIndex;
    }

    public boolean isIndexAtEnd(int index) {
        return index == this.endIndex + 1;
    }

    public boolean isAnywhereWithin(int index) {
        return index >= this.startIndex && index <= this.endIndex + 1;
    }

    public boolean isWithin(int index) {
        return index > this.startIndex && index < this.endIndex + 1;
    }

    protected void addChildNode(DisplayNode child) {
        this.childNodeList.add(child);
        this.displayNodeList.add(child);
    }

    public void addCommentNode(CommentDisplayNode commentNode) {
        this.commentNodeList.add(commentNode);
    }
}

